/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.common;

import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.f;
import com.tencent.ugc.common.MediaExtractorBuilder;

public class VideoFrameRetriever {
    private static final String TAG = "VideoFrameRetriever";
    private final String mFilePath;
    private MediaMetadataRetriever mMediaMetadataRetriever;

    public VideoFrameRetriever(String path) {
        this.mFilePath = path;
    }

    public Bitmap getFrameAtTime(long time) {
        this.createMediaMetadataRetrieverIfNeed();
        if (this.mMediaMetadataRetriever == null) {
            return null;
        }
        Bitmap bitmap = null;
        try {
            bitmap = this.mMediaMetadataRetriever.getFrameAtTime(time);
        }
        catch (Throwable throwable) {
            LiteavLog.i(TAG, "get frame at time.", throwable);
        }
        return bitmap;
    }

    public void release() {
        if (this.mMediaMetadataRetriever == null) {
            return;
        }
        try {
            this.mMediaMetadataRetriever.release();
            this.mMediaMetadataRetriever = null;
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "mediaMetadataRetriever release.", throwable);
            return;
        }
    }

    private void createMediaMetadataRetrieverIfNeed() {
        if (this.mMediaMetadataRetriever != null) {
            return;
        }
        try {
            if (MediaExtractorBuilder.isContentUri(this.mFilePath)) {
                this.mMediaMetadataRetriever = new MediaMetadataRetriever();
                this.mMediaMetadataRetriever.setDataSource(ContextUtils.getApplicationContext(), Uri.parse((String)this.mFilePath));
                return;
            }
            if (f.a(this.mFilePath)) {
                this.mMediaMetadataRetriever = new MediaMetadataRetriever();
                this.mMediaMetadataRetriever.setDataSource(this.mFilePath);
            }
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "MediaMetadataRetriever build fail.".concat(String.valueOf(throwable)));
            this.release();
            return;
        }
    }
}

