/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.beauty.gpufilters.smooth;

import android.opengl.GLES20;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.beauty.NativeLoad;
import com.tencent.ugc.videobase.filter.TXCGPUTwoInputFilter;
import com.tencent.ugc.videobase.frame.GLTexturePool;

public class TXCTILSmoothVerticalFilter
extends TXCGPUTwoInputFilter {
    private static final String TAG = "SmoothVertical";
    private int mTexelWidthOffsetLocation = -1;
    private int mTexelHeightOffsetLocation = -1;
    private int mSmoothDegreeUniform = -1;
    private float mBeautyLevel = 0.0f;

    TXCTILSmoothVerticalFilter() {
        super(null, null);
    }

    @Override
    public int buildProgram() {
        if (LiteavSystemInfo.getBrand().equals("samsung") && LiteavSystemInfo.getModel().equals("GT-I9500") && LiteavSystemInfo.getSystemOSVersion().equals("4.3")) {
            LiteavLog.d(TAG, "SAMSUNG_S4 GT-I9500 + Android 4.3; use diffrent shader!");
            return NativeLoad.nativeLoadGLProgram(15);
        }
        return NativeLoad.nativeLoadGLProgram(5);
    }

    @Override
    public void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        this.mTexelWidthOffsetLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"texelWidthOffset");
        this.mTexelHeightOffsetLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"texelHeightOffset");
        this.mSmoothDegreeUniform = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"smoothDegree");
    }

    public void setBeautyLevel(float level) {
        LiteavLog.i(TAG, "setBeautyLevel ".concat(String.valueOf(level)));
        this.mBeautyLevel = level;
        TXCTILSmoothVerticalFilter tXCTILSmoothVerticalFilter = this;
        tXCTILSmoothVerticalFilter.setFloatOnDraw(tXCTILSmoothVerticalFilter.mSmoothDegreeUniform, level);
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        float f2 = width > height ? (height < 540 ? 2.0f : 4.0f) : (width < 540 ? 2.0f : 4.0f);
        LiteavLog.i(TAG, "mTextureRation ".concat(String.valueOf(f2)));
        TXCTILSmoothVerticalFilter tXCTILSmoothVerticalFilter = this;
        tXCTILSmoothVerticalFilter.setFloatOnDraw(tXCTILSmoothVerticalFilter.mTexelWidthOffsetLocation, f2 / (float)width);
        TXCTILSmoothVerticalFilter tXCTILSmoothVerticalFilter2 = this;
        tXCTILSmoothVerticalFilter2.setFloatOnDraw(tXCTILSmoothVerticalFilter2.mTexelHeightOffsetLocation, f2 / (float)height);
    }

    @Override
    public boolean canBeSkipped() {
        TXCTILSmoothVerticalFilter tXCTILSmoothVerticalFilter = this;
        return tXCTILSmoothVerticalFilter.isLessOrEqualZero(tXCTILSmoothVerticalFilter.mBeautyLevel);
    }
}

