/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.beauty.gpufilters.smooth;

import android.opengl.GLES20;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.frame.GLTexturePool;

public class TXCGPUSharpenAlphaFilter
extends TXCGPUImageFilter {
    private static final String TAG = "GPUSharpen";
    private static final float SHARPNESS_BASE_LEVEL = 0.7f;
    private static final String SHARPEN_VERTEX_SHADER = "attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n\nuniform float imageWidthFactor; \nuniform float imageHeightFactor; \n\nvarying vec2 textureCoordinate;\nvarying vec2 leftTextureCoordinate;\nvarying vec2 rightTextureCoordinate; \nvarying vec2 topTextureCoordinate;\nvarying vec2 bottomTextureCoordinate;\n\n\nvoid main()\n{\n    gl_Position = position;\n    \n    mediump vec2 widthStep = vec2(imageWidthFactor, 0.0);\n    mediump vec2 heightStep = vec2(0.0, imageHeightFactor);\n    \n    textureCoordinate = inputTextureCoordinate.xy;\n    leftTextureCoordinate = inputTextureCoordinate.xy - widthStep;\n    rightTextureCoordinate = inputTextureCoordinate.xy + widthStep;\n    topTextureCoordinate = inputTextureCoordinate.xy + heightStep;\n    bottomTextureCoordinate = inputTextureCoordinate.xy - heightStep;\n}\n";
    private static final String SHARPEN_FRAGMENT_SHADER = "precision mediump float;\n\nuniform float sharpness;\nvarying mediump vec2 textureCoordinate;\nvarying mediump vec2 leftTextureCoordinate;\nvarying mediump vec2 rightTextureCoordinate; \nvarying mediump vec2 topTextureCoordinate;\nvarying mediump vec2 bottomTextureCoordinate;\n\nuniform sampler2D inputImageTexture;\nfloat centerMultiplier;\nfloat edgeMultiplier;\n\nvoid main()\n{\n    mediump vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n    mediump vec3 leftTextureColor = texture2D(inputImageTexture, leftTextureCoordinate).rgb;\n    mediump vec3 rightTextureColor = texture2D(inputImageTexture, rightTextureCoordinate).rgb;\n    mediump vec3 topTextureColor = texture2D(inputImageTexture, topTextureCoordinate).rgb;\n    mediump vec3 bottomTextureColor = texture2D(inputImageTexture, bottomTextureCoordinate).rgb;\n\n    centerMultiplier = 1.0 + 4.0 * sharpness * (1.0 - textureColor.a);\n    edgeMultiplier = sharpness * (1.0 - textureColor.a);\n    gl_FragColor = vec4((textureColor.rgb * centerMultiplier - (leftTextureColor * edgeMultiplier + rightTextureColor * edgeMultiplier + topTextureColor * edgeMultiplier + bottomTextureColor * edgeMultiplier)), textureColor.a);    \n}\n";
    private int mAlphaSharpnessLocation;
    private float mAlphaSharpness;
    private int mAlphaImageWidthFactorLocation;
    private int mAlphaImageHeightFactorLocation;

    public TXCGPUSharpenAlphaFilter() {
        this(0.0f);
    }

    public TXCGPUSharpenAlphaFilter(float sharpness) {
        super(SHARPEN_VERTEX_SHADER, SHARPEN_FRAGMENT_SHADER);
        this.mAlphaSharpness = sharpness;
    }

    @Override
    public void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        this.mAlphaSharpnessLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"sharpness");
        this.mAlphaImageWidthFactorLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"imageWidthFactor");
        this.mAlphaImageHeightFactorLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"imageHeightFactor");
        TXCGPUSharpenAlphaFilter tXCGPUSharpenAlphaFilter = this;
        tXCGPUSharpenAlphaFilter.setSharpness(tXCGPUSharpenAlphaFilter.mAlphaSharpness);
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        TXCGPUSharpenAlphaFilter tXCGPUSharpenAlphaFilter = this;
        tXCGPUSharpenAlphaFilter.setFloatOnDraw(tXCGPUSharpenAlphaFilter.mAlphaImageWidthFactorLocation, 1.0f / (float)width);
        TXCGPUSharpenAlphaFilter tXCGPUSharpenAlphaFilter2 = this;
        tXCGPUSharpenAlphaFilter2.setFloatOnDraw(tXCGPUSharpenAlphaFilter2.mAlphaImageHeightFactorLocation, 1.0f / (float)height);
    }

    public void setSharpness(float sharpness) {
        LiteavLog.i(TAG, "setSharpness ".concat(String.valueOf(sharpness)));
        this.mAlphaSharpness = sharpness;
        TXCGPUSharpenAlphaFilter tXCGPUSharpenAlphaFilter = this;
        tXCGPUSharpenAlphaFilter.setFloatOnDraw(tXCGPUSharpenAlphaFilter.mAlphaSharpnessLocation, 0.7f + sharpness);
    }

    @Override
    public boolean canBeSkipped() {
        TXCGPUSharpenAlphaFilter tXCGPUSharpenAlphaFilter = this;
        return tXCGPUSharpenAlphaFilter.isLessOrEqualZero(tXCGPUSharpenAlphaFilter.mAlphaSharpness);
    }
}

