/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.beauty.gpufilters;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.beauty.gpufilters.WatermarkItem;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.List;

public class TXCGPUWatermarkFilter
extends TXCGPUImageFilter {
    private static final String TAG = "TXCGPUWatermarkFilter";
    protected static final short[] DRAW_ORDER = new short[]{1, 2, 0, 2, 0, 3};
    private static final float[] VERTICES_COORDS = new float[8];
    private static final float[] TEXTURE_COORDS = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f};
    protected static final FloatBuffer TEXTURE_COORDS_BUFFER = (FloatBuffer)ByteBuffer.allocateDirect(32).order(ByteOrder.nativeOrder()).asFloatBuffer().put(TEXTURE_COORDS).asReadOnlyBuffer().position(0);
    protected static final ShortBuffer DRAW_ORDER_BUFFER = (ShortBuffer)ByteBuffer.allocateDirect(DRAW_ORDER.length * 2).order(ByteOrder.nativeOrder()).asShortBuffer().put(DRAW_ORDER).asReadOnlyBuffer().position(0);
    public WatermarkRenderObject[] mRenderObjects = null;
    private WatermarkRenderObject mBaseWaterMark = null;
    protected List<WatermarkItem> mWaterMarkList = null;
    protected boolean mDrawWaterMarkEnabled = false;
    protected int mSrcBlendMode = 1;
    private int mBaseMarkOffset = 1;
    private WatermarkItem mWatermark = null;

    public TXCGPUWatermarkFilter() {
        this("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nuniform mat4 textureTransform;\nvarying highp vec2 textureCoordinate;\nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (textureTransform * inputTextureCoordinate).xy;\n}", "varying highp vec2 textureCoordinate;\n \nuniform sampler2D inputImageTexture;\n \nvoid main()\n{\n     gl_FragColor = texture2D(inputImageTexture, textureCoordinate);\n}");
    }

    public TXCGPUWatermarkFilter(String vertexShader, String fragmentShader) {
        super(vertexShader, fragmentShader);
    }

    @Override
    public void onUninit() {
        super.onUninit();
        this.releaseWaterMark();
    }

    @Override
    public void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        if (this.mWatermark != null) {
            TXCGPUWatermarkFilter tXCGPUWatermarkFilter = this;
            tXCGPUWatermarkFilter.setWatermark(tXCGPUWatermarkFilter.mWatermark.bitmap, this.mWatermark.xOffset, this.mWatermark.yOffset, this.mWatermark.fWidth);
        }
        if (this.mWaterMarkList != null) {
            TXCGPUWatermarkFilter tXCGPUWatermarkFilter = this;
            tXCGPUWatermarkFilter.setWaterMarkList(tXCGPUWatermarkFilter.mWaterMarkList);
        }
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        if (this.mRenderObjects == null) {
            return;
        }
        if (this.mWatermark != null && this.mWatermark.bitmap != null) {
            TXCGPUWatermarkFilter tXCGPUWatermarkFilter = this;
            tXCGPUWatermarkFilter.calculateOffsetMatrix(tXCGPUWatermarkFilter.mWatermark.bitmap.getWidth(), this.mWatermark.bitmap.getHeight(), this.mWatermark.xOffset, this.mWatermark.yOffset, this.mWatermark.fWidth, 0);
        }
        if (this.mWaterMarkList == null) {
            return;
        }
        for (int i2 = 0; i2 < this.mWaterMarkList.size(); ++i2) {
            WatermarkItem watermarkItem = this.mWaterMarkList.get(i2);
            if (watermarkItem == null || watermarkItem.bitmap == null) continue;
            this.calculateOffsetMatrix(watermarkItem.bitmap.getWidth(), watermarkItem.bitmap.getHeight(), watermarkItem.xOffset, watermarkItem.yOffset, watermarkItem.fWidth, i2 + this.mBaseMarkOffset);
        }
    }

    public void enableWatermark(boolean enable) {
        this.mDrawWaterMarkEnabled = enable;
    }

    private void setWatermark(Bitmap bitmap, float x2, float y2, float width, int index) {
        if (this.mRenderObjects == null || index >= this.mRenderObjects.length || null == this.mRenderObjects[index]) {
            LiteavLog.e(TAG, "index is too large for mRenderObjects!");
            return;
        }
        if (bitmap == null) {
            LiteavLog.i(TAG, "release %d watermark!", index);
            this.mRenderObjects[index].releaseResource();
            this.mRenderObjects[index] = null;
            return;
        }
        this.calculateOffsetMatrix(bitmap.getWidth(), bitmap.getHeight(), x2, y2, width, index);
        WatermarkRenderObject watermarkRenderObject = this.mRenderObjects[index];
        if (watermarkRenderObject.bitmap == null || !watermarkRenderObject.bitmap.equals(bitmap)) {
            if (watermarkRenderObject.textureId != -1 && watermarkRenderObject.bitmap != null && (watermarkRenderObject.bitmap.getWidth() != bitmap.getWidth() || watermarkRenderObject.bitmap.getHeight() != bitmap.getHeight())) {
                OpenGlUtils.deleteTexture(watermarkRenderObject.textureId);
                watermarkRenderObject.textureId = -1;
            }
            watermarkRenderObject.textureId = OpenGlUtils.loadTexture(bitmap, watermarkRenderObject.textureId, false);
        }
        watermarkRenderObject.bitmap = bitmap;
    }

    public void setWatermark(Bitmap bitmap, float x2, float y2, float width) {
        if (this.mRenderObjects == null) {
            this.mRenderObjects = new WatermarkRenderObject[1];
        }
        if (null == this.mRenderObjects[0]) {
            this.mRenderObjects[0] = new WatermarkRenderObject();
        }
        this.setWatermark(bitmap, x2, y2, width, 0);
        this.mBaseWaterMark = this.mRenderObjects[0];
        if (bitmap == null) {
            this.mWatermark = null;
            return;
        }
        if (this.mWatermark == null) {
            this.mWatermark = new WatermarkItem();
        }
        this.mWatermark.bitmap = bitmap;
        this.mWatermark.xOffset = x2;
        this.mWatermark.yOffset = y2;
        this.mWatermark.fWidth = width;
    }

    public void calculateOffsetMatrix(int dataWidth, int dataHeight, float x2, float y2, float width, int index) {
        if (this.mRenderObjects == null || index >= this.mRenderObjects.length || this.mRenderObjects[index] == null) {
            LiteavLog.e(TAG, "calculateOffsetMatrix,index[%d],mRenderObjects=%s", index, Arrays.toString(this.mRenderObjects));
            return;
        }
        this.mRenderObjects[index].vertexCoordsBuffer = ByteBuffer.allocateDirect(VERTICES_COORDS.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        float[] fArray = new float[VERTICES_COORDS.length];
        float[] fArray2 = fArray;
        fArray[0] = 2.0f * x2 - 1.0f;
        fArray2[1] = 1.0f - 2.0f * y2;
        fArray2[2] = fArray2[0];
        float f2 = (float)dataHeight / (float)dataWidth * width * (float)this.mOutputSize.width / (float)this.mOutputSize.height;
        fArray2[3] = fArray2[1] - 2.0f * f2;
        fArray2[4] = fArray2[0] + 2.0f * width;
        fArray2[5] = fArray2[3];
        fArray2[6] = fArray2[4];
        fArray2[7] = fArray2[1];
        for (int i2 = 1; i2 <= 7; i2 += 2) {
            int n2 = i2;
            fArray2[n2] = fArray2[n2] * -1.0f;
        }
        this.mRenderObjects[index].vertexCoordsBuffer.put(fArray2).position(0);
    }

    public void setWaterMarkList(List<WatermarkItem> markList) {
        int n2;
        if (this.mWaterMarkList != null) {
            TXCGPUWatermarkFilter tXCGPUWatermarkFilter = this;
            if (tXCGPUWatermarkFilter.compareWaterMarkList(tXCGPUWatermarkFilter.mWaterMarkList, markList)) {
                LiteavLog.i(TAG, "Same markList");
                return;
            }
        }
        this.mWaterMarkList = markList;
        if (this.mRenderObjects != null) {
            for (n2 = this.mBaseMarkOffset; n2 < this.mRenderObjects.length; ++n2) {
                OpenGlUtils.deleteTexture(this.mRenderObjects[n2].textureId);
                this.mRenderObjects[n2].textureId = -1;
            }
        }
        this.mRenderObjects = new WatermarkRenderObject[markList.size() + this.mBaseMarkOffset];
        this.mRenderObjects[0] = this.mBaseWaterMark;
        for (n2 = 0; n2 < markList.size(); ++n2) {
            WatermarkItem watermarkItem = markList.get(n2);
            if (watermarkItem == null) continue;
            this.mRenderObjects[n2 + this.mBaseMarkOffset] = new WatermarkRenderObject();
            this.setWatermark(watermarkItem.bitmap, watermarkItem.xOffset, watermarkItem.yOffset, watermarkItem.fWidth, n2 + this.mBaseMarkOffset);
        }
    }

    private boolean compareWaterMarkList(List<WatermarkItem> src1, List<WatermarkItem> src2) {
        if (src1.size() != src2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < src1.size(); ++i2) {
            WatermarkItem watermarkItem = src1.get(i2);
            WatermarkItem watermarkItem2 = src2.get(i2);
            if (watermarkItem.bitmap.equals(watermarkItem2.bitmap) && watermarkItem.xOffset == watermarkItem2.xOffset && watermarkItem.yOffset == watermarkItem2.yOffset && watermarkItem.fWidth == watermarkItem2.fWidth) continue;
            return false;
        }
        return true;
    }

    private void releaseWaterMark() {
        if (this.mRenderObjects == null || this.mRenderObjects.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < this.mRenderObjects.length; ++i2) {
            if (null == this.mRenderObjects[i2]) continue;
            this.mRenderObjects[i2].releaseResource();
            this.mRenderObjects[i2] = null;
        }
        this.mRenderObjects = null;
    }

    @Override
    public void afterDrawArrays() {
        super.afterDrawArrays();
        if (!this.mDrawWaterMarkEnabled) {
            return;
        }
        GLES20.glEnable((int)3042);
        GLES20.glBlendFunc((int)this.mSrcBlendMode, (int)771);
        for (int i2 = 0; i2 < this.mRenderObjects.length; ++i2) {
            if (this.mRenderObjects[i2] == null) continue;
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)this.mRenderObjects[i2].textureId);
            GLES20.glUniform1i((int)this.mGLUniformTexture, (int)0);
            GLES20.glVertexAttribPointer((int)this.mGLAttribPosition, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.mRenderObjects[i2].vertexCoordsBuffer);
            GLES20.glEnableVertexAttribArray((int)this.mGLAttribPosition);
            GLES20.glVertexAttribPointer((int)this.mGLAttribTextureCoord, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)TEXTURE_COORDS_BUFFER);
            GLES20.glEnableVertexAttribArray((int)this.mGLAttribTextureCoord);
            GLES20.glDrawElements((int)4, (int)DRAW_ORDER.length, (int)5123, (Buffer)DRAW_ORDER_BUFFER);
            GLES20.glDisableVertexAttribArray((int)this.mGLAttribPosition);
            GLES20.glDisableVertexAttribArray((int)this.mGLAttribTextureCoord);
        }
        GLES20.glDisable((int)3042);
    }

    public static class WatermarkRenderObject {
        public FloatBuffer vertexCoordsBuffer = null;
        public Bitmap bitmap;
        public int textureId = -1;

        public void releaseResource() {
            this.bitmap = null;
            OpenGlUtils.deleteTexture(this.textureId);
            this.textureId = -1;
        }
    }
}

