/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.beauty.gpufilters;

import android.opengl.GLES20;
import com.tencent.liteav.base.util.l;
import com.tencent.ugc.beauty.NativeLoad;
import com.tencent.ugc.beauty.gpufilters.BeautyInterFace;
import com.tencent.ugc.beauty.gpufilters.TXCGPUFaceFilter;
import com.tencent.ugc.beauty.gpufilters.TXCGPUSharpenFilter;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.filter.TXCGPUThreeInputFilter;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import java.nio.FloatBuffer;

public class BeautyBrightFilter
extends TXCGPUImageFilter
implements BeautyInterFace {
    private final FloatBuffer mNormalCubeVerticesBuffer = OpenGlUtils.createNormalCubeVerticesBuffer();
    private final FloatBuffer mNormalTextureCoordsBuffer = OpenGlUtils.createTextureCoordsBuffer(l.a, false, false);
    private final TXCGPUFaceFilter mNewFaceFilter = new TXCGPUFaceFilter();
    private final BeautyCoreFilter mBeautyCoreFilter = new BeautyCoreFilter();
    private final TXCGPUSharpenFilter mSharpenessFilter = new TXCGPUSharpenFilter();
    private float mBeautyLevel = 0.0f;
    private float mWhiteLevel = 0.0f;
    private float mRuddyLevel = 0.0f;
    private float mSharpnessLevel = 0.0f;

    @Override
    public void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        this.mNewFaceFilter.initialize(texturePool);
        this.mBeautyCoreFilter.initialize(texturePool);
        this.mSharpenessFilter.initialize(texturePool);
    }

    @Override
    public void onDraw(int inTextureId, GLTexture outFrameBuffer, FloatBuffer cubeCoordsBuffer, FloatBuffer textureCoordsBuffer) {
        if (!this.isInitialized()) {
            return;
        }
        this.runPendingOnDrawTasks();
        GLTexture gLTexture = null;
        int n2 = inTextureId;
        if (this.mBeautyLevel > 0.0f || this.mWhiteLevel > 0.0f || this.mRuddyLevel > 0.0f) {
            GLTexture gLTexture2 = null;
            if (this.mBeautyLevel != 0.0f) {
                gLTexture2 = this.mTexturePool.obtain(this.mOutputSize.width, this.mOutputSize.height);
                this.mNewFaceFilter.onDraw(inTextureId, gLTexture2, cubeCoordsBuffer, textureCoordsBuffer);
                n2 = gLTexture2.getId();
                cubeCoordsBuffer = this.mNormalCubeVerticesBuffer;
                textureCoordsBuffer = this.mNormalTextureCoordsBuffer;
            }
            gLTexture = this.mTexturePool.obtain(this.mOutputSize.width, this.mOutputSize.height);
            this.mBeautyCoreFilter.setSecondInputTexture(inTextureId);
            if (this.mSharpnessLevel > 0.0f) {
                this.mBeautyCoreFilter.onDraw(n2, gLTexture, cubeCoordsBuffer, textureCoordsBuffer);
            } else {
                this.mBeautyCoreFilter.onDraw(n2, outFrameBuffer, cubeCoordsBuffer, textureCoordsBuffer);
            }
            n2 = gLTexture.getId();
            cubeCoordsBuffer = this.mNormalCubeVerticesBuffer;
            textureCoordsBuffer = this.mNormalTextureCoordsBuffer;
            if (gLTexture2 != null) {
                gLTexture2.release();
            }
        }
        if (this.mSharpnessLevel > 0.0f || n2 == inTextureId) {
            this.mSharpenessFilter.onDraw(n2, outFrameBuffer, cubeCoordsBuffer, textureCoordsBuffer);
        }
        if (gLTexture != null) {
            gLTexture.release();
        }
    }

    @Override
    public boolean canBeSkipped() {
        BeautyBrightFilter beautyBrightFilter = this;
        if (beautyBrightFilter.isLessOrEqualZero(beautyBrightFilter.mBeautyLevel)) {
            BeautyBrightFilter beautyBrightFilter2 = this;
            if (beautyBrightFilter2.isLessOrEqualZero(beautyBrightFilter2.mWhiteLevel)) {
                BeautyBrightFilter beautyBrightFilter3 = this;
                if (beautyBrightFilter3.isLessOrEqualZero(beautyBrightFilter3.mRuddyLevel)) {
                    BeautyBrightFilter beautyBrightFilter4 = this;
                    if (beautyBrightFilter4.isLessOrEqualZero(beautyBrightFilter4.mSharpnessLevel)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        this.mBeautyCoreFilter.onOutputSizeChanged(width, height);
        this.mNewFaceFilter.onOutputSizeChanged(width, height);
        this.mSharpenessFilter.onOutputSizeChanged(width, height);
    }

    @Override
    public void onUninit() {
        super.onUninit();
        this.mBeautyCoreFilter.uninitialize();
        this.mNewFaceFilter.uninitialize();
        this.mSharpenessFilter.uninitialize();
    }

    @Override
    public void setBeautyLevel(float level) {
        this.mBeautyLevel = level;
        this.mBeautyCoreFilter.setBeautyLevel(level);
    }

    @Override
    public void setWhitenessLevel(float level) {
        this.mWhiteLevel = level;
        this.mBeautyCoreFilter.setBrightLevel(level);
    }

    @Override
    public void setRuddyLevel(float level) {
        this.mRuddyLevel = level;
        this.mBeautyCoreFilter.setRuddyLevel(level);
    }

    @Override
    public void setSharpenLevel(float level) {
        this.mSharpnessLevel = level / 1.5f;
        this.mSharpenessFilter.setSharpness(this.mSharpnessLevel);
    }

    private static float getNewBeautyLevel(float level) {
        float f2 = level;
        if (level > 1.0f) {
            if ((double)level < 2.5) {
                f2 = BeautyBrightFilter.getValue((level - 1.0f) / 1.5f, 1.0f, 4.1f);
            } else if (level < 4.0f) {
                f2 = BeautyBrightFilter.getValue((level - 2.5f) / 1.5f, 4.1f, 5.6f);
            } else if ((double)level < 5.5) {
                f2 = BeautyBrightFilter.getValue((level - 4.0f) / 1.5f, 5.6f, 6.8f);
            } else if ((double)level <= 7.0) {
                f2 = BeautyBrightFilter.getValue((level - 5.5f) / 1.5f, 6.8f, 7.0f);
            }
            return f2 / 10.0f;
        }
        return 0.1f;
    }

    private static float getValue(float ratio, float start, float end) {
        return start + (end - start) * ratio;
    }

    public static class BeautyCoreFilter
    extends TXCGPUThreeInputFilter {
        private int mBeautyDegreeLocation = -1;
        private int mBrightDegreeLocation = -1;
        private int mRuddyLocation = -1;

        public BeautyCoreFilter() {
            super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nattribute vec4 inputTextureCoordinate2;\nattribute vec4 inputTextureCoordinate3;\n \nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate2;\nvarying vec2 textureCoordinate3;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n    textureCoordinate2 = inputTextureCoordinate2.xy;\n    textureCoordinate3 = inputTextureCoordinate3.xy;\n}", "varying highp vec2 textureCoordinate;\n \nuniform sampler2D inputImageTexture;\n \nvoid main()\n{\n     gl_FragColor = texture2D(inputImageTexture, textureCoordinate);\n}");
        }

        @Override
        public int buildProgram() {
            return NativeLoad.nativeLoadGLProgram(1);
        }

        @Override
        public void onInit(GLTexturePool texturePool) {
            super.onInit(texturePool);
            this.mBeautyDegreeLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"smoothDegree");
            this.mBrightDegreeLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"brightDegree");
            this.mRuddyLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"ruddyDegree");
        }

        public void setBeautyLevel(float level) {
            BeautyCoreFilter beautyCoreFilter = this;
            beautyCoreFilter.setFloatOnDraw(beautyCoreFilter.mBeautyDegreeLocation, BeautyBrightFilter.getNewBeautyLevel(level));
        }

        public void setBrightLevel(float level) {
            BeautyCoreFilter beautyCoreFilter = this;
            beautyCoreFilter.setFloatOnDraw(beautyCoreFilter.mBrightDegreeLocation, level / 3.0f);
        }

        public void setRuddyLevel(float level) {
            BeautyCoreFilter beautyCoreFilter = this;
            beautyCoreFilter.setFloatOnDraw(beautyCoreFilter.mRuddyLocation, level / 10.0f / 2.0f);
        }
    }
}

