/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.beauty.decoder;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.SurfaceTexture;
import android.os.SystemClock;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.beauty.decoder.Decoder;
import com.tencent.ugc.beauty.decoder.Extractor;
import com.tencent.ugc.beauty.decoder.ExtractorAdvancer;
import com.tencent.ugc.beauty.decoder.Frame;
import com.tencent.ugc.beauty.decoder.ProcessException;
import com.tencent.ugc.beauty.decoder.RangeExtractorAdvancer;
import com.tencent.ugc.beauty.decoder.SetupException;
import com.tencent.ugc.beauty.decoder.a;
import com.tencent.ugc.videobase.egl.EGLCore;
import com.tencent.ugc.videobase.egl.EGLException;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.frame.TextureHolderPool;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import java.io.IOException;

public class VideoFrameReader
implements SurfaceTexture.OnFrameAvailableListener {
    private static final String TAG = "VideoFrameReader";
    private static final int DEFAULT_FRAME_PROCESS_INTERVAL = 3;
    private final Context mContext;
    private final String mVideoPath;
    private final boolean mIsLoop;
    private final Object mSharedGLContext;
    private final float[] mMatrix = new float[16];
    private Thread mThread;
    private EGLCore mEGLCore;
    private SurfaceTexture mSurfaceTexture;
    private TextureHolderPool mTextureHolderPool;
    private int mOesTextureId = -1;
    private int mVideoWidth = 0;
    private int mVideoHeight = 0;
    private volatile boolean mNeedUpdateTexture = false;
    private volatile boolean mIsCancelled = false;
    private long mStartTimeMs = -1L;
    private Decoder mVideoDecoder;
    private VideoFrameReaderListener mReadListener;

    public VideoFrameReader(Context context, Object sharedGLContext, String filepath, boolean loop) {
        this.mContext = context.getApplicationContext();
        this.mVideoPath = filepath;
        this.mIsLoop = loop;
        this.mSharedGLContext = sharedGLContext;
    }

    public synchronized boolean start() {
        if (this.mThread != null) {
            LiteavLog.i(TAG, "already started");
            return false;
        }
        this.mThread = new Thread(a.a(this), "videoframereader");
        this.mThread.start();
        return true;
    }

    public synchronized void setVideoFrameReadListener(VideoFrameReaderListener listener) {
        this.mReadListener = listener;
    }

    public synchronized void stop() {
        this.mIsCancelled = true;
        if (this.mThread != null) {
            this.mThread.interrupt();
            this.mThread = null;
        }
    }

    private void threadLoop() {
        try {
            this.setup();
            while (!this.mIsCancelled) {
                long l2 = SystemClock.elapsedRealtime();
                this.processFrame();
                long l3 = SystemClock.elapsedRealtime() - l2;
                if (l3 >= 3L) continue;
                try {
                    Thread.sleep(3L - l3);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "process failed.", throwable);
            return;
        }
        finally {
            this.release();
        }
    }

    private void setup() throws SetupException {
        AssetFileDescriptor assetFileDescriptor;
        Extractor extractor;
        this.mEGLCore = new EGLCore();
        try {
            this.mEGLCore.initialize(this.mSharedGLContext, null, 128, 128);
            this.mEGLCore.makeCurrent();
        }
        catch (EGLException eGLException) {
            throw new SetupException("EGL create failed", eGLException);
        }
        this.mOesTextureId = OpenGlUtils.generateTextureOES();
        this.mSurfaceTexture = new SurfaceTexture(this.mOesTextureId);
        this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.mTextureHolderPool = new TextureHolderPool(1);
        RangeExtractorAdvancer rangeExtractorAdvancer = new RangeExtractorAdvancer();
        if (this.mVideoPath.startsWith("/")) {
            extractor = new Extractor(true, this.mVideoPath, (ExtractorAdvancer)rangeExtractorAdvancer);
        } else {
            try {
                assetFileDescriptor = this.mContext.getAssets().openFd(this.mVideoPath);
                extractor = new Extractor(true, assetFileDescriptor, (ExtractorAdvancer)rangeExtractorAdvancer);
            }
            catch (IOException iOException) {
                throw new SetupException("open assets failed. " + this.mVideoPath, iOException);
            }
        }
        this.mVideoDecoder = new Decoder(extractor, this.mSurfaceTexture);
        this.mVideoDecoder.setLooping(this.mIsLoop);
        this.mVideoDecoder.setup();
        assetFileDescriptor = extractor.getMediaFormat();
        int n2 = 0;
        if (assetFileDescriptor.containsKey("rotation-degrees")) {
            n2 = assetFileDescriptor.getInteger("rotation-degrees");
        }
        if (n2 == 90 || n2 == 270) {
            this.mVideoWidth = assetFileDescriptor.getInteger("height");
            this.mVideoHeight = assetFileDescriptor.getInteger("width");
        } else {
            this.mVideoWidth = assetFileDescriptor.getInteger("width");
            this.mVideoHeight = assetFileDescriptor.getInteger("height");
        }
        LiteavLog.i(TAG, "setup finished");
    }

    protected void processFrame() throws ProcessException {
        if (this.mStartTimeMs == -1L) {
            this.mStartTimeMs = SystemClock.elapsedRealtime();
        }
        if (this.mNeedUpdateTexture) {
            VideoFrameReaderListener videoFrameReaderListener;
            this.mNeedUpdateTexture = false;
            long l2 = this.mSurfaceTexture.getTimestamp() / 1000000L;
            TextureHolderPool.TextureHolder textureHolder = null;
            try {
                textureHolder = (TextureHolderPool.TextureHolder)this.mTextureHolderPool.obtain();
            }
            catch (InterruptedException interruptedException) {}
            if (textureHolder == null) {
                return;
            }
            this.mSurfaceTexture.updateTexImage();
            textureHolder.updateTexture(36197, this.mOesTextureId, this.mVideoWidth, this.mVideoHeight);
            textureHolder.setColorFormat(GLConstants.ColorRange.b, GLConstants.ColorSpace.b);
            PixelFrame pixelFrame = textureHolder.wrap(this.mEGLCore.getEglContext());
            pixelFrame.setTimestamp(l2);
            this.mSurfaceTexture.getTransformMatrix(this.mMatrix);
            pixelFrame.setMatrix(this.mMatrix);
            pixelFrame.setGLContext(this.mEGLCore.getEglContext());
            long l3 = SystemClock.elapsedRealtime() - this.mStartTimeMs;
            if (l2 > l3) {
                try {
                    Thread.sleep(l2 - l3);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            if ((videoFrameReaderListener = this.mReadListener) != null) {
                videoFrameReaderListener.onFrameAvailable(pixelFrame);
            }
            textureHolder.release();
            pixelFrame.release();
        }
        if (this.mVideoDecoder.isDone()) {
            VideoFrameReaderListener videoFrameReaderListener = this.mReadListener;
            if (videoFrameReaderListener != null) {
                LiteavLog.i(TAG, "notify read finished");
                videoFrameReaderListener.onReadFinished();
            }
            this.mReadListener = null;
            return;
        }
        this.mVideoDecoder.processFrame();
        Frame frame = (Frame)this.mVideoDecoder.dequeueOutputBuffer();
        if (frame != null) {
            this.mVideoDecoder.enqueueOutputBuffer(frame);
        }
    }

    protected void release() {
        if (this.mOesTextureId != -1) {
            OpenGlUtils.deleteTexture(this.mOesTextureId);
            this.mOesTextureId = -1;
        }
        if (this.mTextureHolderPool != null) {
            this.mTextureHolderPool.destroy();
        }
        EGLCore.destroy(this.mEGLCore);
        this.mEGLCore = null;
        if (this.mVideoDecoder != null) {
            this.mVideoDecoder.release();
            this.mVideoDecoder = null;
        }
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.release();
            this.mSurfaceTexture = null;
        }
        LiteavLog.i(TAG, "released");
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        this.mNeedUpdateTexture = true;
    }

    static /* synthetic */ void access$lambda$0(VideoFrameReader videoFrameReader) {
        videoFrameReader.threadLoop();
    }

    public static interface VideoFrameReaderListener {
        public void onFrameAvailable(PixelFrame var1);

        public void onReadFinished();
    }
}

