/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.beauty.decoder;

import com.tencent.ugc.beauty.decoder.ProcessException;
import com.tencent.ugc.beauty.decoder.Provider;
import com.tencent.ugc.beauty.decoder.Stage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public abstract class ProvidedStage<T>
extends Stage
implements Provider<T> {
    protected final Queue<T> mWaitOutBuffers = new LinkedList<T>();
    protected final Queue<T> mRecycledBuffers = new LinkedList<T>();
    protected int mBufferOutedCount = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T dequeueOutputBuffer() {
        ProvidedStage providedStage = this;
        synchronized (providedStage) {
            T t2 = this.mWaitOutBuffers.poll();
            if (t2 != null) {
                ++this.mBufferOutedCount;
            }
            return t2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueueOutputBuffer(T buffer) {
        ProvidedStage providedStage = this;
        synchronized (providedStage) {
            --this.mBufferOutedCount;
            this.mRecycledBuffers.add(buffer);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processFrame() throws ProcessException {
        ArrayList<T> arrayList;
        ProvidedStage providedStage = this;
        synchronized (providedStage) {
            arrayList = new ArrayList<T>(this.mRecycledBuffers);
            this.mRecycledBuffers.clear();
        }
        this.recycleBuffers(arrayList);
        providedStage = this;
        synchronized (providedStage) {
            if (this.isAllDataReady() && this.noBufferKeepByUs()) {
                this.setState(Stage.State.DONE);
            }
            return;
        }
    }

    public void drainOutputBuffers() {
        T t2 = this.dequeueOutputBuffer();
        if (t2 != null) {
            this.enqueueOutputBuffer(t2);
        }
    }

    protected abstract void recycleBuffers(List<T> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean noBufferKeepByUs() {
        ProvidedStage providedStage = this;
        synchronized (providedStage) {
            return this.mRecycledBuffers.isEmpty() && this.mWaitOutBuffers.isEmpty() && this.mBufferOutedCount == 0;
        }
    }
}

