/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.l;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.TXVideoEditer;
import com.tencent.ugc.UGCAVSyncer;
import com.tencent.ugc.UGCCombineProcessor;
import com.tencent.ugc.UGCFrameRateFilter;
import com.tencent.ugc.UGCMediaListSource;
import com.tencent.ugc.UGCTransitionProcessor;
import com.tencent.ugc.datereport.UGCDataReport;
import com.tencent.ugc.encoder.UGCVideoEncodeController;
import com.tencent.ugc.encoder.UGCVideoEncoderJNI;
import com.tencent.ugc.encoder.VideoEncodeParams;
import com.tencent.ugc.gq;
import com.tencent.ugc.gr;
import com.tencent.ugc.gs;
import com.tencent.ugc.gt;
import com.tencent.ugc.gu;
import com.tencent.ugc.gv;
import com.tencent.ugc.gw;
import com.tencent.ugc.gx;
import com.tencent.ugc.gy;
import com.tencent.ugc.gz;
import com.tencent.ugc.ha;
import com.tencent.ugc.hb;
import com.tencent.ugc.hc;
import com.tencent.ugc.hd;
import com.tencent.ugc.he;
import com.tencent.ugc.hf;
import com.tencent.ugc.hg;
import com.tencent.ugc.hh;
import com.tencent.ugc.hi;
import com.tencent.ugc.hj;
import com.tencent.ugc.hk;
import com.tencent.ugc.hl;
import com.tencent.ugc.renderer.VideoRenderListener;
import com.tencent.ugc.renderer.VideoRenderer;
import com.tencent.ugc.videobase.common.EncodedVideoFrame;
import com.tencent.ugc.videobase.egl.EGLCore;
import com.tencent.ugc.videobase.egl.EGLException;
import com.tencent.ugc.videobase.frame.FrameMetaData;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.frame.PixelFrameRenderer;
import com.tencent.ugc.videoprocessor.SpeedProcessor;
import com.tencent.ugc.videoprocessor.VideoEffectProcessor;
import com.tencent.ugc.videoprocessor.VideoProcessManager;
import com.tencent.ugc.videoprocessor.VideoTransitionProcessor;
import com.tencent.ugc.videoprocessor.WatermarkProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class UGCVideoProcessor {
    private final String mTag = "UGCVideoProcessor_" + this.hashCode();
    private final com.tencent.liteav.base.b.b mThrottlers = new com.tencent.liteav.base.b.b();
    private final VideoProcessManager mVideoProcessManager;
    private boolean mIsInit = false;
    private EGLCore mEGLCore;
    private CustomHandler mVideoProcessHandler;
    private HandlerThread mRenderThread;
    private UGCMediaListSource mUGCMediaListSource;
    private final UGCAVSyncer mUGCAVSyncer;
    private VideoRenderer mRenderer;
    private a mStatus;
    private PixelFrame mLastFrameOfReadFromSource;
    private SpeedProcessor mSpeedProcessor;
    private UGCTransitionProcessor mUGCTransitionProcessor;
    private UGCCombineProcessor mUGCCombineProcessor;
    private GLTexturePool mGLTexturePool;
    private int mTransitionType = -1;
    private UGCVideoEncodeController mVideoEncodeController;
    private long mFinalPts = -1L;
    private DisplayTarget mDisplayTarget;
    private GLConstants.GLScaleType mScaleType = GLConstants.GLScaleType.b;
    private l mRotation = l.a;
    private VideoEncodeParams mVideoEncodeParams;
    private boolean mIsRecord = false;
    private VideoProcessListener mVideoProcessListener;
    private VideoEncodedFrameListener mVideoEncodedFrameListener;
    private static final int MSG_START = 100;
    private static final int MSG_PROCESS_FROM_SOURCE = 101;
    private static final int MSG_PAUSE = 102;
    private static final int MSG_STOP = 103;
    private static final int MSG_REFRESH = 104;
    private static final int MSG_FORCE_PROCESS = 105;
    private boolean mInvalidate;
    private Object mCurEGLContext = null;
    private int mCurEGLWidth = -1;
    private int mCurEGLHeight = -1;
    private int mOutputWidth = -1;
    private int mOutputHeight = -1;
    private PixelFrameRenderer mPreScaleRenderer;
    private List<TXVideoEditConstants.TXAbsoluteRect> mRectList;
    private AtomicReference<Long> mTargetSeekPts = new AtomicReference();
    private final long MIN_SEEK_DIR = 100L;
    private long mLastProcessFramePts = -1L;
    private boolean mReverse = false;
    private boolean mHasFirstFrameProcessed = false;
    private int mSkipFrameCount = 0;
    private final int MAX_SKIP_FRAME_COUNT = 3;
    private UGCVideoEncoderJNI.EncoderType mUsingEncoderType = UGCVideoEncoderJNI.EncoderType.HARDWARE;
    private UGCVideoEncoderJNI.UGCVideoEncoderListener mUGCVideoEncoderListener;
    private UGCFrameRateFilter mFrameRateFilter;
    private final VideoRenderListener mVideoRenderListener = new VideoRenderListener(){

        @Override
        public final void onRenderTargetSizeChanged(int width, int height) {
            LiteavLog.i(UGCVideoProcessor.this.mTag, "onRenderSizeChange " + width + "," + height);
            UGCVideoProcessor.this.runOnVideoProcessHandler(hj.a(this, width, height));
        }

        static /* synthetic */ void a(1 var0, int n2, int n3) {
            var0.UGCVideoProcessor.this.mVideoProcessManager.setOutputSize(n2, n3);
        }
    };
    private TXVideoEditer.TXVideoCustomProcessListener mTXVideoCustomProcessListener;
    private Runnable onCompleteBroadcastRunnable = gq.a(this);

    public UGCVideoProcessor(Context context, UGCMediaListSource source, UGCAVSyncer syncer, boolean isEnterpriseProEnabled) {
        this.mUGCMediaListSource = source;
        this.mUGCAVSyncer = syncer;
        this.mVideoProcessManager = new VideoProcessManager(context, isEnterpriseProEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        if (this.mIsInit) {
            return;
        }
        this.mIsInit = true;
        LiteavLog.i(this.mTag, "initialize: ");
        HandlerThread handlerThread = new HandlerThread("VideoProcess_" + this.hashCode());
        handlerThread.start();
        UGCVideoProcessor uGCVideoProcessor = this;
        synchronized (uGCVideoProcessor) {
            this.mVideoProcessHandler = new CustomHandler(handlerThread.getLooper(), hb.a(this));
            return;
        }
    }

    private void stopEncoder() {
        if (this.mVideoEncodeController == null) {
            return;
        }
        this.mFinalPts = -1L;
        this.mVideoEncodeController.signalEndOfStream();
        this.mVideoEncodeController.stop();
        this.mVideoEncodeController = null;
        if (this.mFrameRateFilter != null) {
            this.mFrameRateFilter = null;
        }
    }

    public void unInitialize() {
        if (!this.mIsInit) {
            return;
        }
        this.mIsInit = false;
        LiteavLog.i(this.mTag, "uninitialize");
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(hc.a(uGCVideoProcessor));
    }

    public void start(boolean isRecord, UGCVideoEncoderJNI.EncoderType encoderType) {
        LiteavLog.i(this.mTag, "start: ".concat(String.valueOf(isRecord)));
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(hd.a(uGCVideoProcessor, isRecord, encoderType));
        this.sendMsgToVideoProcessHandler(100);
        this.sendMsgToVideoProcessHandler(101);
    }

    private void initEncoder() {
        LiteavLog.i(this.mTag, "init encoder");
        if (this.mVideoEncodeParams == null) {
            LiteavLog.e(this.mTag, "video encode params is null");
            return;
        }
        if (this.mVideoEncodeController != null) {
            this.mVideoEncodeController.stop();
        }
        this.mVideoEncodeController = new UGCVideoEncodeController(this.mUsingEncoderType);
        this.mUGCVideoEncoderListener = new b(0);
        this.mVideoEncodeController.start(this.mVideoEncodeParams, this.mUGCVideoEncoderListener);
        if (this.mVideoEncodedFrameListener != null) {
            this.mVideoEncodedFrameListener.onVideoEncodeStarted();
        }
        this.mFinalPts = -1L;
    }

    private void initRenderer() {
        if (this.mRenderer != null) {
            return;
        }
        if (this.mRenderThread == null) {
            this.mRenderThread = new HandlerThread("VideoProcessRender" + this.hashCode());
            this.mRenderThread.start();
        }
        this.mRenderer = new VideoRenderer(this.mRenderThread.getLooper());
        if (this.mDisplayTarget != null) {
            this.mRenderer.setDisplayView(this.mDisplayTarget, true);
            this.mRenderer.setScaleType(this.mScaleType);
        }
        this.mRenderer.start(this.mVideoRenderListener);
    }

    public void stop() {
        LiteavLog.i(this.mTag, "stop: ");
        this.removeMsgFromVideoProcessHandler(101);
        this.sendMsgToVideoProcessHandler(103);
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(he.a(uGCVideoProcessor));
    }

    public void seekTo(long time) {
        this.mTargetSeekPts.set(time);
        this.removeMsgFromVideoProcessHandler(105);
        this.sendMsgToVideoProcessHandler(105);
    }

    public void setFilteredFrameRate(int frameRate) {
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(hf.a(uGCVideoProcessor, frameRate));
    }

    private void onCompleteBroadcast() {
        if (this.mVideoProcessListener != null) {
            TXVideoEditConstants.TXGenerateResult tXGenerateResult = new TXVideoEditConstants.TXGenerateResult();
            new TXVideoEditConstants.TXGenerateResult().retCode = 0;
            tXGenerateResult.descMsg = "";
            this.mVideoProcessListener.onComplete(tXGenerateResult);
        }
    }

    private boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 100: {
                this.mStatus = a.b;
                if (this.mIsRecord) {
                    this.initEncoder();
                    break;
                }
                this.initRenderer();
                break;
            }
            case 102: {
                this.mStatus = a.c;
                break;
            }
            case 103: {
                if (this.mLastFrameOfReadFromSource != null) {
                    this.mLastFrameOfReadFromSource.release();
                    this.mLastFrameOfReadFromSource = null;
                }
                this.mStatus = a.a;
                break;
            }
            case 104: {
                if (this.mStatus == a.b || this.mLastFrameOfReadFromSource == null) break;
                this.mVideoProcessManager.processFrame(this.mLastFrameOfReadFromSource);
                break;
            }
            case 105: {
                LiteavLog.i(this.mTag, "handleMessage: MSG_FORCE_PROCESS");
                this.removeMsgFromVideoProcessHandler(105);
                this.mInvalidate = true;
            }
            case 101: {
                if (this.mStatus != a.b && !this.mInvalidate) {
                    LiteavLog.e(this.mTag, "MSG_PROCESS_FROM_SOURCE FAILD AS mStatus == " + (Object)((Object)this.mStatus));
                    return true;
                }
                this.processFrame();
                this.mInvalidate = false;
            }
        }
        return true;
    }

    public void setSplitScreenList(List<TXVideoEditConstants.TXAbsoluteRect> rectList, int canvasWidth, int canvasHeight) {
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(hg.a(uGCVideoProcessor, rectList, canvasWidth, canvasHeight));
    }

    public void setOutputSize(int width, int height, GLConstants.GLScaleType scaleType) {
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(hh.a(uGCVideoProcessor, width, height, scaleType));
    }

    private PixelFrame preScale(PixelFrame frameIn) {
        int n2 = this.mOutputWidth;
        int n3 = this.mOutputHeight;
        if (this.mRotation == l.b || this.mRotation == l.d) {
            n2 = this.mOutputHeight;
            n3 = this.mOutputWidth;
        }
        if (this.mEGLCore == null || n2 <= 0 || n3 <= 0 || frameIn.getWidth() == n2 && frameIn.getHeight() == n3) {
            frameIn.retain();
            return frameIn;
        }
        if (this.mPreScaleRenderer == null) {
            this.mPreScaleRenderer = new PixelFrameRenderer(n2, n3);
        }
        this.mPreScaleRenderer.setOutputSize(n2, n3);
        GLTexture gLTexture = this.mGLTexturePool.obtain(n2, n3);
        gLTexture.setColorFormat(frameIn.getColorRange(), frameIn.getColorSpace());
        this.mPreScaleRenderer.renderFrame(frameIn, this.mScaleType, gLTexture);
        PixelFrame pixelFrame = gLTexture.wrap(frameIn.getGLContext());
        pixelFrame.setTimestamp(frameIn.getTimestamp());
        gLTexture.release();
        return pixelFrame;
    }

    public void setDisplayView(DisplayTarget displayTarget, GLConstants.GLScaleType scaleType) {
        LiteavLog.i(this.mTag, "setDisplayView: displayTarget:" + displayTarget + "scaleType:" + (Object)((Object)scaleType));
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(hi.a(uGCVideoProcessor, displayTarget, scaleType));
    }

    public void setRenderRotation(l rotation) {
        LiteavLog.i(this.mTag, "setRenderRotation: ".concat(String.valueOf((Object)rotation)));
        if (rotation == null) {
            return;
        }
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gr.a(uGCVideoProcessor, rotation));
        this.sendMsgToVideoProcessHandler(104);
    }

    public void setEncodeParams(VideoEncodeParams encodeParams) {
        LiteavLog.i(this.mTag, "setEncodeParams: ".concat(String.valueOf(encodeParams)));
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gs.a(uGCVideoProcessor, encodeParams));
    }

    public void setVideoEncodedFrameListener(VideoEncodedFrameListener listener) {
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gt.a(uGCVideoProcessor, listener));
    }

    public void setPictureTransition(int type) {
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gu.a(uGCVideoProcessor, type));
    }

    public void setSpeedList(List<TXVideoEditConstants.TXSpeed> speedList) {
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gv.a(uGCVideoProcessor, speedList));
    }

    public WatermarkProcessor getWatermarkProcessor() {
        return this.mVideoProcessManager.getWatermarkProcessor();
    }

    public VideoEffectProcessor getEffectProcessor() {
        return this.mVideoProcessManager.getEffectProcessor();
    }

    public VideoTransitionProcessor getTransitionProcessor() {
        return this.mVideoProcessManager.getTransitionProcessor();
    }

    public void setBeautyFilter(int beautyLevel, int whiteningLevel) {
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gw.a(uGCVideoProcessor, beautyLevel, whiteningLevel));
    }

    public void setSpecialRatio(float specialRatio) {
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gx.a(uGCVideoProcessor, specialRatio));
        this.sendMsgToVideoProcessHandler(104);
    }

    public void setFilter(Bitmap leftBitmap, float leftIntensity, Bitmap rightBitmap, float rightIntensity, float leftRatio) {
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gy.a(uGCVideoProcessor, leftBitmap, leftIntensity, rightBitmap, rightIntensity, leftRatio));
        this.sendMsgToVideoProcessHandler(104);
    }

    public void setCustomVideoProcessListener(TXVideoEditer.TXVideoCustomProcessListener listener) {
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(gz.a(uGCVideoProcessor, listener));
    }

    public void setProgressListener(VideoProcessListener listener) {
        UGCVideoProcessor uGCVideoProcessor = this;
        uGCVideoProcessor.runOnVideoProcessHandler(ha.a(uGCVideoProcessor, listener));
    }

    private void initProcessChain(int width, int height) {
        LiteavLog.i(this.mTag, "init process chain:  width:" + width + " height:" + height);
        if (this.mEGLCore == null) {
            return;
        }
        this.mVideoProcessManager.initFilter(this.mGLTexturePool, width, height);
        this.mUGCTransitionProcessor = new UGCTransitionProcessor(width, height, this.mGLTexturePool);
        this.mUGCCombineProcessor = new UGCCombineProcessor(width, height, this.mGLTexturePool);
    }

    private void unInitVideoProcessor() {
        LiteavLog.i(this.mTag, "uninitVideoProcessor: ");
        this.mVideoProcessManager.unInitFilter();
        if (this.mUGCTransitionProcessor != null) {
            this.mUGCTransitionProcessor.release();
            this.mUGCTransitionProcessor = null;
        }
        if (this.mUGCCombineProcessor != null) {
            this.mUGCCombineProcessor.release();
            this.mUGCCombineProcessor = null;
        }
        if (this.mPreScaleRenderer != null) {
            this.mPreScaleRenderer.uninitialize();
            this.mPreScaleRenderer = null;
        }
    }

    private void processFrame() {
        if (!this.mIsInit) {
            return;
        }
        List<PixelFrame> list = this.mUGCMediaListSource.readNextVideoFrame();
        if (list == null || list.isEmpty()) {
            this.processEndOfFrameRead();
            return;
        }
        if (!this.createProcessChainIfNeed(list)) {
            PixelFrame.releasePixelFrames(list);
            return;
        }
        if (this.isFilterFrameDueToSync(list) || this.isFilterFrameDueToChangeFrameRate(list)) {
            PixelFrame.releasePixelFrames(list);
            if (this.mStatus == a.b) {
                this.sendMsgToVideoProcessHandler(101);
            }
            return;
        }
        PixelFrame pixelFrame = this.mergeFramesIfNeeded(list);
        if (pixelFrame == null) {
            PixelFrame.releasePixelFrames(list);
            return;
        }
        if (this.mLastFrameOfReadFromSource != null) {
            this.mLastFrameOfReadFromSource.release();
        }
        this.mLastFrameOfReadFromSource = this.preScale(pixelFrame);
        this.mVideoProcessManager.processFrame(this.mLastFrameOfReadFromSource);
        pixelFrame.release();
        PixelFrame.releasePixelFrames(list);
    }

    private void processEndOfFrameRead() {
        if (this.mLastFrameOfReadFromSource != null) {
            this.mFinalPts = this.mLastFrameOfReadFromSource.getTimestamp();
        }
        LiteavLog.i(this.mTag, "final frame pts is " + this.mFinalPts + "  last progressed frame pts is " + this.mLastProcessFramePts);
        if (this.mLastProcessFramePts < this.mFinalPts) {
            return;
        }
        if (this.mIsRecord && this.mVideoEncodeController != null) {
            this.mVideoEncodeController.signalEndOfStream();
        }
        if (!this.mIsRecord) {
            this.notifyPreviewComplete();
        }
    }

    private boolean createProcessChainIfNeed(List<PixelFrame> pixelFrames) {
        PixelFrame pixelFrame = pixelFrames.get(0);
        int n2 = pixelFrame.getWidth();
        int n3 = pixelFrame.getHeight();
        if (this.mOutputWidth > 0 && this.mOutputHeight > 0) {
            n2 = this.mOutputWidth;
            n3 = this.mOutputHeight;
        }
        if (this.isNeedReCreateEGL(pixelFrame.getGLContext(), n2, n3)) {
            this.unInitVideoProcessor();
            this.uninitializedEGL();
        }
        if (this.mEGLCore == null) {
            this.initializeEGL(pixelFrame.getGLContext(), n2, n3);
            this.initProcessChain(n2, n3);
        }
        return this.mEGLCore != null;
    }

    private boolean isFilterFrameDueToSync(List<PixelFrame> pixelFrames) {
        UGCAVSyncer.SkipMode skipMode = UGCAVSyncer.SkipMode.NOOP;
        if (this.mHasFirstFrameProcessed || this.mIsRecord) {
            skipMode = this.mUGCAVSyncer.syncVideo(pixelFrames.get(0).getTimestamp());
        }
        this.mHasFirstFrameProcessed = true;
        if (skipMode == UGCAVSyncer.SkipMode.SKIP_CURRENT_FRAME) {
            ++this.mSkipFrameCount;
            return this.mSkipFrameCount < 3;
        }
        this.mSkipFrameCount = 0;
        return false;
    }

    private PixelFrame mergeFramesIfNeeded(List<PixelFrame> pixelFrames) {
        if (pixelFrames.size() > 1) {
            if (this.mRectList != null) {
                if (this.mUGCCombineProcessor != null) {
                    return this.mUGCCombineProcessor.processFrame(pixelFrames, this.mRectList);
                }
                return null;
            }
            if (this.mUGCTransitionProcessor != null) {
                return this.mUGCTransitionProcessor.processFrame(pixelFrames, this.mTransitionType);
            }
            return null;
        }
        pixelFrames.get(0).retain();
        return pixelFrames.get(0);
    }

    public void setReverse(boolean reverse) {
        this.mReverse = reverse;
    }

    private boolean filterInvalidatedFrame(long framePts) {
        if (this.mReverse) {
            framePts = Math.abs(this.mUGCMediaListSource.getDuration() - framePts);
        }
        framePts = Math.min(this.mUGCMediaListSource.getDuration(), framePts);
        if (this.mTargetSeekPts.get() != null && Math.abs(framePts - this.mTargetSeekPts.get()) > 100L) {
            LiteavLog.i(this.mTag, "filtInvalidatedFrame: framePts:" + framePts + "  mTargetSeekPts:" + this.mTargetSeekPts + "  d :" + Math.abs(framePts - this.mTargetSeekPts.get()));
            return true;
        }
        return false;
    }

    private boolean isFilterFrameDueToChangeFrameRate(List<PixelFrame> pixelFrames) {
        if (this.mFrameRateFilter == null || !this.mIsRecord || pixelFrames.size() > 1) {
            return false;
        }
        return this.mFrameRateFilter.isFilterOutFrame(pixelFrames.get(0));
    }

    private void handleProcessFrame(PixelFrame frame) {
        if (this.filterInvalidatedFrame(frame.getTimestamp())) {
            return;
        }
        this.mTargetSeekPts.set(null);
        if (this.mVideoProcessListener != null) {
            this.mVideoProcessListener.onProgress(frame.getTimestamp());
        }
        this.mLastProcessFramePts = frame.getTimestamp();
        FrameMetaData frameMetaData = new FrameMetaData();
        frameMetaData.setEncodeRotation(this.mRotation);
        frameMetaData.setRenderRotation(this.mRotation);
        frame.setMetaData(frameMetaData);
        if (!this.mIsRecord && this.mRenderer != null) {
            this.mRenderer.renderFrame(frame);
        }
        if (this.mIsRecord && this.mVideoEncodeController != null) {
            this.mVideoEncodeController.encodeFrame(frame);
            if (this.mFinalPts > 0L && this.mLastProcessFramePts >= this.mFinalPts) {
                LiteavLog.i(this.mTag, "processFrameFromSource: signalEndOfStream");
                this.mVideoEncodeController.signalEndOfStream();
                return;
            }
        } else if (this.mFinalPts > 0L && this.mLastProcessFramePts >= this.mFinalPts) {
            this.notifyPreviewComplete();
        }
        if (this.mStatus == a.b) {
            this.sendMsgToVideoProcessHandler(101);
        }
    }

    private void notifyPreviewComplete() {
        CustomHandler customHandler = this.mVideoProcessHandler;
        if (customHandler != null) {
            customHandler.removeCallbacks(this.onCompleteBroadcastRunnable);
            customHandler.post(this.onCompleteBroadcastRunnable);
        }
    }

    private boolean isNeedReCreateEGL(Object sharedContext, int width, int height) {
        if (this.mCurEGLContext == null || width < 0 || height < 0) {
            return false;
        }
        if (!sharedContext.equals(this.mCurEGLContext) || this.mCurEGLWidth != width || this.mCurEGLHeight != height) {
            LiteavLog.i(this.mThrottlers.a("recreateGL"), this.mTag, "isNeedReCreateEGL: true", new Object[0]);
            return true;
        }
        return false;
    }

    private void initializeEGL(Object sharedContext, int width, int height) {
        try {
            this.mEGLCore = new EGLCore();
            this.mEGLCore.initialize(sharedContext, null, width, height);
            this.mEGLCore.makeCurrent();
            this.mCurEGLContext = sharedContext;
            this.mCurEGLWidth = width;
            this.mCurEGLHeight = height;
            this.mGLTexturePool = new GLTexturePool();
            return;
        }
        catch (EGLException eGLException) {
            this.mEGLCore = null;
            LiteavLog.e(this.mThrottlers.a("initGL"), this.mTag, eGLException.getMessage(), new Object[0]);
            return;
        }
    }

    private void uninitializedEGL() {
        LiteavLog.i(this.mThrottlers.a("uninitGL"), this.mTag, "uninitializedEGL", new Object[0]);
        if (EGLCore.makeCurrent(this.mEGLCore) && this.mGLTexturePool != null) {
            this.mGLTexturePool.destroy();
        }
        if (this.mTXVideoCustomProcessListener != null) {
            this.mTXVideoCustomProcessListener.onTextureDestroyed();
        }
        EGLCore.destroy(this.mEGLCore);
        this.mEGLCore = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runOnVideoProcessHandler(Runnable runnable) {
        CustomHandler customHandler;
        UGCVideoProcessor uGCVideoProcessor = this;
        synchronized (uGCVideoProcessor) {
            if (this.mVideoProcessHandler == null || this.mVideoProcessHandler.getLooper() == null || this.mVideoProcessHandler.getLooper().getThread() == null || !this.mVideoProcessHandler.getLooper().getThread().isAlive()) {
                LiteavLog.e(this.mTag, "handler post fail thread is not alive ");
                return false;
            }
            customHandler = this.mVideoProcessHandler;
        }
        if (customHandler != null) {
            if (Looper.myLooper() == customHandler.getLooper()) {
                runnable.run();
                return true;
            }
            boolean bl2 = customHandler.post(runnable);
            if (!bl2) {
                LiteavLog.e(this.mTag, "handler post fail ret = ".concat(String.valueOf(bl2)));
            }
            return bl2;
        }
        return false;
    }

    public void refreshOneFrame() {
        this.sendMsgToVideoProcessHandler(104);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMsgToVideoProcessHandler(int msg) {
        UGCVideoProcessor uGCVideoProcessor = this;
        synchronized (uGCVideoProcessor) {
            if (this.mVideoProcessHandler != null) {
                this.mVideoProcessHandler.sendEmptyMessage(msg);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMsgFromVideoProcessHandler(int msg) {
        UGCVideoProcessor uGCVideoProcessor = this;
        synchronized (uGCVideoProcessor) {
            if (this.mVideoProcessHandler != null) {
                this.mVideoProcessHandler.removeMessages(msg);
            }
            return;
        }
    }

    static /* synthetic */ void lambda$new$16(UGCVideoProcessor this_) {
        this_.onCompleteBroadcast();
    }

    static /* synthetic */ void lambda$setProgressListener$15(UGCVideoProcessor this_, VideoProcessListener listener) {
        this_.mVideoProcessListener = listener;
    }

    static /* synthetic */ void lambda$setCustomVideoProcessListener$14(UGCVideoProcessor this_, TXVideoEditer.TXVideoCustomProcessListener listener) {
        this_.mTXVideoCustomProcessListener = listener;
    }

    static /* synthetic */ void lambda$setFilter$13(UGCVideoProcessor this_, Bitmap leftBitmap, float leftIntensity, Bitmap rightBitmap, float rightIntensity, float leftRatio) {
        this_.mVideoProcessManager.setFilter(leftBitmap, leftIntensity, rightBitmap, rightIntensity, leftRatio);
    }

    static /* synthetic */ void lambda$setSpecialRatio$12(UGCVideoProcessor this_, float specialRatio) {
        this_.mVideoProcessManager.setSpecialRatio(specialRatio);
    }

    static /* synthetic */ void lambda$setBeautyFilter$11(UGCVideoProcessor this_, int beautyLevel, int whiteningLevel) {
        this_.mVideoProcessManager.setBeautyFilter(beautyLevel, whiteningLevel);
    }

    static /* synthetic */ void lambda$setSpeedList$10(UGCVideoProcessor this_, List speedList) {
        if (this_.mSpeedProcessor == null) {
            this_.mSpeedProcessor = new SpeedProcessor();
        }
        LiteavLog.i(this_.mTag, "==== setSpeedList ==== ");
        if (speedList != null) {
            UGCDataReport.reportDAU(1019);
            ArrayList<TXVideoEditConstants.TXSpeed> arrayList = new ArrayList<TXVideoEditConstants.TXSpeed>();
            for (int i2 = 0; i2 < speedList.size(); ++i2) {
                TXVideoEditConstants.TXSpeed tXSpeed = (TXVideoEditConstants.TXSpeed)speedList.get(i2);
                TXVideoEditConstants.TXSpeed tXSpeed2 = new TXVideoEditConstants.TXSpeed();
                new TXVideoEditConstants.TXSpeed().speedLevel = tXSpeed.speedLevel;
                tXSpeed2.startTime = tXSpeed.startTime;
                tXSpeed2.endTime = tXSpeed.endTime;
                arrayList.add(tXSpeed2);
            }
            this_.mSpeedProcessor.setSpeedList(arrayList);
            return;
        }
        this_.mSpeedProcessor.setSpeedList(null);
    }

    static /* synthetic */ void lambda$setPictureTransition$9(UGCVideoProcessor this_, int type) {
        this_.mTransitionType = type;
    }

    static /* synthetic */ void lambda$setVideoEncodedFrameListener$8(UGCVideoProcessor this_, VideoEncodedFrameListener listener) {
        this_.mVideoEncodedFrameListener = listener;
    }

    static /* synthetic */ void lambda$setEncodeParams$7(UGCVideoProcessor this_, VideoEncodeParams encodeParams) {
        this_.mVideoEncodeParams = encodeParams;
    }

    static /* synthetic */ void lambda$setRenderRotation$6(UGCVideoProcessor this_, l rotation) {
        this_.mRotation = rotation;
    }

    static /* synthetic */ void lambda$setDisplayView$5(UGCVideoProcessor this_, DisplayTarget displayTarget, GLConstants.GLScaleType scaleType) {
        this_.mDisplayTarget = displayTarget;
        if (scaleType != null) {
            this_.mScaleType = scaleType;
        }
        if (this_.mRenderer != null) {
            this_.mRenderer.setDisplayView(this_.mDisplayTarget, true);
            this_.mRenderer.setScaleType(this_.mScaleType);
        }
        this_.mVideoProcessManager.setScaleType(this_.mScaleType);
    }

    static /* synthetic */ void lambda$setOutputSize$4(UGCVideoProcessor this_, int width, int height, GLConstants.GLScaleType scaleType) {
        this_.mOutputWidth = width;
        this_.mOutputHeight = height;
        if (width > 0) {
            this_.mScaleType = scaleType;
        }
    }

    static /* synthetic */ void lambda$setSplitScreenList$3(UGCVideoProcessor this_, List rectList, int canvasWidth, int canvasHeight) {
        this_.mRectList = rectList;
        this_.setOutputSize(canvasWidth, canvasHeight, GLConstants.GLScaleType.b);
    }

    static /* synthetic */ void lambda$setFilteredFrameRate$2(UGCVideoProcessor this_, int frameRate) {
        this_.mFrameRateFilter = new UGCFrameRateFilter(frameRate);
    }

    static /* synthetic */ void lambda$start$1(UGCVideoProcessor this_, boolean isRecord, UGCVideoEncoderJNI.EncoderType encoderType) {
        this_.mIsRecord = isRecord;
        this_.mUsingEncoderType = encoderType;
        this_.mTargetSeekPts.set(null);
        this_.mFinalPts = -1L;
        this_.mSkipFrameCount = 0;
        this_.mHasFirstFrameProcessed = false;
        this_.mVideoProcessManager.setListener(this_.new c(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void lambda$unInitialize$0(UGCVideoProcessor this_) {
        this_.mFinalPts = -1L;
        if (this_.mLastFrameOfReadFromSource != null) {
            this_.mLastFrameOfReadFromSource.release();
            this_.mLastFrameOfReadFromSource = null;
        }
        if (this_.mRenderer != null) {
            this_.mRenderer.stop(false);
            this_.mRenderer = null;
        }
        this_.stopEncoder();
        if (this_.mPreScaleRenderer != null) {
            this_.mPreScaleRenderer.uninitialize();
            this_.mPreScaleRenderer = null;
        }
        this_.unInitVideoProcessor();
        this_.mVideoProcessManager.unInitialize();
        if (this_.mRenderThread != null) {
            if (LiteavSystemInfo.getSystemOSVersionInt() >= 18) {
                this_.mRenderThread.quitSafely();
            } else {
                this_.mRenderThread.quit();
            }
            this_.mRenderThread = null;
        }
        this_.uninitializedEGL();
        UGCVideoProcessor uGCVideoProcessor = this_;
        synchronized (uGCVideoProcessor) {
            if (this_.mVideoProcessHandler != null) {
                this_.mVideoProcessHandler.quitLooper();
                this_.mVideoProcessHandler = null;
            }
            return;
        }
    }

    static /* synthetic */ boolean access$lambda$0(UGCVideoProcessor uGCVideoProcessor, Message message) {
        return uGCVideoProcessor.handleMessage(message);
    }

    static /* synthetic */ void access$lambda$1(UGCVideoProcessor uGCVideoProcessor) {
        uGCVideoProcessor.stopEncoder();
    }

    public static interface VideoProcessListener {
        public void onProgress(long var1);

        public void onComplete(TXVideoEditConstants.TXGenerateResult var1);
    }

    public static interface VideoEncodedFrameListener {
        public void onVideoEncodeStarted();

        public void onEncodedFail(UGCVideoEncoderJNI.EncoderType var1);

        public void onVideoFrameEncoded(EncodedVideoFrame var1);

        public void onVideoEncodingCompleted();
    }

    final class c
    implements VideoProcessManager.IVideoProcessManagerListener {
        private c() {
        }

        @Override
        public final void didProcessFrame(PixelFrame frame) {
            if (UGCVideoProcessor.this.filterInvalidatedFrame(frame.getTimestamp())) {
                return;
            }
            UGCVideoProcessor.this.handleProcessFrame(frame);
        }

        @Override
        public final int customProcessFrame(PixelFrame frame) {
            if (UGCVideoProcessor.this.mTXVideoCustomProcessListener == null || frame == null) {
                return -1;
            }
            if (frame.getPixelBufferType() == GLConstants.a.b || frame.getPixelBufferType() == GLConstants.a.c) {
                GLES20.glFinish();
            }
            return UGCVideoProcessor.this.mTXVideoCustomProcessListener.onTextureCustomProcess(frame.getTextureId(), frame.getWidth(), frame.getHeight(), frame.getTimestamp());
        }

        /* synthetic */ c(byte by2) {
            this();
        }
    }

    final class b
    implements UGCVideoEncoderJNI.UGCVideoEncoderListener {
        private b() {
        }

        @Override
        public final void onEncodedNAL(EncodedVideoFrame nal) {
            UGCVideoProcessor.this.runOnVideoProcessHandler(hk.a(this, nal));
        }

        @Override
        public final void onEncodedFail() {
            LiteavLog.e(UGCVideoProcessor.this.mTag, "encoded fail.");
            UGCVideoProcessor.this.runOnVideoProcessHandler(hl.a(this));
        }

        static /* synthetic */ void a(b b2) {
            b b3 = b2;
            if (b3 == b3.UGCVideoProcessor.this.mUGCVideoEncoderListener && b2.UGCVideoProcessor.this.mVideoEncodedFrameListener != null) {
                b2.UGCVideoProcessor.this.mVideoEncodedFrameListener.onEncodedFail(b2.UGCVideoProcessor.this.mUsingEncoderType);
            }
        }

        static /* synthetic */ void a(b b2, EncodedVideoFrame encodedVideoFrame) {
            b b3 = b2;
            if (b3 != b3.UGCVideoProcessor.this.mUGCVideoEncoderListener || b2.UGCVideoProcessor.this.mVideoEncodedFrameListener == null) {
                return;
            }
            if (encodedVideoFrame != null) {
                if (!encodedVideoFrame.isEosFrame) {
                    b2.UGCVideoProcessor.this.mVideoEncodedFrameListener.onVideoFrameEncoded(encodedVideoFrame);
                }
                if (encodedVideoFrame.pts >= b2.UGCVideoProcessor.this.mFinalPts && b2.UGCVideoProcessor.this.mFinalPts != -1L || encodedVideoFrame.isEosFrame) {
                    b2.UGCVideoProcessor.this.mVideoEncodedFrameListener.onVideoEncodingCompleted();
                    b2.UGCVideoProcessor.this.stopEncoder();
                    return;
                }
            } else {
                b2.UGCVideoProcessor.this.mVideoEncodedFrameListener.onVideoEncodingCompleted();
                b2.UGCVideoProcessor.this.stopEncoder();
            }
        }

        /* synthetic */ b(byte by2) {
            this();
        }
    }

    static enum a {
        a,
        b,
        c;

    }
}

