/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.TXPictureEditer;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.UGCLicenseChecker;
import java.util.List;

@JNINamespace(value="liteav::ugc")
public class UGCPictureEditerJni
extends TXPictureEditer {
    private static final String TAG = "UGCPictureEditerJni";
    private long mNativeHandler;

    public UGCPictureEditerJni(Context context) {
        ContextUtils.initApplicationContext(context.getApplicationContext());
        ContextUtils.setDataDirectorySuffix("liteav");
        this.mNativeHandler = UGCPictureEditerJni.nativeCreatePictureEditer(this);
    }

    public void finalize() throws Throwable {
        if (this.mNativeHandler != 0L) {
            UGCPictureEditerJni.nativeDestroy(this.mNativeHandler);
        }
    }

    @Override
    public void setPicture(Bitmap bitmap) {
        if (bitmap == null) {
            LiteavLog.e(TAG, "set picture bitmap is null");
            return;
        }
        if (this.mNativeHandler != 0L) {
            UGCPictureEditerJni.nativeSetSourcePicture(this.mNativeHandler, bitmap);
        }
    }

    @Override
    public void setPasterList(List<TXVideoEditConstants.TXPaster> pasterList) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        if (pasterList == null || pasterList.isEmpty()) {
            LiteavLog.i(TAG, "set paster list. list is null");
            UGCPictureEditerJni.nativeSetPasterList(this.mNativeHandler, null, null, null, null);
            return;
        }
        int n2 = pasterList.size();
        Object[] objectArray = new Bitmap[n2];
        float[] fArray = new float[n2];
        float[] fArray2 = new float[n2];
        float[] fArray3 = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            TXVideoEditConstants.TXPaster tXPaster = pasterList.get(i2);
            objectArray[i2] = tXPaster.pasterImage;
            fArray[i2] = tXPaster.frame.x;
            fArray2[i2] = tXPaster.frame.y;
            fArray3[i2] = tXPaster.frame.width;
        }
        UGCPictureEditerJni.nativeSetPasterList(this.mNativeHandler, objectArray, fArray, fArray2, fArray3);
    }

    @Override
    public void setCropRect(Rect rect) {
        if (this.mNativeHandler != 0L) {
            UGCPictureEditerJni.nativeSetCropRect(this.mNativeHandler, rect.left, rect.top, rect.width(), rect.height());
        }
    }

    @Override
    public void setOutputRotation(int rotation) {
        if (this.mNativeHandler != 0L) {
            UGCPictureEditerJni.nativeSetOutputRotation(this.mNativeHandler, rotation);
        }
    }

    @Override
    public void setOutputFillMode(int fillMode) {
        if (this.mNativeHandler != 0L) {
            GLConstants.GLScaleType gLScaleType = GLConstants.GLScaleType.a;
            if (fillMode == 2) {
                gLScaleType = GLConstants.GLScaleType.b;
            }
            UGCPictureEditerJni.nativeSetOutputFillMode(this.mNativeHandler, gLScaleType.mValue);
        }
    }

    @Override
    public void setOutputSize(int width, int height) {
        if (this.mNativeHandler != 0L) {
            UGCPictureEditerJni.nativeSetOutputSize(this.mNativeHandler, width, height);
        }
    }

    @Override
    public void processPicture(TXPictureEditer.PictureProcessListener processPictureListener) {
        if (!UGCLicenseChecker.isStandardFunctionSupport() && !UGCLicenseChecker.isIMPluginFunctionSupport()) {
            LiteavLog.e(TAG, "processPicture is not supported in your license");
            return;
        }
        if (this.mNativeHandler != 0L) {
            UGCPictureEditerJni.nativeProcessPicture(this.mNativeHandler, processPictureListener);
        }
    }

    public void destroy() {
        if (this.mNativeHandler != 0L) {
            UGCPictureEditerJni.nativeDestroy(this.mNativeHandler);
        }
        this.mNativeHandler = 0L;
    }

    private void onProcessPicture(Object listener, Object image) {
        if (listener instanceof TXPictureEditer.PictureProcessListener) {
            LiteavLog.i(TAG, "process picture callback.");
            ((TXPictureEditer.PictureProcessListener)listener).onPictureProcessed((Bitmap)image);
        }
    }

    private static native long nativeCreatePictureEditer(UGCPictureEditerJni var0);

    private static native void nativeDestroy(long var0);

    private static native void nativeSetSourcePicture(long var0, Object var2);

    private static native void nativeSetPasterList(long var0, Object[] var2, float[] var3, float[] var4, float[] var5);

    private static native void nativeSetCropRect(long var0, int var2, int var3, int var4, int var5);

    private static native void nativeSetOutputRotation(long var0, int var2);

    private static native void nativeSetOutputFillMode(long var0, int var2);

    private static native void nativeSetOutputSize(long var0, int var2, int var3);

    private static native void nativeProcessPicture(long var0, Object var2);
}

