/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.os.Looper;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.AudioFrame;
import com.tencent.ugc.Clip;
import com.tencent.ugc.TXVideoJoiner;
import com.tencent.ugc.UGCAudioFrameProvider;
import com.tencent.ugc.UGCFrameQueue;
import com.tencent.ugc.UGCSingleFileAudioFrameProvider;
import com.tencent.ugc.ev;
import com.tencent.ugc.ew;
import com.tencent.ugc.ex;
import com.tencent.ugc.ey;
import java.util.LinkedList;
import java.util.List;

public class UGCMultiFileAudioFrameProvider
implements UGCAudioFrameProvider,
UGCFrameQueue.UGCFrameQueueListener {
    private static final String TAG = "UGCMultiFileAudioFrameProvider";
    private final UGCFrameQueue<List<AudioFrame>> mAudioFrameListQueue = new UGCFrameQueue();
    private final UGCAudioFrameProvider[] mProviderList;
    private final List<Clip> mClipList;
    private final CustomHandler mSingleFileProviderHandler;
    private final CustomHandler mWorkHandler;
    private final TXVideoJoiner.DurationControlMode mDurationControlMode;

    public UGCMultiFileAudioFrameProvider(List<Clip> clipList, TXVideoJoiner.DurationControlMode durationControlMode, CustomHandler handler) {
        this.mProviderList = new UGCAudioFrameProvider[clipList.size()];
        this.mClipList = clipList;
        this.mDurationControlMode = durationControlMode;
        this.mSingleFileProviderHandler = handler;
        this.mWorkHandler = new CustomHandler(Looper.myLooper());
        this.mAudioFrameListQueue.setUGCFrameQueueListener(this);
    }

    @Override
    public void initialize() {
        LiteavLog.i(TAG, "initialize");
    }

    @Override
    public void uninitialize() {
        this.stop();
    }

    @Override
    public void start() {
        this.mWorkHandler.runOrPost(ev.a(this));
    }

    @Override
    public void stop() {
        this.mWorkHandler.runOrPost(ew.a(this));
    }

    @Override
    public void seekTo(long timeline) {
        this.mWorkHandler.runOrPost(ex.a(this, timeline));
    }

    @Override
    public void setPlayEndPts(long playEndPts) {
    }

    @Override
    public UGCFrameQueue<List<AudioFrame>> getFrameQueue() {
        return this.mAudioFrameListQueue;
    }

    public void readFrameToQueue() {
        LinkedList<AudioFrame> linkedList = new LinkedList<AudioFrame>();
        for (int i2 = 0; i2 < this.mProviderList.length; ++i2) {
            UGCAudioFrameProvider uGCAudioFrameProvider = this.mProviderList[i2];
            if (uGCAudioFrameProvider == null) {
                linkedList.add(new AudioFrame());
                continue;
            }
            List<AudioFrame> list = uGCAudioFrameProvider.getFrameQueue().dequeue();
            if (list == UGCAudioFrameProvider.END_OF_STREAM) {
                uGCAudioFrameProvider.stop();
                uGCAudioFrameProvider.uninitialize();
                this.mProviderList[i2] = null;
                linkedList.add(new AudioFrame());
                continue;
            }
            linkedList.add(list.get(0));
        }
        if (this.isEndStream()) {
            this.mAudioFrameListQueue.queue(UGCAudioFrameProvider.END_OF_STREAM);
            return;
        }
        this.mAudioFrameListQueue.queue(linkedList);
    }

    private boolean isEndStream() {
        if (this.mDurationControlMode == TXVideoJoiner.DurationControlMode.ALIGNS_TO_LONGEST) {
            return this.isAllProviderEndOfStream();
        }
        return this.hasOneProviderMeetsEndOfStream();
    }

    private boolean isAllProviderEndOfStream() {
        UGCAudioFrameProvider[] uGCAudioFrameProviderArray = this.mProviderList;
        int n2 = this.mProviderList.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (uGCAudioFrameProviderArray[i2] == null) continue;
            return false;
        }
        return true;
    }

    private boolean hasOneProviderMeetsEndOfStream() {
        UGCAudioFrameProvider[] uGCAudioFrameProviderArray = this.mProviderList;
        int n2 = this.mProviderList.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (uGCAudioFrameProviderArray[i2] != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onFrameDequeued() {
        this.mWorkHandler.runOrPost(ey.a(this));
    }

    static /* synthetic */ void lambda$seekTo$2(UGCMultiFileAudioFrameProvider this_, long timeline) {
        UGCAudioFrameProvider[] uGCAudioFrameProviderArray = this_.mProviderList;
        int n2 = this_.mProviderList.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            UGCAudioFrameProvider uGCAudioFrameProvider = uGCAudioFrameProviderArray[i2];
            if (uGCAudioFrameProvider == null) continue;
            uGCAudioFrameProvider.seekTo(timeline);
        }
        this_.mAudioFrameListQueue.clear();
    }

    static /* synthetic */ void lambda$stop$1(UGCMultiFileAudioFrameProvider this_) {
        for (int i2 = 0; i2 < this_.mProviderList.length; ++i2) {
            if (this_.mProviderList[i2] != null) {
                this_.mProviderList[i2].stop();
                this_.mProviderList[i2].uninitialize();
            }
            this_.mProviderList[i2] = null;
        }
        this_.mAudioFrameListQueue.clear();
    }

    static /* synthetic */ void lambda$start$0(UGCMultiFileAudioFrameProvider this_) {
        for (int i2 = 0; i2 < this_.mClipList.size(); ++i2) {
            UGCSingleFileAudioFrameProvider uGCSingleFileAudioFrameProvider = new UGCSingleFileAudioFrameProvider(this_.mClipList.get(i2), this_.mSingleFileProviderHandler);
            uGCSingleFileAudioFrameProvider.initialize();
            uGCSingleFileAudioFrameProvider.start();
            this_.mProviderList[i2] = uGCSingleFileAudioFrameProvider;
        }
        this_.readFrameToQueue();
    }
}

