/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.content.Context;
import android.graphics.Bitmap;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.beauty.TXBeautyManager;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.ugc.TXRecordCommon;
import com.tencent.ugc.TXUGCPartsManager;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.UGCLicenseChecker;
import com.tencent.ugc.UGCRecorderJni;
import com.tencent.ugc.datereport.UGCDataReport;

public class TXUGCRecord {
    private static final String TAG = "TXUGCRecord";
    private static TXUGCRecord instance;
    private final UGCRecorderJni mUGCRecorder;

    public static synchronized TXUGCRecord getInstance(Context context) {
        if (instance == null) {
            instance = new TXUGCRecord(context);
        }
        return instance;
    }

    protected TXUGCRecord(Context context) {
        ContextUtils.initApplicationContext(context.getApplicationContext());
        ContextUtils.setDataDirectorySuffix("liteav");
        this.mUGCRecorder = new UGCRecorderJni(context);
        this.mUGCRecorder.setBGMLoop(true);
        UGCDataReport.reportLicenseIsValid();
    }

    public void setVideoRecordListener(TXRecordCommon.ITXVideoRecordListener listener) {
        this.mUGCRecorder.setVideoRecordListener(listener);
    }

    public int startCameraSimplePreview(TXRecordCommon.TXUGCSimpleConfig config, TXCloudVideoView previewView) {
        return this.mUGCRecorder.startCameraSimplePreview(config, previewView);
    }

    public int startCameraCustomPreview(TXRecordCommon.TXUGCCustomConfig config, TXCloudVideoView previewView) {
        return this.mUGCRecorder.startCameraCustomPreview(config, previewView);
    }

    public void setVideoResolution(int resolution) {
        this.mUGCRecorder.setVideoResolution(resolution);
    }

    public void setVideoBitrate(int bitrate) {
        this.mUGCRecorder.setVideoBitrate(bitrate);
    }

    public void stopCameraPreview() {
        this.mUGCRecorder.stopCameraPreview();
    }

    public TXUGCPartsManager getPartsManager() {
        return this.mUGCRecorder.getPartsManager();
    }

    public void setMute(boolean isMute) {
        this.mUGCRecorder.setMute(isMute);
    }

    public int startRecord() {
        if (!UGCLicenseChecker.isSimpleFunctionSupport() && !UGCLicenseChecker.isIMPluginFunctionSupport()) {
            return -5;
        }
        return this.mUGCRecorder.startRecord();
    }

    public int startRecord(String videoFilePath, String coverPath) {
        if (!UGCLicenseChecker.isSimpleFunctionSupport() && !UGCLicenseChecker.isIMPluginFunctionSupport()) {
            return -5;
        }
        return this.mUGCRecorder.startRecord(videoFilePath, coverPath);
    }

    public int startRecord(String videoFilePath, String videoPartFolder, String coverPath) {
        if (!UGCLicenseChecker.isSimpleFunctionSupport() && !UGCLicenseChecker.isIMPluginFunctionSupport()) {
            return -5;
        }
        return this.mUGCRecorder.startRecord(videoFilePath, videoPartFolder, coverPath);
    }

    public int stopRecord() {
        return this.mUGCRecorder.stopRecord();
    }

    public void release() {
        this.mUGCRecorder.release();
    }

    public int pauseRecord() {
        return this.mUGCRecorder.pauseRecord();
    }

    public int resumeRecord() {
        return this.mUGCRecorder.resumeRecord();
    }

    public boolean setMicVolume(float x2) {
        return this.mUGCRecorder.setMicVolume(x2);
    }

    public boolean switchCamera(boolean isFront) {
        return this.mUGCRecorder.switchCamera(isFront);
    }

    public void setAspectRatio(int displayType) {
        this.mUGCRecorder.setAspectRatio(displayType);
    }

    public void snapshot(TXRecordCommon.ITXSnapshotListener listener) {
        if (!UGCLicenseChecker.isStandardFunctionSupport() && !UGCLicenseChecker.isIMPluginFunctionSupport()) {
            return;
        }
        this.mUGCRecorder.snapshot(listener);
    }

    public void setRecordSpeed(int recordSpeed) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setRecordSpeed is not supported in UGSV_Lite license");
            return;
        }
        this.mUGCRecorder.setRecordSpeed(recordSpeed);
    }

    public void setVideoProcessListener(VideoCustomProcessListener listener) {
        this.mUGCRecorder.setVideoProcessListener(listener);
    }

    public void setReverb(int reverbType) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setReverb is not supported in UGSV_Lite license");
            return;
        }
        this.mUGCRecorder.setReverb(reverbType);
    }

    public void setVoiceChangerType(int voiceChangerType) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setVoiceChangerType is not supported in UGSV_Lite license");
            return;
        }
        this.mUGCRecorder.setVoiceChangerType(voiceChangerType);
    }

    public int setBGM(String path) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setBGM is not supported in UGSV_Lite license");
            return -1;
        }
        return this.mUGCRecorder.setBGM(path);
    }

    public void setBGMLoop(boolean isLoop) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setBGMLoop is not supported in UGSV_Lite license");
            return;
        }
        this.mUGCRecorder.setBGMLoop(isLoop);
    }

    public void setBGMNofify(TXRecordCommon.ITXBGMNotify notify) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setBGMNofify is not supported in UGSV_Lite license");
            return;
        }
        this.mUGCRecorder.setBGMNotify(notify);
    }

    public boolean playBGMFromTime(int startTime, int endTime) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "playBGMFromTime is not supported in UGSV_Lite license");
            return false;
        }
        return this.mUGCRecorder.playBGMFromTime(startTime, endTime);
    }

    public boolean stopBGM() {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "stopBGM is not supported in UGSV_Lite license");
            return false;
        }
        return this.mUGCRecorder.stopBGM();
    }

    public boolean pauseBGM() {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "pauseBGM is not supported in UGSV_Lite license");
            return false;
        }
        return this.mUGCRecorder.pauseBGM();
    }

    public boolean resumeBGM() {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "resumeBGM is not supported in UGSV_Lite license");
            return false;
        }
        return this.mUGCRecorder.resumeBGM();
    }

    public boolean seekBGM(int startTime, int endTime) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "seekBGM is not supported in UGSV_Lite license");
            return false;
        }
        return this.mUGCRecorder.seekBGM(startTime, endTime);
    }

    public boolean setBGMVolume(float x2) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setBGMVolume is not supported in UGSV_Lite license");
            return false;
        }
        return this.mUGCRecorder.setBGMVolume(x2);
    }

    public int getMusicDuration(String path) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setBGMVolume is not supported in UGSV_Lite license");
            return 0;
        }
        return this.mUGCRecorder.getMusicDuration(path);
    }

    public void setWatermark(Bitmap watermarkBitmap, TXVideoEditConstants.TXRect txRect) {
        if (!UGCLicenseChecker.isStandardFunctionSupport()) {
            LiteavLog.e(TAG, "setWatermark is not supported in UGSV_Lite license");
            return;
        }
        this.mUGCRecorder.setWatermark(watermarkBitmap, txRect);
    }

    @Deprecated
    public void setMotionTmpl(String tmplPath) {
        if (!UGCLicenseChecker.isEnterpriseFunctionSupport()) {
            LiteavLog.e(TAG, "setMotionTmpl is not supported below enterprise license");
            return;
        }
        this.mUGCRecorder.setMotionTmpl(tmplPath);
    }

    @Deprecated
    public void setMotionMute(boolean motionMute) {
        if (!UGCLicenseChecker.isEnterpriseFunctionSupport()) {
            LiteavLog.e(TAG, "setMotionMute is not supported below enterprise license");
            return;
        }
        this.mUGCRecorder.setMotionMute(motionMute);
    }

    @Deprecated
    public void setGreenScreenFile(String path, boolean isLoop) {
        if (!UGCLicenseChecker.isEnterpriseProFunctionSupport()) {
            LiteavLog.e(TAG, "setGreenScreenFile is not supported below enterprise license");
            return;
        }
        this.mUGCRecorder.setGreenScreenFile(path, isLoop);
    }

    @Deprecated
    public void setFaceVLevel(int level) {
        if (!UGCLicenseChecker.isEnterpriseProFunctionSupport()) {
            LiteavLog.e(TAG, "setFaceVLevel is not supported below enterprise pro license");
            return;
        }
        this.mUGCRecorder.setFaceVLevel(level);
    }

    @Deprecated
    public void setFaceShortLevel(int level) {
        if (!UGCLicenseChecker.isEnterpriseProFunctionSupport()) {
            LiteavLog.e(TAG, "setFaceVLevel is not supported below enterprise pro license");
            return;
        }
        this.mUGCRecorder.setFaceShortLevel(level);
    }

    @Deprecated
    public void setChinLevel(int level) {
        if (!UGCLicenseChecker.isEnterpriseProFunctionSupport()) {
            LiteavLog.e(TAG, "setChinLevel is not supported below enterprise pro license");
            return;
        }
        this.mUGCRecorder.setChinLevel(level);
    }

    @Deprecated
    public void setNoseSlimLevel(int level) {
        if (!UGCLicenseChecker.isEnterpriseProFunctionSupport()) {
            LiteavLog.e(TAG, "setNoseSlimLevel is not supported below enterprise pro license");
            return;
        }
        this.mUGCRecorder.setNoseSlimLevel(level);
    }

    @Deprecated
    public void setEyeScaleLevel(float level) {
        if (!UGCLicenseChecker.isEnterpriseProFunctionSupport()) {
            LiteavLog.e(TAG, "setEyeScaleLevel is not supported below enterprise pro license");
            return;
        }
        this.mUGCRecorder.setEyeScaleLevel(level);
    }

    @Deprecated
    public void setFaceScaleLevel(float level) {
        if (!UGCLicenseChecker.isEnterpriseProFunctionSupport()) {
            LiteavLog.e(TAG, "setFaceScaleLevel is not supported below enterprise pro license");
            return;
        }
        this.mUGCRecorder.setFaceScaleLevel(level);
    }

    @Deprecated
    public void setBeautyStyle(int style) {
        this.mUGCRecorder.setBeautyStyle(style);
    }

    @Deprecated
    public void setBeautyDepth(int style, int beautyDepth, int whiteningDepth, int ruddyDepth) {
        this.mUGCRecorder.setBeautyDepth(style, beautyDepth, whiteningDepth, ruddyDepth);
    }

    @Deprecated
    public void setFilter(Bitmap filterImage) {
        this.mUGCRecorder.setFilter(filterImage);
    }

    public void setFilter(Bitmap leftBitmap, float leftIntensity, Bitmap rightBitmap, float rightIntensity, float leftRatio) {
        this.mUGCRecorder.setFilter(leftBitmap, leftIntensity, rightBitmap, rightIntensity, leftRatio);
    }

    @Deprecated
    public void setSpecialRatio(float specialRatio) {
        this.mUGCRecorder.setSpecialRatio(specialRatio);
    }

    public boolean toggleTorch(boolean enable) {
        return this.mUGCRecorder.toggleTorch(enable);
    }

    public int getMaxZoom() {
        return this.mUGCRecorder.getMaxZoom();
    }

    public boolean setZoom(int value) {
        return this.mUGCRecorder.setZoom(value);
    }

    public void setFocusPosition(float eventX, float eventY) {
        this.mUGCRecorder.setFocusPosition(eventX, eventY);
    }

    public void setVideoRenderMode(int renderMode) {
        this.mUGCRecorder.setVideoRenderMode(renderMode);
    }

    public void setVideoRenderMirrorType(int mirrorType) {
        this.mUGCRecorder.setVideoRenderMirrorType(mirrorType);
    }

    public void setVideoEncoderMirror(boolean isMirror) {
        this.mUGCRecorder.setVideoEncoderMirror(isMirror);
    }

    public void setHomeOrientation(int homeOrientation) {
        this.mUGCRecorder.setHomeOrientation(homeOrientation);
    }

    public void setRenderRotation(int renderRotation) {
        this.mUGCRecorder.setRenderRotation(renderRotation);
    }

    public TXBeautyManager getBeautyManager() {
        return this.mUGCRecorder.getBeautyManager();
    }

    public static interface VideoCustomProcessListener {
        public int onTextureCustomProcess(int var1, int var2, int var3);

        public void onDetectFacePoints(float[] var1);

        public void onTextureDestroyed();
    }
}

