/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import java.util.List;

@JNINamespace(value="liteav::ugc")
public class RemuxJoiner {
    private static final String TAG = "RemuxJoiner";
    private long mNativeHandle;
    private RemuxJoinerListener mListener;

    public void initialize() {
        LiteavLog.i(TAG, "initialize");
        if (this.mNativeHandle != 0L) {
            LiteavLog.w(TAG, "RemuxJoiner is already initialize!");
        }
        this.mNativeHandle = RemuxJoiner.nativeCreate(this);
    }

    public void uninitialize() {
        LiteavLog.i(TAG, "unInitialize");
        if (this.mNativeHandle != 0L) {
            RemuxJoiner.nativeDestroy(this.mNativeHandle);
            this.mNativeHandle = 0L;
        }
    }

    public boolean setTargetPath(String path) {
        if (this.mNativeHandle == 0L) {
            LiteavLog.w(TAG, "RemuxJoiner is not initialize");
            return false;
        }
        return RemuxJoiner.nativeSetTargetPath(this.mNativeHandle, path);
    }

    public boolean setSourcePaths(List<String> paths) {
        if (this.mNativeHandle == 0L) {
            LiteavLog.w(TAG, "RemuxJoiner is not initialize");
            return false;
        }
        return RemuxJoiner.nativeSetSourcePaths(this.mNativeHandle, paths.toArray());
    }

    public boolean start() {
        if (this.mNativeHandle == 0L) {
            LiteavLog.w(TAG, "RemuxJoiner is not initialize");
            return false;
        }
        if (!RemuxJoiner.nativeStart(this.mNativeHandle)) {
            LiteavLog.e(TAG, "native RemuxJoiner start failed.");
            return false;
        }
        return true;
    }

    public void stop() {
        if (this.mNativeHandle == 0L) {
            LiteavLog.w(TAG, "RemuxJoiner is not initialize");
            return;
        }
        RemuxJoiner.nativeStop(this.mNativeHandle);
    }

    public void setVideoJoinerListener(RemuxJoinerListener listener) {
        this.mListener = listener;
    }

    public static boolean isConcatableWithoutReencode(List<String> pathList) {
        if (pathList.size() < 2) {
            return true;
        }
        String string = pathList.get(0);
        for (int i2 = 1; i2 < pathList.size(); ++i2) {
            if (RemuxJoiner.nativeIsConcatableWithoutReencode(string, pathList.get(i2))) continue;
            return false;
        }
        return true;
    }

    private void onComplete(int code, String msg) {
        if (this.mListener != null) {
            this.mListener.onRemuxJoinerComplete(code, msg);
        }
    }

    private void onProgress(float progress) {
        if (this.mListener != null) {
            this.mListener.onRemuxJoinerProgress(progress);
        }
    }

    private static native long nativeCreate(RemuxJoiner var0);

    private static native void nativeDestroy(long var0);

    private static native boolean nativeSetTargetPath(long var0, String var2);

    private static native boolean nativeSetSourcePaths(long var0, Object[] var2);

    private static native boolean nativeStart(long var0);

    private static native void nativeStop(long var0);

    private static native boolean nativeIsConcatableWithoutReencode(String var0, String var1);

    public static interface RemuxJoinerListener {
        public void onRemuxJoinerProgress(float var1);

        public void onRemuxJoinerComplete(int var1, String var2);
    }
}

