/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trtc.hardwareearmonitor.oppo;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.JNINamespace;

@JNINamespace(value="liteav::extensions")
public class HardwareEarMonitorOppo {
    private long mNativeHardwareEarMonitorHandle = 0L;
    private AudioManager mAudioManager;
    private Context mContext;

    public static HardwareEarMonitorOppo create(long nativeHardwareEarMonitorHandle) {
        return new HardwareEarMonitorOppo(nativeHardwareEarMonitorHandle);
    }

    public boolean setAudioParams(String params) {
        try {
            this.mAudioManager.setParameters(params);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public String getParameters(String params) {
        try {
            return this.mAudioManager.getParameters(params);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public int getUidFromPackage() {
        int n2 = 0;
        try {
            if (Build.VERSION.SDK_INT >= 24) {
                n2 = this.mContext.getPackageManager().getPackageUid(this.mContext.getPackageName(), 0);
            }
        }
        catch (Throwable throwable) {
            n2 = 0;
        }
        return n2;
    }

    public boolean systemFeatureSupported(String featureName) {
        boolean bl2 = false;
        try {
            if (Build.VERSION.SDK_INT >= 24) {
                bl2 = this.mContext.getPackageManager().hasSystemFeature(featureName);
            }
        }
        catch (Throwable throwable) {
            bl2 = false;
        }
        return bl2;
    }

    public HardwareEarMonitorOppo(long nativeSystemAudioKit) {
        this.mNativeHardwareEarMonitorHandle = nativeSystemAudioKit;
        this.mAudioManager = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
        this.mContext = ContextUtils.getApplicationContext();
    }
}

