/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trtc.hardwareearmonitor.honor;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import com.tencent.trtc.hardwareearmonitor.honor.HonorAudioClient;
import com.tencent.trtc.hardwareearmonitor.honor.HonorAudioFeaturesKit;
import com.tencent.trtc.hardwareearmonitor.honor.HonorFeatureKitManager;
import com.tencent.trtc.hardwareearmonitor.honor.HonorLogUtils;
import com.tencent.trtc.hardwareearmonitor.honor.IHonorEarReturnService;

public class HonorEarReturnClient
extends HonorAudioFeaturesKit {
    private static final String TAG = "HnAudioEngine.HnEarReturnClient";
    private static final String ENGINE_CLASS_NAME = "com.hihonor.android.magicx.media.audioengine.HnEarReturnServiceImpl";
    private Context mContext;
    private HonorFeatureKitManager mFeatureKitManager = null;
    private IHonorEarReturnService mHnEarReturnService;
    private boolean mIsServiceConnected = false;
    private IBinder mService = null;
    private ServiceConnection mConnection = new ServiceConnection(){

        public final void onServiceConnected(ComponentName name, IBinder service) {
            HonorLogUtils.info(HonorEarReturnClient.TAG, "onServiceConnected");
            HonorEarReturnClient.this.mHnEarReturnService = IHonorEarReturnService.Stub.asInterface(service);
            if (HonorEarReturnClient.this.mHnEarReturnService != null) {
                HonorEarReturnClient.this.mIsServiceConnected = true;
                if (HonorEarReturnClient.this.serviceInit(HonorEarReturnClient.this.mContext.getPackageName())) {
                    HonorEarReturnClient.this.serviceLinkToDeath(service);
                    HonorEarReturnClient.this.mFeatureKitManager.onCallBack(1000);
                    return;
                }
                HonorEarReturnClient.this.mFeatureKitManager.onCallBack(1002);
            }
        }

        public final void onServiceDisconnected(ComponentName name) {
            HonorLogUtils.info(HonorEarReturnClient.TAG, "onServiceDisconnected");
            HonorEarReturnClient.this.mIsServiceConnected = false;
            if (HonorEarReturnClient.this.mFeatureKitManager != null) {
                HonorEarReturnClient.this.mFeatureKitManager.onCallBack(1001);
            }
        }
    };
    private IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        public final void binderDied() {
            HonorLogUtils.error(HonorEarReturnClient.TAG, "binderDied");
            HonorEarReturnClient.this.mService.unlinkToDeath(HonorEarReturnClient.this.mDeathRecipient, 0);
            HonorEarReturnClient.this.mFeatureKitManager.onCallBack(1003);
            HonorEarReturnClient.this.mService = null;
        }
    };

    public HonorEarReturnClient(Context context) {
        this.mFeatureKitManager = HonorFeatureKitManager.getInstance();
        this.mContext = context;
    }

    private void serviceLinkToDeath(IBinder service) {
        this.mService = service;
        if (service != null) {
            try {
                service.linkToDeath(this.mDeathRecipient, 0);
                return;
            }
            catch (Throwable throwable) {
                this.mFeatureKitManager.onCallBack(1002);
                HonorLogUtils.error(TAG, "serviceLinkToDeath, RemoteException");
            }
        }
    }

    public void initialize(Context context) {
        HonorLogUtils.info(TAG, "initialize");
        if (context == null) {
            HonorLogUtils.info(TAG, "initialize, context is null");
            return;
        }
        if (!HonorFeatureKitManager.isAudioKitSupport(context)) {
            this.mFeatureKitManager.onCallBack(2);
            HonorLogUtils.info(TAG, "initialize, not install AudioEngine");
            return;
        }
        this.bindService(context);
    }

    private void bindService(Context context) {
        HonorLogUtils.info(TAG, "bindService");
        try {
            if (this.mFeatureKitManager != null && !this.mIsServiceConnected) {
                this.mFeatureKitManager.bindService(context, this.mConnection, ENGINE_CLASS_NAME);
            }
            return;
        }
        catch (Throwable throwable) {
            HonorLogUtils.error(TAG, "bindService,RemoteException ex : " + throwable.getMessage());
            return;
        }
    }

    @Override
    public void destroy() {
        try {
            super.destroy();
            HonorLogUtils.info(TAG, "destroy, mIsServiceConnected = " + this.mIsServiceConnected);
            if (this.mIsServiceConnected) {
                this.mIsServiceConnected = false;
                this.mFeatureKitManager.unbindService(this.mContext, this.mConnection);
            }
            return;
        }
        catch (Throwable throwable) {
            HonorLogUtils.error(TAG, "bindService,RemoteException ex : " + throwable.getMessage());
            return;
        }
    }

    public int enableEarReturn(boolean enable) {
        HonorLogUtils.info(TAG, "enableEarReturn, enable = ".concat(String.valueOf(enable)));
        try {
            if (this.mHnEarReturnService != null && this.mIsServiceConnected) {
                return this.mHnEarReturnService.enableEarReturn(enable);
            }
            return -2;
        }
        catch (Throwable throwable) {
            HonorLogUtils.error(TAG, "enableEarReturn,RemoteException ex : " + throwable.getMessage());
            return -2;
        }
    }

    private int getEarReturnLatency() {
        HonorLogUtils.info(TAG, "getEarReturnLatency");
        try {
            if (this.mHnEarReturnService != null && this.mIsServiceConnected) {
                return this.mHnEarReturnService.getEarReturnLatency();
            }
            return -1;
        }
        catch (Throwable throwable) {
            HonorLogUtils.error(TAG, "getEarReturnLatency,RemoteException ex : " + throwable.getMessage());
            return -1;
        }
    }

    public int setParameter(ParameName param, int value) {
        if (param == null) {
            return 1807;
        }
        try {
            HonorLogUtils.info(TAG, "parameValue =" + value + ", parame.getParameName() =" + param.getParameName());
            if (this.mHnEarReturnService != null && this.mIsServiceConnected) {
                return this.mHnEarReturnService.setParameter(param.getParameName(), value);
            }
            return -2;
        }
        catch (Throwable throwable) {
            HonorLogUtils.error(TAG, "setParameter,RemoteException ex : " + throwable.getMessage());
            return -2;
        }
    }

    private boolean serviceInit(String packageName) {
        boolean bl2 = true;
        try {
            if (this.mHnEarReturnService != null && this.mIsServiceConnected) {
                this.mHnEarReturnService.init(packageName);
            }
        }
        catch (Throwable throwable) {
            HonorLogUtils.error(TAG, "isSupported,RemoteException ex :" + throwable.getMessage());
            bl2 = false;
        }
        return bl2;
    }

    @Override
    public boolean isServiceSupported() {
        HonorLogUtils.info(TAG, "isSupported, type = " + HonorAudioClient.ServiceType.HNAUDIO_SERVICE_EARRETURN.getServiceType());
        try {
            if (this.mHnEarReturnService != null && this.mIsServiceConnected) {
                return this.mHnEarReturnService.isSupported(HonorAudioClient.ServiceType.HNAUDIO_SERVICE_EARRETURN.getServiceType());
            }
        }
        catch (Throwable throwable) {
            HonorLogUtils.error(TAG, "isSupported,RemoteException ex : " + throwable.getMessage());
        }
        return super.isServiceSupported();
    }

    public static enum ParameName {
        CMD_SET_AUDIO_EFFECT_MODE_BASE("Karaoke_reverb_mode="),
        CMD_SET_VOCAL_VOLUME_BASE("Karaoke_volume="),
        CMD_SET_VOCAL_EQUALIZER_MODE("Karaoke_eq_mode=");

        private String mParameName;

        private ParameName(String parameName) {
            this.mParameName = parameName;
        }

        public final String getParameName() {
            return this.mParameName;
        }
    }
}

