/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trtc.hardwareearmonitor.honor;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import com.tencent.trtc.hardwareearmonitor.honor.HonorAudioFeaturesKit;
import com.tencent.trtc.hardwareearmonitor.honor.HonorFeatureKitManager;
import com.tencent.trtc.hardwareearmonitor.honor.HonorLogUtils;
import com.tencent.trtc.hardwareearmonitor.honor.IHonorAudioPlayService;

public class HonorAudioPlayClient
extends HonorAudioFeaturesKit {
    private static final String TAG = "HnAudioEngine.HnAudioPlayClient";
    private static final String ENGINE_CLASS_NAME = "com.hihonor.android.magicx.media.audioengine.HnAudioPlayServiceImpl";
    private Context mContext;
    private HonorFeatureKitManager mFeatureKitManager = null;
    private IHonorAudioPlayService mHnAudioPlayService;
    private boolean mIsServiceConnected = false;
    private IBinder mService = null;
    private ServiceConnection mConnection = new ServiceConnection(){

        public final void onServiceConnected(ComponentName name, IBinder service) {
            HonorLogUtils.info(HonorAudioPlayClient.TAG, "onServiceConnected");
            HonorAudioPlayClient.this.mHnAudioPlayService = IHonorAudioPlayService.Stub.asInterface(service);
            if (HonorAudioPlayClient.this.mHnAudioPlayService != null) {
                HonorAudioPlayClient.this.mIsServiceConnected = true;
                HonorAudioPlayClient.this.serviceInit(HonorAudioPlayClient.this.mContext.getPackageName());
                HonorAudioPlayClient.this.serviceLinkToDeath(service);
                HonorAudioPlayClient.this.mFeatureKitManager.onCallBack(3000);
            }
        }

        public final void onServiceDisconnected(ComponentName name) {
            HonorLogUtils.info(HonorAudioPlayClient.TAG, "onServiceDisconnected");
            HonorAudioPlayClient.this.mIsServiceConnected = false;
            if (HonorAudioPlayClient.this.mFeatureKitManager != null) {
                HonorAudioPlayClient.this.mFeatureKitManager.onCallBack(3001);
            }
        }
    };
    private IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        public final void binderDied() {
            HonorAudioPlayClient.this.mService.unlinkToDeath(HonorAudioPlayClient.this.mDeathRecipient, 0);
            HonorAudioPlayClient.this.mFeatureKitManager.onCallBack(3004);
            HonorLogUtils.error(HonorAudioPlayClient.TAG, "service binder died");
            HonorAudioPlayClient.this.mService = null;
        }
    };

    public HonorAudioPlayClient(Context context) {
        this.mFeatureKitManager = HonorFeatureKitManager.getInstance();
        this.mContext = context;
    }

    private void serviceInit(String packageName) {
        HonorLogUtils.info(TAG, "HnAudioPlayClient serviceInit");
        try {
            if (this.mHnAudioPlayService != null && this.mIsServiceConnected) {
                this.mHnAudioPlayService.init(packageName);
            }
            return;
        }
        catch (Throwable throwable) {
            HonorLogUtils.error(TAG, "HnAudioPlayClient isSupported,RemoteException ex :" + throwable.getMessage());
            return;
        }
    }

    private void serviceLinkToDeath(IBinder service) {
        this.mService = service;
        try {
            if (this.mService != null) {
                this.mService.linkToDeath(this.mDeathRecipient, 0);
            }
            return;
        }
        catch (Throwable throwable) {
            this.mFeatureKitManager.onCallBack(3003);
            HonorLogUtils.error(TAG, "serviceLinkToDeath, RemoteException");
            return;
        }
    }

    public void initialize(Context context) {
        if (context == null) {
            HonorLogUtils.info(TAG, "initialize, context is null");
            return;
        }
        if (!HonorFeatureKitManager.isAudioKitSupport(context)) {
            this.mFeatureKitManager.onCallBack(2);
            HonorLogUtils.info(TAG, "initialize, not install AudioEngine");
            return;
        }
        this.bindService(context);
    }

    private void bindService(Context context) {
        HonorLogUtils.info(TAG, "bindService");
        if (this.mFeatureKitManager != null && !this.mIsServiceConnected) {
            this.mFeatureKitManager.bindService(context, this.mConnection, ENGINE_CLASS_NAME);
        }
    }

    public void enableHighSampleRatePlay(boolean enable) {
        if (HonorFeatureKitManager.mMinVersion < 1000001L) {
            HonorLogUtils.error(TAG, "not support high sample rate play service. The mix version is " + HonorFeatureKitManager.mMinVersion);
            this.mFeatureKitManager.onCallBack(3002);
            return;
        }
        HonorLogUtils.info(TAG, "enableHighSampleRatePlay, enable = ".concat(String.valueOf(enable)));
        try {
            if (this.mHnAudioPlayService != null && this.mIsServiceConnected) {
                this.mHnAudioPlayService.enableHighSampleRatePlay(enable);
            }
            return;
        }
        catch (Throwable throwable) {
            HonorLogUtils.error(TAG, "enableHighSampleRatePlay,RemoteException ex : " + throwable.getMessage());
            return;
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        HonorLogUtils.info(TAG, "destroy, mIsServiceConnected = " + this.mIsServiceConnected);
        if (this.mIsServiceConnected) {
            this.mIsServiceConnected = false;
            this.mFeatureKitManager.unbindService(this.mContext, this.mConnection);
        }
    }
}

