/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trtc.hardwareearmonitor.daisy;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.trtc.hardwareearmonitor.daisy.DaisyAudioFeaturesKit;
import com.tencent.trtc.hardwareearmonitor.daisy.DaisyFeatureKitManager;
import com.tencent.trtc.hardwareearmonitor.daisy.IDaisyAudioKaraokeFeature;

public class DaisyAudioKaraokeFeatureKit
extends DaisyAudioFeaturesKit {
    private static final String TAG = "DaisyAudioKit.DaisyAudioKaraokeFeatureKit";
    private static final String ENGINE_CLASS_NAME = "com.huawei.multimedia.audioengine.HwAudioKaraokeFeatureService";
    private Context mContext;
    private DaisyFeatureKitManager mFeatureKitManager = null;
    private boolean mIsServiceConnected = false;
    private IDaisyAudioKaraokeFeature mIHwAudioKaraokeFeatureAidl;
    private IBinder mService = null;
    private ServiceConnection mConnection = new ServiceConnection(){

        public final void onServiceConnected(ComponentName name, IBinder service) {
            DaisyAudioKaraokeFeatureKit.this.mIHwAudioKaraokeFeatureAidl = IDaisyAudioKaraokeFeature.Stub.asInterface(service);
            if (DaisyAudioKaraokeFeatureKit.this.mIHwAudioKaraokeFeatureAidl != null) {
                DaisyAudioKaraokeFeatureKit.this.mIsServiceConnected = true;
                if (DaisyAudioKaraokeFeatureKit.this.serviceInit(DaisyAudioKaraokeFeatureKit.this.mContext.getPackageName())) {
                    DaisyAudioKaraokeFeatureKit.this.mFeatureKitManager.onCallBack(1000);
                    DaisyAudioKaraokeFeatureKit.this.serviceLinkToDeath(service);
                    return;
                }
                DaisyAudioKaraokeFeatureKit.this.mFeatureKitManager.onCallBack(1002);
            }
        }

        public final void onServiceDisconnected(ComponentName name) {
            DaisyAudioKaraokeFeatureKit.this.mIsServiceConnected = false;
            if (DaisyAudioKaraokeFeatureKit.this.mFeatureKitManager != null) {
                DaisyAudioKaraokeFeatureKit.this.mFeatureKitManager.onCallBack(1001);
            }
        }
    };
    private IBinder.DeathRecipient mDeathRecipient = new IBinder.DeathRecipient(){

        public final void binderDied() {
            LiteavLog.e(DaisyAudioKaraokeFeatureKit.TAG, "binderDied");
            DaisyAudioKaraokeFeatureKit.this.mService.unlinkToDeath(DaisyAudioKaraokeFeatureKit.this.mDeathRecipient, 0);
            DaisyAudioKaraokeFeatureKit.this.mFeatureKitManager.onCallBack(1003);
            DaisyAudioKaraokeFeatureKit.this.mService = null;
        }
    };

    protected DaisyAudioKaraokeFeatureKit(Context context) {
        this.mFeatureKitManager = DaisyFeatureKitManager.getInstance();
        this.mContext = context;
    }

    private void serviceLinkToDeath(IBinder service) {
        this.mService = service;
        try {
            if (service != null) {
                service.linkToDeath(this.mDeathRecipient, 0);
            }
            return;
        }
        catch (Throwable throwable) {
            this.mFeatureKitManager.onCallBack(1002);
            LiteavLog.e(TAG, "serviceLinkToDeath, RemoteException");
            return;
        }
    }

    protected void initialize(Context context) {
        if (context == null) {
            return;
        }
        if (!DaisyFeatureKitManager.isAudioKitSupport(context)) {
            this.mFeatureKitManager.onCallBack(2);
            return;
        }
        this.bindService(context);
    }

    private void bindService(Context context) {
        try {
            if (this.mFeatureKitManager != null && !this.mIsServiceConnected) {
                this.mFeatureKitManager.bindService(context, this.mConnection, ENGINE_CLASS_NAME);
            }
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "bindService,RemoteException ex : %s", throwable.getMessage());
            return;
        }
    }

    public void destroy() {
        try {
            if (this.mIsServiceConnected) {
                this.mIsServiceConnected = false;
                this.mFeatureKitManager.unbindService(this.mContext, this.mConnection);
            }
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "unbindService,RemoteException ex : %s", throwable.getMessage());
            return;
        }
    }

    public boolean isKaraokeFeatureSupport() {
        try {
            if (this.mIHwAudioKaraokeFeatureAidl != null && this.mIsServiceConnected) {
                return this.mIHwAudioKaraokeFeatureAidl.isKaraokeFeatureSupport();
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "isFeatureSupported,RemoteException ex : %s", throwable.getMessage());
        }
        return false;
    }

    public int enableKaraokeFeature(boolean enable) {
        try {
            if (this.mIHwAudioKaraokeFeatureAidl != null && this.mIsServiceConnected) {
                return this.mIHwAudioKaraokeFeatureAidl.enableKaraokeFeature(enable);
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "enableKaraokeFeature,RemoteException ex : %s", throwable.getMessage());
        }
        return -2;
    }

    public int getKaraokeLatency() {
        try {
            if (this.mIHwAudioKaraokeFeatureAidl != null && this.mIsServiceConnected) {
                return this.mIHwAudioKaraokeFeatureAidl.getKaraokeLatency();
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "getKaraokeLatency,RemoteException ex : %s", throwable.getMessage());
        }
        return -1;
    }

    public int setParameter(ParameName param, int value) {
        if (param == null) {
            return 1807;
        }
        try {
            if (this.mIHwAudioKaraokeFeatureAidl != null && this.mIsServiceConnected) {
                return this.mIHwAudioKaraokeFeatureAidl.setParameter(param.getParameName(), value);
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "setParameter,RemoteException ex : %s", throwable.getMessage());
        }
        return -2;
    }

    private boolean serviceInit(String packageName) {
        boolean bl2 = true;
        try {
            if (this.mIHwAudioKaraokeFeatureAidl != null && this.mIsServiceConnected) {
                this.mIHwAudioKaraokeFeatureAidl.init(packageName);
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "isFeatureSupported,RemoteException ex : %s", throwable.getMessage());
            bl2 = false;
        }
        return bl2;
    }

    public static enum ParameName {
        CMD_SET_AUDIO_EFFECT_MODE_BASE("Karaoke_reverb_mode="),
        CMD_SET_VOCAL_VOLUME_BASE("Karaoke_volume="),
        CMD_SET_VOCAL_EQUALIZER_MODE("Karaoke_eq_mode=");

        private String mParameName;

        private ParameName(String parameName) {
            this.mParameName = parameName;
        }

        public final String getParameName() {
            return this.mParameName;
        }
    }
}

