/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.tcmedia.core.common;

import android.content.Context;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.Display;
import android.view.WindowManager;
import com.tencent.thumbplayer.tcmedia.core.common.TPNativeLog;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TPScreenRefreshRateDetector {
    private static String TAG = "TPScreenRefreshRateDetector";
    private static boolean isInitted = false;
    private static WeakReference<Context> mContext = null;
    private static WindowManager mWindowManager = null;
    private static List<ScreenRefreshRateChangedListener> listeners = new LinkedList<ScreenRefreshRateChangedListener>();
    private static float mCurScreenRefreshRate = 60.0f;
    private static DisplayManager mDisplayManager = null;
    private static Handler mHandler;
    public static final int DISPLAY_CHANGE = 10001;
    private static DisplayManager.DisplayListener mDisplayListener;

    private static Looper getLooper() {
        Looper looper = Looper.myLooper();
        if (looper != null) {
            return looper;
        }
        return Looper.getMainLooper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyScreenRefreshRateChange(float f2) {
        boolean bl2 = false;
        if (Math.abs(f2 - mCurScreenRefreshRate) >= 1.0f) {
            TPNativeLog.printLog(2, TAG, "notifyScreenRefreshRateChange Change From " + mCurScreenRefreshRate + " to " + f2);
            bl2 = true;
        }
        if (!bl2) {
            return;
        }
        mCurScreenRefreshRate = f2;
        Class<TPScreenRefreshRateDetector> clazz = TPScreenRefreshRateDetector.class;
        synchronized (TPScreenRefreshRateDetector.class) {
            Iterator<ScreenRefreshRateChangedListener> iterator = listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onScreenRefreshRateChanged(f2);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void initHandleMsg() {
        mHandler = new Handler(TPScreenRefreshRateDetector.getLooper()){

            public final void handleMessage(Message message) {
                switch (message.what) {
                    case 10001: {
                        if (mDisplayManager == null) break;
                        Display display = mDisplayManager.getDisplay(0);
                        String string = display.getMode().toString();
                        TPNativeLog.printLog(2, TAG, "handleMessage DISPLAY_CHANGE, mode:" + string.toString());
                        TPScreenRefreshRateDetector.notifyScreenRefreshRateChange(display.getMode().getRefreshRate());
                    }
                }
                super.handleMessage(message);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context context) {
        Class<TPScreenRefreshRateDetector> clazz = TPScreenRefreshRateDetector.class;
        synchronized (TPScreenRefreshRateDetector.class) {
            TPNativeLog.printLog(2, TAG, "TPScreenRefreshRateDetector init enter!");
            if (isInitted) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Context context2 = context.getApplicationContext();
            mContext = new WeakReference<Context>(context2);
            isInitted = true;
            TPScreenRefreshRateDetector.initHandleMsg();
            TPNativeLog.printLog(2, TAG, "TPScreenRefreshRateDetector init succeed!");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deinit() {
        Class<TPScreenRefreshRateDetector> clazz = TPScreenRefreshRateDetector.class;
        synchronized (TPScreenRefreshRateDetector.class) {
            if (!isInitted || mContext == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            mContext.clear();
            isInitted = false;
            TPNativeLog.printLog(2, TAG, "TPScreenRefreshRateDetector deinit succeed!");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(ScreenRefreshRateChangedListener screenRefreshRateChangedListener) {
        Class<TPScreenRefreshRateDetector> clazz = TPScreenRefreshRateDetector.class;
        synchronized (TPScreenRefreshRateDetector.class) {
            listeners.add(screenRefreshRateChangedListener);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(ScreenRefreshRateChangedListener screenRefreshRateChangedListener) {
        Class<TPScreenRefreshRateDetector> clazz = TPScreenRefreshRateDetector.class;
        synchronized (TPScreenRefreshRateDetector.class) {
            listeners.remove(screenRefreshRateChangedListener);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static float getScreenRefreshRate() {
        if (Build.VERSION.SDK_INT < 23) {
            TPNativeLog.printLog(4, TAG, "Current version can not get screen refresh rate, set default.");
            return mCurScreenRefreshRate;
        }
        if (mContext == null) {
            TPNativeLog.printLog(4, TAG, "Current mContext is null, set default.");
            return mCurScreenRefreshRate;
        }
        Context context = (Context)mContext.get();
        if (context != null) {
            if (mWindowManager == null) {
                mWindowManager = (WindowManager)context.getSystemService("window");
            }
            if (mDisplayManager == null) {
                mDisplayManager = (DisplayManager)context.getSystemService("display");
                mDisplayManager.registerDisplayListener(mDisplayListener, mHandler);
            }
            if (mWindowManager != null) {
                Display display = mWindowManager.getDefaultDisplay();
                Display.Mode[] modeArray = display.getSupportedModes();
                Display.Mode mode = display.getMode();
                TPNativeLog.printLog(2, TAG, "getMode width:" + mode.getPhysicalWidth() + " height:" + mode.getPhysicalHeight() + " refreshRate:" + mode.getRefreshRate() + " ModeId:" + mode.getModeId());
                TPNativeLog.printLog(2, TAG, "getSupportedModes length:" + modeArray.length);
                for (int i2 = 0; i2 < modeArray.length; ++i2) {
                    TPNativeLog.printLog(2, TAG, "getSupportedModes width:" + modeArray[i2].getPhysicalWidth() + " height:" + modeArray[i2].getPhysicalHeight() + " refreshRate:" + modeArray[i2].getRefreshRate() + " ModeId:" + modeArray[i2].getModeId());
                }
                mCurScreenRefreshRate = mode.getRefreshRate();
            }
        }
        return mCurScreenRefreshRate;
    }

    static {
        mDisplayListener = new DisplayManager.DisplayListener(){

            public final void onDisplayAdded(int n2) {
            }

            public final void onDisplayRemoved(int n2) {
            }

            public final void onDisplayChanged(int n2) {
                if (n2 == 0) {
                    mHandler.sendEmptyMessage(10001);
                }
                TPNativeLog.printLog(2, TAG, "onDisplayChanged displayId:".concat(String.valueOf(n2)));
            }
        };
    }

    static interface ScreenRefreshRateChangedListener {
        public void onScreenRefreshRateChanged(float var1);
    }
}

