/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.downloader;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Pair;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.sdk.common.LicenseChecker;
import com.tencent.liteav.txcvodplayer.b.c;
import com.tencent.liteav.txcvodplayer.hlsencoder.TXCHLSEncoder;
import com.tencent.rtmp.TXPlayInfoParams;
import com.tencent.rtmp.TXPlayerDrmBuilder;
import com.tencent.rtmp.downloader.ITXVodFilePreloadListener;
import com.tencent.rtmp.downloader.ITXVodPreloadListener;
import com.tencent.thumbplayer.tcmedia.core.downloadproxy.api.ITPDownloadProxy;
import com.tencent.thumbplayer.tcmedia.core.downloadproxy.api.ITPPreLoadListener;
import com.tencent.thumbplayer.tcmedia.core.downloadproxy.api.TPDLProxyInitParam;
import com.tencent.thumbplayer.tcmedia.core.downloadproxy.api.TPDownloadParam;
import com.tencent.thumbplayer.tcmedia.core.downloadproxy.api.TPDownloadProxyFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;

public class TXVodPreloadManager {
    private static final String TAG = "TXVodPreloadManager";
    private static final String THUMB_PLAYER_GUID = "liteav_tbplayer_android_";
    private static final int THUMB_PLAYER_PLATFORM_ID = 2330303;
    private ITPDownloadProxy mTpDownloadProxy;
    private boolean mInit = false;
    private static Context mAppContext;

    private TXVodPreloadManager() {
    }

    public static TXVodPreloadManager getInstance(Context context) {
        if (context != null) {
            mAppContext = context.getApplicationContext();
            ContextUtils.initApplicationContext(mAppContext);
            ContextUtils.setDataDirectorySuffix("liteav");
            return a.a;
        }
        return null;
    }

    private synchronized Pair<Integer, String> checkInit() {
        this.mTpDownloadProxy = TPDownloadProxyFactory.getTPDownloadProxy(2330303);
        if (this.mTpDownloadProxy != null) {
            int n2 = com.tencent.liteav.txcplayer.common.b.b();
            if (n2 < 0) {
                LiteavLog.e(TAG, "MaxCacheSize not set(-1).");
                return new Pair((Object)-1, (Object)"MaxCacheSize not set.");
            }
            String string = com.tencent.liteav.txcplayer.common.b.a();
            if (TextUtils.equals((CharSequence)string, (CharSequence)"NO_SET")) {
                LiteavLog.e(TAG, "CacheFolderPath not set(-2).");
                return new Pair((Object)-2, (Object)"CacheFolderPath not set.");
            }
            if (!this.mInit) {
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("VodCacheReserveSizeMB", n2);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                TPDLProxyInitParam tPDLProxyInitParam = new TPDLProxyInitParam(2330303, "1.0.0", THUMB_PLAYER_GUID + mAppContext.getPackageName(), null, string, jSONObject.toString());
                this.mTpDownloadProxy.init(mAppContext, tPDLProxyInitParam);
                this.mInit = true;
            }
            this.mTpDownloadProxy.updateStoragePath(string);
            this.mTpDownloadProxy.setMaxStorageSizeMB(n2);
            return new Pair((Object)0, null);
        }
        LiteavLog.e(TAG, "Inner error(-3).");
        return new Pair((Object)-3, (Object)"Inner error.");
    }

    public int startPreload(String url, float preloadSizeMB, long preferredResolution, ITXVodPreloadListener listener) {
        LiteavLog.i(TAG, "startPreload for url, url: " + url + " ,preloadSizeMB: " + preloadSizeMB + " ,preferredResolution: " + preferredResolution + " ,listener: " + listener);
        return this.startPreload(url, preloadSizeMB, preferredResolution, listener, 0, 0, null, "");
    }

    private int startPreload(String url, float preloadSizeMB, long preferredResolution, ITXVodPreloadListener listener, int dlType, int encryptedMp4Level, Map<String, String> headers, String preferredAudioTrack) {
        int n2;
        Object object;
        Pair<Integer, String> pair = this.checkInit();
        if ((Integer)pair.first < 0) {
            if (listener != null) {
                listener.onError(-1, url, (Integer)pair.first, (String)pair.second);
            }
            return -1;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(url);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (headers != null && headers.size() > 0) {
            object = new ArrayList<Map<String, String>>();
            ((ArrayList)object).add(headers);
            hashMap.put("dl_param_url_header", object);
        }
        hashMap.put("dl_param_preload_size", (long)(preloadSizeMB * 1024.0f * 1024.0f));
        hashMap.put("dl_param_preferred_resolution", preferredResolution);
        if (encryptedMp4Level == 2 && com.tencent.liteav.txcplayer.common.c.a(LicenseChecker.a.h)) {
            hashMap.put("dl_param_cache_need_encrypt", Boolean.TRUE);
        }
        if (!TextUtils.isEmpty((CharSequence)preferredAudioTrack) && com.tencent.liteav.txcplayer.common.c.a(LicenseChecker.a.h)) {
            hashMap.put("dl_param_preferred_audio_track", preferredAudioTrack);
        }
        object = new TPDownloadParam(arrayList, this.checkDlType(dlType, url), hashMap);
        b b2 = new b(this.mTpDownloadProxy, url, listener);
        b2.a = n2 = this.mTpDownloadProxy.startPreload(com.tencent.liteav.txcplayer.a.a.d(url), (TPDownloadParam)object, b2);
        LiteavLog.i(TAG, "startPreload for url success, url: " + url + " ,taskID: " + n2);
        return n2;
    }

    private int checkDlType(int mediaType, String url) {
        switch (mediaType) {
            case 1: {
                return 3;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 10;
            }
            case 4: {
                return 19;
            }
        }
        if (TextUtils.isEmpty((CharSequence)url)) {
            return 0;
        }
        if (com.tencent.liteav.txcplayer.a.a.d(url).endsWith(".mp4")) {
            return 10;
        }
        return 0;
    }

    public int startPreload(final TXPlayInfoParams playInfoParams, final float preloadSizeMB, final long preferredResolution, final ITXVodFilePreloadListener listener) throws RuntimeException {
        LiteavLog.i(TAG, "startPreload for TXPlayInfoParams, playInfoParams: " + playInfoParams + " ,preloadSizeMB: " + preloadSizeMB + " ,preferredResolution: " + preferredResolution + " ,listener: " + listener);
        if (playInfoParams != null && !TextUtils.isEmpty((CharSequence)playInfoParams.getUrl()) && TextUtils.isEmpty((CharSequence)playInfoParams.getFileId())) {
            return this.startPreload(playInfoParams.getUrl(), preloadSizeMB, preferredResolution, listener, this.checkDlType(playInfoParams.getMediaType(), playInfoParams.getUrl()), playInfoParams.getEncryptedMp4Level(), playInfoParams.getHeaders(), playInfoParams.getPreferAudioTrack());
        }
        if (Looper.myLooper() == Looper.getMainLooper()) {
            LiteavLog.e(TAG, "startPreload for TXPlayInfoParams can not be called on the main thread.");
            throw new RuntimeException("startPreload for TXPlayInfoParams can not be called on the main thread.");
        }
        Pair<Integer, String> pair = this.checkInit();
        if ((Integer)pair.first < 0) {
            if (listener != null) {
                listener.onError(-1, "", (Integer)pair.first, (String)pair.second);
            }
            return -1;
        }
        if (playInfoParams == null || playInfoParams.getAppId() == 0 || TextUtils.isEmpty((CharSequence)playInfoParams.getFileId())) {
            if (listener != null) {
                listener.onError(-1, "", -1, " invalid params, appId or fileId is null");
            }
            return -1;
        }
        final AtomicInteger atomicInteger = new AtomicInteger(-1);
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        new c(playInfoParams).a(new c.a(){

            @Override
            public final void a(c c2, TXPlayInfoParams tXPlayInfoParams) {
                int n2;
                Object object;
                ArrayList<String> arrayList;
                List<c.d> list;
                Pair pair;
                String string;
                boolean bl2;
                Object object2 = c2;
                String string2 = ((c)object2).l();
                if ("SimpleAES".equalsIgnoreCase(string2)) {
                    bl2 = true;
                } else {
                    String string3 = ((c)object2).a("Widevine");
                    bl2 = "Widevine".equalsIgnoreCase(string2) && !TextUtils.isEmpty((CharSequence)string3);
                }
                if (!(!bl2 ? true : com.tencent.liteav.txcplayer.common.c.a(LicenseChecker.a.h))) {
                    LiteavLog.e(TXVodPreloadManager.TAG, "Encrypted fileId preload needs Player Premium license! fileId=" + tXPlayInfoParams.getFileId());
                    countDownLatch.countDown();
                    if (listener != null) {
                        listener.onError(-1, "", -5, "Encrypted fileId preload needs Player Premium license!");
                    }
                    return;
                }
                Bundle bundle = new Bundle();
                long l2 = preferredResolution;
                object2 = tXPlayInfoParams;
                c c3 = c2;
                String string4 = c3.b();
                String string5 = c3.l();
                if (TextUtils.isEmpty((CharSequence)string5)) {
                    string5 = "plain";
                }
                if ("plain".equalsIgnoreCase(string5)) {
                    string = string4;
                    string4 = com.tencent.liteav.txcplayer.a.a.a(string4, ((TXPlayInfoParams)object2).getFileId(), string5, ((TXPlayInfoParams)object2).getAppId());
                    pair = new Pair((Object)string, (Object)string4);
                } else {
                    boolean bl3;
                    string = c3.a("Widevine");
                    boolean bl4 = bl3 = !TextUtils.isEmpty((CharSequence)string);
                    if ("SimpleAES".equalsIgnoreCase(c3.l()) || bl3) {
                        c.b b2;
                        if (bl3) {
                            string4 = string;
                        }
                        if ((b2 = c3.d) == null || TextUtils.isEmpty((CharSequence)b2.a)) {
                            LiteavLog.e("VodPreloadUtil", "overlayKey is null fileId=" + ((TXPlayInfoParams)object2).getFileId());
                            String string6 = string4;
                            pair = new Pair((Object)string6, (Object)string6);
                        } else {
                            String string7 = TXCHLSEncoder.a(((TXPlayInfoParams)object2).getAppId(), "default", ((TXPlayInfoParams)object2).getFileId(), 0);
                            String string8 = TXCHLSEncoder.a(string7, b2.a);
                            String string9 = TXCHLSEncoder.a(string7, b2.b);
                            if (TextUtils.isEmpty((CharSequence)string8) || TextUtils.isEmpty((CharSequence)string9)) {
                                LiteavLog.e("VodPreloadUtil", "create local key exception for fileId=" + ((TXPlayInfoParams)object2).getFileId());
                                String string10 = string4;
                                pair = new Pair((Object)string10, (Object)string10);
                            } else {
                                String string11;
                                com.tencent.liteav.txcvodplayer.c.a.a().a(((TXPlayInfoParams)object2).getAppId(), ((TXPlayInfoParams)object2).getFileId(), b2);
                                String string12 = string4 = com.tencent.liteav.txcplayer.a.a.a(string4, c3.d());
                                String string13 = com.tencent.liteav.txcplayer.a.a.a(string4, ((TXPlayInfoParams)object2).getFileId(), string5, ((TXPlayInfoParams)object2).getAppId());
                                StringBuilder stringBuilder = new StringBuilder().append(string13);
                                String string14 = string9;
                                String string15 = string8;
                                long l3 = l2;
                                Object object3 = object2;
                                c c4 = c3;
                                StringBuilder stringBuilder2 = new StringBuilder();
                                stringBuilder2.append("&oversign=").append(((TXPlayInfoParams)object3).getAppId()).append("&o1=default&o2=").append(((TXPlayInfoParams)object3).getFileId()).append("&o3=&o4=").append(string15).append("&o5=").append(string14);
                                if (l3 > 0L) {
                                    stringBuilder2.append("&o6=").append(l3);
                                }
                                if (!TextUtils.isEmpty((CharSequence)(string11 = c4.m()))) {
                                    stringBuilder2.append("&o7=").append(string11);
                                }
                                if (stringBuilder2.length() > 0) {
                                    stringBuilder2.append("&oversign=");
                                }
                                string4 = stringBuilder.append(stringBuilder2.toString()).toString();
                                pair = new Pair((Object)string12, (Object)string4);
                            }
                        }
                    } else {
                        LiteavLog.e("VodPreloadUtil", "invalid drmType=" + c3.l() + " ,fileId=" + ((TXPlayInfoParams)object2).getFileId());
                        String string16 = string4;
                        pair = new Pair((Object)string16, (Object)string16);
                    }
                }
                Pair pair2 = pair;
                bundle.putString("EVT_PLAY_URL", (String)pair2.second);
                bundle.putString("EVT_PLAY_COVER_URL", c2.c());
                bundle.putString("EVT_PLAY_NAME", c2.e());
                bundle.putString("EVT_PLAY_DESCRIPTION", c2.f());
                bundle.putInt("EVT_PLAY_DURATION", c2.g());
                c3 = c2;
                bundle.putString("EVT_DRM_TYPE", c3 == null || TextUtils.isEmpty((CharSequence)c3.l()) ? "plain" : c3.l());
                c.c c5 = c2.i();
                if (c5 != null) {
                    bundle.putString("EVT_IMAGESPRIT_WEBVTTURL", c5.b);
                    bundle.putStringArrayList("EVT_IMAGESPRIT_IMAGEURL_LIST", c5.a);
                }
                if ((list = c2.j()) != null && !list.isEmpty()) {
                    arrayList = new ArrayList<String>();
                    object = new float[list.size()];
                    for (int i2 = 0; i2 < list.size(); ++i2) {
                        arrayList.add(list.get((int)i2).a);
                        object[i2] = list.get((int)i2).b;
                    }
                    bundle.putStringArrayList("EVT_KEY_FRAME_CONTENT_LIST", arrayList);
                    bundle.putFloatArray("EVT_KEY_FRAME_TIME_LIST", (float[])object);
                }
                bundle.putString("EVT_DRM_TYPE", c2.l());
                arrayList = new ArrayList<Object>();
                arrayList.add((String)pair2.first);
                object = new HashMap();
                if (playInfoParams.getHeaders() != null && playInfoParams.getHeaders().size() > 0) {
                    ArrayList<Map<String, String>> arrayList2 = new ArrayList<Map<String, String>>();
                    arrayList2.add(playInfoParams.getHeaders());
                    object.put("dl_param_url_header", arrayList2);
                }
                object.put("dl_param_preload_size", Float.valueOf(preloadSizeMB * 1024.0f * 1024.0f));
                object.put("dl_param_preferred_resolution", preferredResolution);
                if (playInfoParams.getEncryptedMp4Level() == 2 && com.tencent.liteav.txcplayer.common.c.a(LicenseChecker.a.h)) {
                    object.put("dl_param_cache_need_encrypt", Boolean.TRUE);
                }
                if (!TextUtils.isEmpty((CharSequence)c2.m())) {
                    object.put("dl_param_key_license_url", c2.m());
                    object.put("dl_param_device_certificate_url", new TXPlayerDrmBuilder().getDeviceCertificateUrl());
                }
                if (!TextUtils.isEmpty((CharSequence)playInfoParams.getPreferAudioTrack()) && com.tencent.liteav.txcplayer.common.c.a(LicenseChecker.a.h)) {
                    object.put("dl_param_preferred_audio_track", playInfoParams.getPreferAudioTrack());
                }
                TPDownloadParam tPDownloadParam = new TPDownloadParam(arrayList, TXVodPreloadManager.this.checkDlType(playInfoParams.getMediaType(), (String)pair2.first), (Map<String, Object>)object);
                b b3 = new b(TXVodPreloadManager.this.mTpDownloadProxy, (String)pair2.second, listener);
                b3.a = n2 = TXVodPreloadManager.this.mTpDownloadProxy.startPreload(com.tencent.liteav.txcplayer.a.a.d((String)pair2.first), tPDownloadParam, b3);
                atomicInteger.set(n2);
                countDownLatch.countDown();
                if (listener != null) {
                    LiteavLog.i(TXVodPreloadManager.TAG, "startPreload for TXPlayInfoParams success, playInfoParams: " + playInfoParams + " ,taskID: " + n2);
                    listener.onStart(n2, tXPlayInfoParams.getFileId(), (String)pair2.second, bundle);
                }
            }

            @Override
            public final void a(int n2, String string) {
                countDownLatch.countDown();
                if (listener != null) {
                    LiteavLog.i(TXVodPreloadManager.TAG, "startPreload for TXPlayInfoParams failed, playInfoParams: " + playInfoParams + " ,getPlayInfo failed: " + string);
                    listener.onError(-1, "", n2, "getPlayInfo failed: ".concat(String.valueOf(string)));
                }
            }
        });
        try {
            countDownLatch.await(8L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return atomicInteger.get();
    }

    public void stopPreload(int taskID) {
        LiteavLog.i(TAG, "stopPreload, taskID: ".concat(String.valueOf(taskID)));
        if ((Integer)this.checkInit().first < 0) {
            return;
        }
        this.mTpDownloadProxy.stopPreload(taskID);
    }

    static final class b
    implements ITPPreLoadListener {
        private final ITXVodPreloadListener b;
        private final String c;
        int a = -1;
        private ITPDownloadProxy d;

        public b(ITPDownloadProxy iTPDownloadProxy, String string, ITXVodPreloadListener iTXVodPreloadListener) {
            this.c = string;
            this.b = iTXVodPreloadListener;
            this.d = iTPDownloadProxy;
        }

        @Override
        public final void onPrepareOK() {
            LiteavLog.d(TXVodPreloadManager.TAG, "preload: onPrepareOK");
            if (this.b != null) {
                this.b.onComplete(this.a, this.c);
            }
            b b2 = this;
            b2.a(b2.a);
        }

        @Override
        public final void onPrepareError(int moduleId, int errorCode, String extInfo) {
            LiteavLog.e(TXVodPreloadManager.TAG, "preload error: moduleId: " + moduleId + ", errorCode: " + errorCode + ", extInfo: " + extInfo);
            if (this.b != null) {
                this.b.onError(this.a, this.c, errorCode, extInfo);
            }
            b b2 = this;
            b2.a(b2.a);
        }

        @Override
        public final void onPrepareDownloadProgressUpdate(int playableDurationMs, int downloadSpeedKbytes, long currentDownloadSizeByte, long totalFileSizeByte, String exInfo) {
            LiteavLog.i(TXVodPreloadManager.TAG, "preload: prepare process:" + playableDurationMs + "," + downloadSpeedKbytes + "," + currentDownloadSizeByte + "," + totalFileSizeByte);
        }

        private void a(int n2) {
            if (this.d != null) {
                this.d.stopPreload(n2);
            }
        }
    }

    static final class a {
        static TXVodPreloadManager a = new TXVodPreloadManager();
    }
}

