/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.capture;

import android.opengl.GLES20;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.b.b;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.egl.EGLCore;
import com.tencent.liteav.videobase.egl.d;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.e;
import com.tencent.liteav.videobase.frame.i;
import com.tencent.liteav.videobase.utils.OpenGlUtils;

@JNINamespace(value="liteav::video")
public class CustomFrameToPixelFrameConverter {
    private static final String TAG = "CustomFrameToPixelFrameConverter";
    private final b mThrottlers = new b();
    private EGLCore mEGLCore = null;
    private i mPixelFrameRenderer = null;
    private e mGLTexturePool = null;
    private final Object mSharedContext;
    private int mWidth = 0;
    private int mHeight = 0;

    public CustomFrameToPixelFrameConverter(Object sharedContext) {
        this.mSharedContext = sharedContext;
    }

    public void release() {
        this.uninitializedGLComponents();
    }

    public PixelFrame convertFrame(PixelFrame pixelFrame) {
        if (pixelFrame == null) {
            LiteavLog.w(TAG, "convertFrame: pixelFrame is null.");
            return null;
        }
        if (this.mEGLCore == null || this.isNeedRecreateEGL(pixelFrame, this.mEGLCore)) {
            this.mWidth = pixelFrame.getWidth();
            this.mHeight = pixelFrame.getHeight();
            this.uninitializedGLComponents();
            CustomFrameToPixelFrameConverter customFrameToPixelFrameConverter = this;
            customFrameToPixelFrameConverter.initializeGLComponents(customFrameToPixelFrameConverter.mWidth, this.mHeight, pixelFrame);
        }
        if (this.mEGLCore == null || this.mGLTexturePool == null || this.mPixelFrameRenderer == null) {
            return null;
        }
        try {
            this.mEGLCore.makeCurrent();
        }
        catch (d d2) {
            LiteavLog.e(TAG, "EGL makeCurrent error ", d2);
        }
        OpenGlUtils.glViewport(0, 0, this.mWidth, this.mHeight);
        com.tencent.liteav.videobase.frame.d d3 = this.mGLTexturePool.a(this.mWidth, this.mHeight);
        GLConstants.GLScaleType gLScaleType = GLConstants.GLScaleType.a;
        this.mPixelFrameRenderer.a(pixelFrame, gLScaleType, d3);
        GLES20.glFinish();
        PixelFrame pixelFrame2 = d3.a(this.mEGLCore.getEglContext());
        pixelFrame2.setTimestamp(pixelFrame.getTimestamp());
        d3.release();
        return pixelFrame2;
    }

    public void releaseFrame(PixelFrame pixelFrame) {
        if (pixelFrame != null) {
            pixelFrame.release();
        }
    }

    private void initializeGLComponents(int width, int height, PixelFrame frame) {
        if (this.mEGLCore != null) {
            LiteavLog.w(this.mThrottlers.a("initGL"), TAG, "egl is initialized!", new Object[0]);
            return;
        }
        Object object = frame.getGLContext() != null ? frame.getGLContext() : this.mSharedContext;
        try {
            this.mEGLCore = new EGLCore();
            this.mEGLCore.initialize(object, null, width, height);
            this.mEGLCore.makeCurrent();
            LiteavLog.i(this.mThrottlers.a("initSuccess"), TAG, "initialize egl, width: " + width + ", height: " + height + ", sharedContext: " + object, new Object[0]);
        }
        catch (d d2) {
            LiteavLog.e(this.mThrottlers.a("initError"), TAG, "initialize egl failed.", d2);
            this.mEGLCore = null;
        }
        if (this.mEGLCore != null) {
            this.mGLTexturePool = new e();
            if (this.mPixelFrameRenderer == null) {
                this.mPixelFrameRenderer = new i(width, height);
            }
        }
    }

    private void uninitializedGLComponents() {
        if (this.mEGLCore == null) {
            return;
        }
        try {
            this.mEGLCore.makeCurrent();
        }
        catch (d d2) {
            LiteavLog.e(this.mThrottlers.a("make"), TAG, "uninitialize egl, make current error ", d2);
        }
        LiteavLog.i(this.mThrottlers.a("uninitGL"), TAG, "uninitialize egl", new Object[0]);
        if (this.mPixelFrameRenderer != null) {
            this.mPixelFrameRenderer.a();
            this.mPixelFrameRenderer = null;
        }
        if (this.mGLTexturePool != null) {
            this.mGLTexturePool.a();
            this.mGLTexturePool.b();
            this.mGLTexturePool = null;
        }
        EGLCore.destroy(this.mEGLCore);
        this.mEGLCore = null;
    }

    private boolean isNeedRecreateEGL(PixelFrame renderFrame, EGLCore eglCore) {
        boolean bl2;
        boolean bl3 = bl2 = renderFrame.getGLContext() != null && !CommonUtil.equals(renderFrame.getGLContext(), eglCore.getSharedContext());
        return renderFrame.getHeight() != this.mHeight || renderFrame.getWidth() != this.mWidth || bl2;
    }
}

