/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoconsumer.renderer;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.liteav.videobase.videobase.TXCCloudVideoViewMethodInvoker;
import com.tencent.liteav.videoconsumer.renderer.b;
import com.tencent.liteav.videoconsumer.renderer.f;
import com.tencent.liteav.videoconsumer.renderer.k;
import com.tencent.rtmp.ui.TXCloudVideoView;

@JNINamespace(value="liteav::video")
public abstract class RenderViewHelperInterface {
    private static final String TAG = "RenderViewHelperInterface";

    public static RenderViewHelperInterface create(DisplayTarget displayTarget, RenderViewListener listener) {
        if (displayTarget == null || displayTarget.getType() == null) {
            LiteavLog.w(TAG, "displayTarget or type is null. displayTarget=".concat(String.valueOf(displayTarget)));
            return null;
        }
        SurfaceView surfaceView = null;
        TextureView textureView = null;
        Surface surface = null;
        TXCloudVideoView tXCloudVideoView = null;
        switch (displayTarget.getType()) {
            case b: {
                surfaceView = displayTarget.getSurfaceView();
                break;
            }
            case a: {
                textureView = displayTarget.getTextureView();
                break;
            }
            case c: {
                surface = displayTarget.getSurface();
                break;
            }
            case d: {
                tXCloudVideoView = displayTarget.getTXCloudVideoView();
                if (tXCloudVideoView == null) {
                    LiteavLog.w(TAG, "txCloudVideoView is null.");
                    break;
                }
                surfaceView = tXCloudVideoView.getSurfaceView();
                textureView = TXCCloudVideoViewMethodInvoker.getTextureViewSetByUser(tXCloudVideoView);
            }
        }
        if (surfaceView != null) {
            return new f(surfaceView, listener);
        }
        if (textureView != null) {
            return new k(textureView, listener);
        }
        if (surface != null) {
            return new b(surface, listener);
        }
        if (tXCloudVideoView != null) {
            return new k(tXCloudVideoView, listener);
        }
        LiteavLog.w(TAG, "RenderViewHelper not created. displayTarget=".concat(String.valueOf(displayTarget)));
        return null;
    }

    public static void setBackgroundColor(DisplayTarget displayTarget, int backgroundColor) {
        if (displayTarget == null || displayTarget.getType() == null) {
            LiteavLog.w(TAG, "displayTarget or type is null. displayTarget=".concat(String.valueOf(displayTarget)));
            return;
        }
        switch (displayTarget.getType()) {
            case d: {
                TXCloudVideoView tXCloudVideoView = displayTarget.getTXCloudVideoView();
                if (tXCloudVideoView == null) break;
                TXCCloudVideoViewMethodInvoker.setBackgroundColorForInternalView(tXCloudVideoView, backgroundColor);
            }
        }
    }

    public abstract void updateVideoFrameInfo(GLConstants.GLScaleType var1, int var2, int var3, boolean var4);

    public abstract void release(boolean var1);

    public abstract Matrix getTransformMatrix(int var1, int var2);

    public abstract void checkViewAvailability();

    public abstract boolean isUsingTextureView();

    public abstract void enableNonUniformScale(boolean var1);

    public static GLConstants.GLScaleType createScaleType(int scaleType) {
        return GLConstants.GLScaleType.a(scaleType);
    }

    public static void releaseSurface(Surface surface) {
        if (surface != null) {
            surface.release();
        }
    }

    public static interface RenderViewListener {
        public void onSurfaceChanged(Surface var1, boolean var2);

        public void onRequestRedraw(Bitmap var1);

        public void onSurfaceDestroy();
    }
}

