/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base.util;

import android.net.SSLCertificateSocketFactory;
import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Base64;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

@JNINamespace(value="liteav::dns")
public class HttpDnsUtil {
    private static final String TAG = "HttpDnsUtil";
    private static Pattern sValidIPV4Pattern = null;
    private static final String sIPV4Regular = "(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])";
    private static boolean mEnableCustomHttpDNS = false;
    private static final Object mLock = new Object();
    private static final String sVerifyMethodBase64 = "c2V0SG9zdG5hbWVWZXJpZmllcg";
    private static final String sVClass = "amF2YXgubmV0LnNzbC5Ib3N0bmFtZVZlcmlmaWVy";
    private static final List<String> WHITE_LIST_HOST = new ArrayList<String>();
    private static a mCustomHttpDNSCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableCustomHttpDNS(boolean enable, a dnsCallback) {
        Object object = mLock;
        synchronized (object) {
            mEnableCustomHttpDNS = enable;
            mCustomHttpDNSCallback = dnsCallback;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parseAddressUseCustomHttpDns(String hostName) {
        if (!HttpDnsUtil.verifyCustomHttpDNS(hostName)) {
            return "";
        }
        long l2 = SystemClock.elapsedRealtime();
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = mLock;
        synchronized (object) {
            mCustomHttpDNSCallback.a(hostName, arrayList);
        }
        if (arrayList.size() > 0) {
            object = (String)arrayList.get(0);
            LiteavLog.i(TAG, "parse host: " + hostName + " and return ipAddress: " + (String)object + " ,costTime: " + (SystemClock.elapsedRealtime() - l2) + " ms");
            return object;
        }
        return "";
    }

    public static boolean isHostInWhiteList(String hostName) {
        if (TextUtils.isEmpty((CharSequence)hostName)) {
            return false;
        }
        String string = new String(Base64.encode((byte[])hostName.getBytes(), (int)0)).trim();
        return WHITE_LIST_HOST.contains(string);
    }

    public static boolean isIpAddress(String ipAddress) {
        if (ipAddress == null || "".equals(ipAddress)) {
            return false;
        }
        if (sValidIPV4Pattern == null) {
            try {
                sValidIPV4Pattern = Pattern.compile(sIPV4Regular, 2);
            }
            catch (Exception exception) {
                LiteavLog.e(TAG, "Pattern.compile fail " + Log.getStackTraceString(exception));
                return false;
            }
        }
        if (sValidIPV4Pattern.matcher(ipAddress).matches()) {
            return true;
        }
        return ipAddress.contains(":");
    }

    public static HttpURLConnection createConnectionUseCustomHttpDNS(String requestUrl, String hostName) throws Exception {
        String string = HttpDnsUtil.convertHttpDNSURL(requestUrl, hostName);
        if (TextUtils.isEmpty((CharSequence)string)) {
            return (HttpURLConnection)new URL(requestUrl).openConnection();
        }
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
        httpURLConnection.setRequestProperty("Host", hostName);
        HttpDnsUtil.applySniForHttpsConnection(httpURLConnection, hostName);
        LiteavLog.i(TAG, "create http conn use httpDns, original url: " + requestUrl + " , new url: " + string);
        return httpURLConnection;
    }

    public static String convertHttpDNSURL(String originURL, String hostName) throws Exception {
        String string = HttpDnsUtil.parseAddressUseCustomHttpDns(hostName);
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = originURL;
        InetAddress inetAddress = InetAddress.getByName(string);
        if (inetAddress instanceof Inet4Address) {
            return string2.replaceFirst(hostName, string);
        }
        if (inetAddress instanceof Inet6Address) {
            return string2.replaceFirst(hostName, "[" + string + "]");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyCustomHttpDNS(String hostName) {
        Object object = mLock;
        synchronized (object) {
            if (!mEnableCustomHttpDNS || mCustomHttpDNSCallback == null) {
                return false;
            }
        }
        if (HttpDnsUtil.isHostInWhiteList(hostName)) {
            return false;
        }
        if (HttpDnsUtil.isIpAddress(hostName)) {
            return false;
        }
        object = System.getProperty("http.proxyHost");
        String string = System.getProperty("http.proxyPort");
        if (object != null && string != null) {
            LiteavLog.w(TAG, "local proxy is on, don't use httpdns. proxyHost=" + (String)object + " ,proxyPort=" + string);
            return false;
        }
        return true;
    }

    public static void applySniForHttpsConnection(HttpURLConnection conn, final String hostName) {
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)conn;
            b b2 = new b(httpsURLConnection);
            httpsURLConnection.setSSLSocketFactory(b2);
            try {
                InvocationHandler invocationHandler = new InvocationHandler(){

                    @Override
                    public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (method.getName().equals("verify")) {
                            SSLSession sSLSession = (SSLSession)args[1];
                            return HttpsURLConnection.getDefaultHostnameVerifier().verify(hostName, sSLSession);
                        }
                        return method.invoke((Object)HttpsURLConnection.getDefaultHostnameVerifier(), args);
                    }
                };
                Class<?> clazz = Class.forName(new String(Base64.decode((String)sVClass, (int)0)));
                Object object = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, invocationHandler);
                String string = new String(Base64.decode((String)sVerifyMethodBase64, (int)0));
                Method method = HttpsURLConnection.class.getDeclaredMethod(string, clazz);
                method.setAccessible(true);
                method.invoke((Object)httpsURLConnection, object);
                return;
            }
            catch (Throwable throwable) {
                LiteavLog.e(TAG, "applySniForHttpsConnection error: " + Log.getStackTraceString(throwable));
            }
        }
    }

    static {
        WHITE_LIST_HOST.add("YVc1MGJDMXpaR3RzYjJjdWRISjBZeTUwWlc1alpXNTBMV05zYjNWa0xtTnZiUT09");
        WHITE_LIST_HOST.add("WVZjMU1HSkRNWHBhUjNSellqSmpkV1JJU2pCWmVUVXdXbGMxYWxwWE5UQk1WMDV6WWpOV2EweHRUblppVVQwOQ==");
        WHITE_LIST_HOST.add("aW5sYW5kLXNka2xvZy50cnRjLnRlbmNlbnQtY2xvdWQuY29t");
        WHITE_LIST_HOST.add("dHJ0Yy1zZGstbG9nLTEyNTgzNDQ2OTkuY29zLmFwLWd1YW5nemhvdS5teXFjbG91ZC5jb20=");
        WHITE_LIST_HOST.add("dHJ0Yy1zZGstY29uZmlnLTEyNTgzNDQ2OTkuZmlsZS5teXFjbG91ZC5jb20=");
        WHITE_LIST_HOST.add("bGl0ZWF2LnNkay5xY2xvdWQuY29t");
        WHITE_LIST_HOST.add("eXVuLnRpbS5xcS5jb20=");
        WHITE_LIST_HOST.add("dmlkZW9hcGktc2dwLmltLnFjbG91ZC5jb20=");
        WHITE_LIST_HOST.add("c2RrZGMubGl2ZS5xY2xvdWQuY29t");
        WHITE_LIST_HOST.add("bWx2YmRjLmxpdmUucWNsb3VkLmNvbQ==");
        WHITE_LIST_HOST.add("Y29uZi5zZGsucWNsb3VkLmNvbQ==");
        WHITE_LIST_HOST.add("c3BlZWR0ZXN0aW50LnRydGMudGVuY2VudC1jbG91ZC5jb20=");
        WHITE_LIST_HOST.add("c3BlZWR0ZXN0LnRydGMudGVuY2VudC1jbG91ZC5jb20=");
        WHITE_LIST_HOST.add("d2VicnRjLXNpZ25hbC1zY2hlZHVsZXIudGxpdmVzb3VyY2UuY29t");
        WHITE_LIST_HOST.add("Y2xvdWQudGltLnFxLmNvbQ==");
        WHITE_LIST_HOST.add("bGl2ZXB1bGwubXlxY2xvdWQuY29t");
        WHITE_LIST_HOST.add("bGl2ZXB1bGxpcHY2Lm15cWNsb3VkLmNvbQ==");
        WHITE_LIST_HOST.add("dGNkbnMubXlxY2xvdWQuY29t");
        WHITE_LIST_HOST.add("dGNkbnNpcHY2Lm15cWNsb3VkLmNvbQ==");
        WHITE_LIST_HOST.add("bGl0ZWF2YXBwLnFjbG91ZC5jb20=");
        WHITE_LIST_HOST.add("bGljZW5zZS10ZXN0LnZvZDIubXlxY2xvdWQuY29t");
        WHITE_LIST_HOST.add("c2RrY29uZmlnLnRsaXZlc291cmNlLmNvbQ==");
        WHITE_LIST_HOST.add("bWx2YmRjLmxpdmUudGxpdmVzb3VyY2UuY29t");
        WHITE_LIST_HOST.add("bGljZW5zZS52b2RnbGNkbi5jb20=");
        WHITE_LIST_HOST.add("bGljZW5zZS52b2QtY29tbW9uLmNvbQ==");
        WHITE_LIST_HOST.add("bGljZW5zZS52b2RnbGNkbjEuY29t");
        WHITE_LIST_HOST.add("bGljZW5zZS52b2QtY29tbW9uMS5jb20=");
        WHITE_LIST_HOST.add("bGljZW5zZS52b2RwbGF5dmlkZW8ubmV0");
        WHITE_LIST_HOST.add("bGljZW5zZS52b2RwbGF5dmlkZW8uY29t");
    }

    static final class b
    extends SSLSocketFactory {
        private HttpsURLConnection a;

        public b(HttpsURLConnection httpsURLConnection) {
            this.a = httpsURLConnection;
        }

        @Override
        public final Socket createSocket() throws IOException {
            return null;
        }

        @Override
        public final Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return null;
        }

        @Override
        public final Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return null;
        }

        @Override
        public final Socket createSocket(InetAddress host, int port) throws IOException {
            return null;
        }

        @Override
        public final Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return null;
        }

        @Override
        public final String[] getDefaultCipherSuites() {
            return new String[0];
        }

        @Override
        public final String[] getSupportedCipherSuites() {
            return new String[0];
        }

        @Override
        public final Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
            String string = this.a.getRequestProperty("Host");
            if (string == null) {
                string = host;
            }
            InetAddress inetAddress = socket.getInetAddress();
            if (autoClose) {
                socket.close();
            }
            SSLCertificateSocketFactory sSLCertificateSocketFactory = (SSLCertificateSocketFactory)SSLCertificateSocketFactory.getDefault((int)0);
            SSLSocket sSLSocket = (SSLSocket)sSLCertificateSocketFactory.createSocket(inetAddress, port);
            sSLSocket.setEnabledProtocols(sSLSocket.getSupportedProtocols());
            if (Build.VERSION.SDK_INT >= 17) {
                LiteavLog.i(HttpDnsUtil.TAG, "Setting SNI hostname");
                sSLCertificateSocketFactory.setHostname((Socket)sSLSocket, string);
            } else {
                LiteavLog.d(HttpDnsUtil.TAG, "No documented SNI support on Android < 4.2, trying with reflection");
                try {
                    sSLSocket.getClass().getMethod("setHostname", String.class).invoke((Object)sSLSocket, string);
                }
                catch (Exception exception) {
                    LiteavLog.w(HttpDnsUtil.TAG, "SNI not useable", exception);
                }
            }
            SSLSession sSLSession = sSLSocket.getSession();
            if (!HttpsURLConnection.getDefaultHostnameVerifier().verify(string, sSLSession)) {
                throw new SSLPeerUnverifiedException("Cannot verify hostname: ".concat(String.valueOf(string)));
            }
            LiteavLog.i(HttpDnsUtil.TAG, "Established " + sSLSession.getProtocol() + " connection with " + sSLSession.getPeerHost() + " using " + sSLSession.getCipherSuite());
            return sSLSocket;
        }
    }

    public static interface a {
        public void a(String var1, List<String> var2);
    }
}

