/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base.system;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Debug;
import android.os.Process;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.b.a;
import com.tencent.liteav.base.system.c;
import com.tencent.liteav.base.system.d;
import com.tencent.liteav.base.system.e;
import com.tencent.liteav.base.system.f;
import com.tencent.liteav.base.system.g;
import com.tencent.liteav.base.system.h;
import com.tencent.liteav.base.system.i;
import com.tencent.liteav.base.system.j;
import com.tencent.liteav.base.system.k;
import com.tencent.liteav.base.system.l;
import com.tencent.liteav.base.system.m;
import com.tencent.liteav.base.system.n;
import com.tencent.liteav.base.system.o;
import com.tencent.liteav.base.system.p;
import com.tencent.liteav.base.util.s;

@JNINamespace(value="liteav")
public class LiteavSystemInfo {
    private static final String TAG = "LiteavBaseSystemInfo";
    private static final int APP_SYSTEM_METHOD_DEFAULT_GET_INTERVAL_MS = 1000;
    private static final String EXT_KEY_BUILD_MODEL = "buildModel";
    private static final String EXT_KEY_BUILD_BRAND = "buildBrand";
    private static final String EXT_KEY_BUILD_MANUFACTURER = "buildManufacturer";
    private static final String EXT_KEY_BUILD_HARDWARE = "buildHardware";
    private static final String EXT_KEY_BUILD_VERSION = "buildVersion";
    private static final String EXT_KEY_BUILD_VERSION_INT = "buildVersionInt";
    private static final String EXT_KEY_BUILD_BOARD = "buildBoard";
    private static final String EXT_KEY_APP_NAME = "appName";
    private static final String EXT_KEY_APP_PACKAGE_NAME = "appPackageName";
    private static final String EXT_KEY_APP_VERSION = "appVersion";
    private static final String EXT_KEY_APP_BACKGROUND = "isAppBackground";
    private static final int NETWORK_TYPE_UNKNOWN = 0;
    private static final int NETWORK_TYPE_WIFI = 1;
    private static final int NETWORK_TYPE_4G = 2;
    private static final int NETWORK_TYPE_3G = 3;
    private static final int NETWORK_TYPE_2G = 4;
    private static final int NETWORK_TYPE_WIRED = 5;
    private static final int NETWORK_TYPE_5G = 6;
    private static final s<String> sModel = new s(h.a());
    private static final s<String> sBrand = new s(i.a());
    private static final s<String> sManufacturer = new s(j.a());
    private static final s<String> sHardware = new s(k.a());
    private static final s<String> sSystemOSVersion = new s(l.a());
    private static final s<Integer> sSystemOSVersionInt = new s(m.a());
    private static final s<String> sBoard = new s(n.a());
    private static final s<String> sAppPackageName = new s(o.a());
    private static final s<String> sAppName = new s(d.a());
    private static final s<String> sAppVersion = new s(e.a());
    private static final s<String> sUUID = new s(f.a());
    private static final s<String[]> sCpuABIs = new s(g.a());
    private static int sLastNetworkType = 0;
    private static final a sNetworkTypeThrottler = new a(1000L);
    private static int sLastGateway = 0;
    private static final a sGatewayThrottler = new a(1000L);
    private static boolean sLastMicPermission = false;
    private static final a sMicPermissionThrottler = new a(1000L);

    public static boolean setExtID(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        String string = key;
        int n2 = -1;
        switch (string.hashCode()) {
            case -487188133: {
                if (!string.equals(EXT_KEY_BUILD_MODEL)) break;
                n2 = 0;
                break;
            }
            case -497260103: {
                if (!string.equals(EXT_KEY_BUILD_BRAND)) break;
                n2 = 1;
                break;
            }
            case -589756065: {
                if (!string.equals(EXT_KEY_BUILD_MANUFACTURER)) break;
                n2 = 2;
                break;
            }
            case -391134602: {
                if (!string.equals(EXT_KEY_BUILD_HARDWARE)) break;
                n2 = 3;
                break;
            }
            case -911706486: {
                if (!string.equals(EXT_KEY_BUILD_VERSION)) break;
                n2 = 4;
                break;
            }
            case 725329157: {
                if (!string.equals(EXT_KEY_BUILD_VERSION_INT)) break;
                n2 = 5;
                break;
            }
            case -497349352: {
                if (!string.equals(EXT_KEY_BUILD_BOARD)) break;
                n2 = 6;
                break;
            }
            case -794136500: {
                if (!string.equals(EXT_KEY_APP_NAME)) break;
                n2 = 7;
                break;
            }
            case -441921776: {
                if (!string.equals(EXT_KEY_APP_PACKAGE_NAME)) break;
                n2 = 8;
                break;
            }
            case 1484112759: {
                if (!string.equals(EXT_KEY_APP_VERSION)) break;
                n2 = 9;
                break;
            }
            case -1978299099: {
                if (!string.equals(EXT_KEY_APP_BACKGROUND)) break;
                n2 = 10;
            }
        }
        switch (n2) {
            case 0: {
                sModel.a(value);
                break;
            }
            case 1: {
                sBrand.a(value);
                break;
            }
            case 2: {
                sManufacturer.a(value);
                break;
            }
            case 3: {
                sHardware.a(value);
                break;
            }
            case 4: {
                sSystemOSVersion.a(value);
                break;
            }
            case 5: {
                try {
                    int n3 = Integer.parseInt(value);
                    sSystemOSVersionInt.a(n3);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                break;
            }
            case 6: {
                sBoard.a(value);
                break;
            }
            case 7: {
                sAppName.a(value);
                break;
            }
            case 8: {
                sAppPackageName.a(value);
                break;
            }
            case 9: {
                sAppVersion.a(value);
                break;
            }
            case 10: {
                try {
                    com.tencent.liteav.base.util.j.a(Integer.parseInt(value) == 1);
                    break;
                }
                catch (Exception exception) {
                    Log.e(TAG, "set app background state failed. ".concat(String.valueOf(exception)), new Object[0]);
                    return false;
                }
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static String getDeviceUuid() {
        return sUUID.a();
    }

    public static String getHardware() {
        return sHardware.a();
    }

    public static String getManufacturer() {
        return sManufacturer.a();
    }

    public static String getBoard() {
        return sBoard.a();
    }

    public static String getModel() {
        return sModel.a();
    }

    public static String getBrand() {
        return sBrand.a();
    }

    public static String getSystemOSVersion() {
        return sSystemOSVersion.a();
    }

    public static int getSystemOSVersionInt() {
        return sSystemOSVersionInt.a();
    }

    public static String getAppName() {
        return sAppName.a();
    }

    public static String getAppPackageName() {
        return sAppPackageName.a();
    }

    public static String getAppVersion() {
        return sAppVersion.a();
    }

    public static synchronized int getAppMemoryUsage() {
        int n2 = 0;
        try {
            Debug.MemoryInfo memoryInfo = new Debug.MemoryInfo();
            Debug.getMemoryInfo((Debug.MemoryInfo)memoryInfo);
            n2 = memoryInfo.getTotalPss();
        }
        catch (Exception exception) {
            Log.e(TAG, "Get App memory usage failed." + exception.getMessage(), new Object[0]);
        }
        return n2 / 1024;
    }

    public static synchronized void listenAppBackgroundState() {
        com.tencent.liteav.base.util.j.a().a(c.a());
    }

    public static synchronized int getAppThreadSize() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup.activeCount();
    }

    public static synchronized int getAppBackgroundState() {
        if (com.tencent.liteav.base.util.j.a().b()) {
            return 1;
        }
        return 0;
    }

    public static synchronized int getNetworkType() {
        if (sNetworkTypeThrottler.a()) {
            sLastNetworkType = LiteavSystemInfo.getNetworkTypeFromSystem();
        }
        return sLastNetworkType;
    }

    private static int getNetworkTypeFromSystem() {
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            return 0;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return 0;
        }
        NetworkInfo networkInfo = null;
        try {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        catch (Exception exception) {}
        if (networkInfo == null) {
            return 0;
        }
        if (!networkInfo.isConnected()) {
            return 0;
        }
        if (networkInfo.getType() == 9) {
            return 5;
        }
        if (networkInfo.getType() == 1) {
            return 1;
        }
        if (networkInfo.getType() == 0) {
            int n2;
            try {
                TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
                if (telephonyManager == null) {
                    return 0;
                }
                n2 = telephonyManager.getNetworkType();
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: {
                        return 4;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: {
                        return 3;
                    }
                    case 13: {
                        return 2;
                    }
                }
            }
            catch (Exception exception) {
                return 2;
            }
            if (LiteavSystemInfo.getSystemOSVersionInt() >= 29 && n2 == 20) {
                return 6;
            }
            return 2;
        }
        return 0;
    }

    public static synchronized int getGateway() {
        if (sGatewayThrottler.a()) {
            sLastGateway = LiteavSystemInfo.getGatewayFromSystem();
        }
        return sLastGateway;
    }

    private static int getGatewayFromSystem() {
        int n2;
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            return 0;
        }
        try {
            n2 = ((WifiManager)context.getSystemService((String)"wifi")).getDhcpInfo().gateway;
        }
        catch (Throwable throwable) {
            Log.e(TAG, "getGateway error " + throwable.getMessage(), new Object[0]);
            n2 = 0;
        }
        return n2;
    }

    public static synchronized boolean getAudioRecordPermission() {
        if (sMicPermissionThrottler.a()) {
            sLastMicPermission = LiteavSystemInfo.getAudioRecordPermissionFromSystem();
        }
        return sLastMicPermission;
    }

    private static boolean getAudioRecordPermissionFromSystem() {
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            return false;
        }
        return 0 == context.checkPermission("android.permission.RECORD_AUDIO", Process.myPid(), Process.myUid());
    }

    public static int[] getScreenSizeInPixels() {
        int[] nArray = new int[]{0, 0};
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            Log.e(TAG, "Context is null.", new Object[0]);
            return nArray;
        }
        try {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            if (windowManager == null) {
                Log.e(TAG, "WindowManager is null.", new Object[0]);
                return nArray;
            }
            DisplayMetrics displayMetrics = new DisplayMetrics();
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
            nArray[0] = Math.max(displayMetrics.widthPixels, displayMetrics.heightPixels);
            nArray[1] = Math.min(displayMetrics.widthPixels, displayMetrics.heightPixels);
            return nArray;
        }
        catch (Throwable throwable) {
            Log.e(TAG, "Get display from window service failed. ".concat(String.valueOf(throwable)), new Object[0]);
            return nArray;
        }
    }

    public static String[] getSupportABIs() {
        return sCpuABIs.a();
    }

    public static synchronized String getSystemProperty(String propName) {
        String string = null;
        try {
            Object object = Class.forName("android.os.SystemProperties").getMethod("get", String.class).invoke(null, propName);
            if (object != null) {
                string = (String)object;
                Log.i(TAG, "Get " + propName + " property is " + string, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            Log.e(TAG, "Get system property failed. ".concat(String.valueOf(throwable)), new Object[0]);
        }
        return string;
    }

    public static synchronized String getProperty(String propName) {
        String string = null;
        try {
            string = System.getProperty(propName);
            Log.i(TAG, "Get " + propName + " property is " + string, new Object[0]);
        }
        catch (Throwable throwable) {
            Log.e(TAG, "Get property failed. ".concat(String.valueOf(throwable)), new Object[0]);
        }
        return string;
    }

    public static void onAppBackgroundStateChanged(boolean isBackground) {
        LiteavSystemInfo.nativeOnAppBackgroundStateChanged(isBackground ? 1 : 0);
    }

    private static native void nativeOnAppBackgroundStateChanged(int var0);

    static /* synthetic */ void lambda$listenAppBackgroundState$9(boolean isBackground) {
        LiteavSystemInfo.onAppBackgroundStateChanged(isBackground);
    }

    static /* synthetic */ String[] lambda$static$8() throws Exception {
        if (Build.VERSION.SDK_INT >= 21) {
            return Build.SUPPORTED_ABIS;
        }
        return new String[]{Build.CPU_ABI, Build.CPU_ABI2};
    }

    static /* synthetic */ String lambda$static$7() throws Exception {
        return p.a(sAppPackageName.a());
    }

    static /* synthetic */ String lambda$static$6() throws Exception {
        return Build.BOARD;
    }

    static /* synthetic */ Integer lambda$static$5() throws Exception {
        return Build.VERSION.SDK_INT;
    }

    static /* synthetic */ String lambda$static$4() throws Exception {
        return Build.VERSION.RELEASE;
    }

    static /* synthetic */ String lambda$static$3() throws Exception {
        return Build.HARDWARE;
    }

    static /* synthetic */ String lambda$static$2() throws Exception {
        return Build.MANUFACTURER;
    }

    static /* synthetic */ String lambda$static$1() throws Exception {
        return Build.BRAND;
    }

    static /* synthetic */ String lambda$static$0() throws Exception {
        return Build.MODEL;
    }
}

