/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio2.permission;

import android.os.Process;
import com.tencent.liteav.audio2.permission.PermissionActivity;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import java.util.ArrayList;
import java.util.List;

@JNINamespace(value="liteav::audio")
public class PermissionRequesterAndroid
extends PermissionActivity.a {
    private static final String TAG = "PermissionRequesterAndroid";
    private static final List<String> mRequestedPermissions = new ArrayList<String>();
    private final long mNativePermissionRequesterAndroid;

    public PermissionRequesterAndroid(long nativePermissionRequesterAndroid) {
        this.mNativePermissionRequesterAndroid = nativePermissionRequesterAndroid;
    }

    public void requestPermission(String permission2) {
        if (permission2 == null || permission2.isEmpty()) {
            Log.w(TAG, "request permission is null.", new Object[0]);
            return;
        }
        if (LiteavSystemInfo.getSystemOSVersionInt() < 23) {
            this.handleRequestPermissionsResult(new String[]{permission2});
            return;
        }
        if (mRequestedPermissions.contains(permission2)) {
            this.handleRequestPermissionsResult(mRequestedPermissions.toArray(new String[0]));
            return;
        }
        PermissionActivity.a(ContextUtils.getApplicationContext(), new String[]{permission2}, this);
    }

    @Override
    public void onRequestPermissionsResult(String[] permissions, int[] grantResults) {
        this.handleRequestPermissionsResult(permissions);
        String[] stringArray = permissions;
        int n2 = permissions.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            if (mRequestedPermissions.contains(string)) continue;
            mRequestedPermissions.add(string);
        }
    }

    private boolean hasPermission(String permission2) {
        if (permission2 == null || permission2.isEmpty()) {
            Log.w(TAG, "check permission is null.", new Object[0]);
            return true;
        }
        boolean bl2 = true;
        try {
            bl2 = LiteavSystemInfo.getSystemOSVersionInt() < 23 || 0 == ContextUtils.getApplicationContext().checkPermission(permission2, Process.myPid(), Process.myUid());
        }
        catch (Throwable throwable) {
            Log.e(TAG, "check permission exception, " + throwable.getMessage(), new Object[0]);
        }
        return bl2;
    }

    private void handleRequestPermissionsResult(String[] permissions) {
        String[] stringArray = permissions;
        int n2 = permissions.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            PermissionRequesterAndroid.nativeNotifyPermissionsResultFromJava(this.mNativePermissionRequesterAndroid, this.hasPermission(string));
        }
    }

    private static native void nativeNotifyPermissionsResultFromJava(long var0, boolean var2);
}

