/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor.videoeffect.filter;

import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Iterator;

public class TXCSavePreFrameFilter {
    private int mSavePreFrameNumber = 1;
    private TXCGPUImageFilter mDrawFilter = null;
    private int mVideoWidth = -1;
    private int mVideoHeight = -1;
    private GLTexturePool mGLTexturePool;
    private ArrayList<GLTexture> mRecyclerTextureBuffers = new ArrayList();
    private ArrayList<GLTexture> mPreTextureBuffers = new ArrayList();

    public void initFilter(GLTexturePool texturePool) {
        this.mGLTexturePool = texturePool;
        if (this.mDrawFilter == null) {
            this.mDrawFilter = new TXCGPUImageFilter();
            this.mDrawFilter.initialize(texturePool);
        }
    }

    public void onOutputSizeChanged(int width, int height) {
        this.mVideoWidth = width;
        this.mVideoHeight = height;
        if (this.mDrawFilter != null) {
            this.mDrawFilter.onOutputSizeChanged(width, height);
        }
    }

    public boolean onDrawToTexture(int textureId, GLTexture outTexture, FloatBuffer cubeCoordsBuffer, FloatBuffer textureCoordsBuffer) {
        GLTexture gLTexture;
        boolean bl2 = false;
        if (this.mPreTextureBuffers.size() >= this.mSavePreFrameNumber && this.mPreTextureBuffers.size() > 0) {
            gLTexture = this.mPreTextureBuffers.get(0);
            if (this.mDrawFilter != null) {
                this.mDrawFilter.onDraw(gLTexture.getId(), outTexture, cubeCoordsBuffer, textureCoordsBuffer);
            }
            this.mRecyclerTextureBuffers.add(gLTexture);
            this.mPreTextureBuffers.remove(0);
            bl2 = true;
        }
        if ((gLTexture = this.mRecyclerTextureBuffers.size() > 0 ? this.mRecyclerTextureBuffers.remove(0) : this.mGLTexturePool.obtain(this.mVideoWidth, this.mVideoHeight)) != null) {
            this.mDrawFilter.onDraw(textureId, gLTexture, cubeCoordsBuffer, textureCoordsBuffer);
            this.mPreTextureBuffers.add(gLTexture);
        }
        return bl2;
    }

    public void setSavePreFrameNumber(int number) {
        if (number <= 0) {
            return;
        }
        this.mSavePreFrameNumber = number;
    }

    public void destroy() {
        Iterator<GLTexture> iterator;
        if (this.mDrawFilter != null) {
            this.mDrawFilter.uninitialize();
            this.mDrawFilter = null;
        }
        if (this.mRecyclerTextureBuffers != null) {
            iterator = this.mRecyclerTextureBuffers.iterator();
            while (iterator.hasNext()) {
                iterator.next().release();
            }
            this.mRecyclerTextureBuffers.clear();
            this.mRecyclerTextureBuffers = null;
        }
        if (this.mPreTextureBuffers != null) {
            iterator = this.mPreTextureBuffers.iterator();
            while (iterator.hasNext()) {
                iterator.next().release();
            }
            this.mPreTextureBuffers.clear();
            this.mPreTextureBuffers = null;
        }
    }
}

