/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor.videoeffect.filter;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.frame.RefCounted;
import com.tencent.ugc.videoprocessor.videoeffect.TXCGPUEffectFilterBase;
import com.tencent.ugc.videoprocessor.videoeffect.filter.TXCGPULookUpFilter;
import com.tencent.ugc.videoprocessor.videoeffect.filter.TXCGPULookUpInvertFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.FloatBuffer;

public class TXCGPULightingFilter
extends TXCGPUEffectFilterBase {
    private static final String TAG = "TXCGPULightingFilter";
    private static final int DURATION_LIGHTNING_LV1 = 50;
    private static final int DURATION_LIGHTNING_LV2 = 150;
    private static final int DURATION_LIGHTNING_LV3 = 250;
    private static final int DURATION_LIGHTNING_LV4 = 300;
    private static final int DURATION_LIGHTNING_LV5 = 400;
    private static final int DURATION_LIGHTNING_LV6 = 580;
    private TXCGPULookUpInvertFilter mLookUpInvertFilter = null;
    private TXCGPULookUpFilter mLookUpFilter = null;
    private final Context mContext;
    private LightningParam mLightningParam = null;
    private GLTexturePool mGLTexturePool;

    public TXCGPULightingFilter(Context context) {
        this.mContext = context.getApplicationContext();
    }

    @Override
    public void onInit(GLTexturePool texturePool) {
        Bitmap bitmap;
        super.onInit(texturePool);
        this.mGLTexturePool = texturePool;
        AssetManager assetManager = this.mContext.getResources().getAssets();
        try {
            bitmap = BitmapFactory.decodeStream((InputStream)assetManager.open("fennen.png"));
        }
        catch (IOException iOException) {
            LiteavLog.e(TAG, "decode stream failed.", iOException);
            return;
        }
        if (this.mLookUpInvertFilter == null) {
            this.mLookUpInvertFilter = new TXCGPULookUpInvertFilter(bitmap);
            this.mLookUpInvertFilter.initialize(texturePool);
        }
        try {
            bitmap = BitmapFactory.decodeStream((InputStream)assetManager.open("qingliang.png"));
        }
        catch (IOException iOException) {
            LiteavLog.e(TAG, "decode stream failed.", iOException);
        }
        if (this.mLookUpFilter == null) {
            this.mLookUpFilter = new TXCGPULookUpFilter(bitmap);
            this.mLookUpFilter.initialize(texturePool);
        }
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        if (this.mLookUpInvertFilter != null) {
            this.mLookUpInvertFilter.onOutputSizeChanged(width, height);
        }
        if (this.mLookUpFilter != null) {
            this.mLookUpFilter.onOutputSizeChanged(width, height);
        }
    }

    @Override
    public void onUninit() {
        super.onUninit();
        if (this.mLookUpInvertFilter != null) {
            this.mLookUpInvertFilter.uninitialize();
            this.mLookUpInvertFilter = null;
        }
        if (this.mLookUpFilter != null) {
            this.mLookUpFilter.uninitialize();
            this.mLookUpFilter = null;
        }
    }

    @Override
    public void setNextFrameTimestamp(long pts) {
        long l2;
        super.setNextFrameTimestamp(pts);
        if (this.mLightningParam == null) {
            this.mLightningParam = new LightningParam();
            this.mLightningParam.lightningLevel = 0.0f;
        }
        if ((l2 = Math.abs(pts - this.mEffectStartTime)) < 50L) {
            this.mLightningParam.lightningLevel = 0.7f;
        } else if (l2 < 150L) {
            this.mLightningParam.lightningLevel = 0.5f;
        } else if (l2 < 250L) {
            this.mLightningParam.lightningLevel = 0.4f;
        } else if (l2 < 300L) {
            this.mLightningParam.lightningLevel = 1.0f;
        } else if (l2 < 400L) {
            this.mLightningParam.lightningLevel = 0.3f;
        } else if (l2 < 580L) {
            this.mLightningParam.lightningLevel = 0.0f;
        } else {
            this.mEffectStartTime = -1L;
        }
        this.updateParams();
    }

    private void updateParams() {
        if (this.mLightningParam != null) {
            if (this.mLookUpInvertFilter != null) {
                this.mLookUpInvertFilter.setIntensity(this.mLightningParam.lightningLevel / 5.0f);
                this.mLookUpInvertFilter.setInvertLevel(this.mLightningParam.lightningLevel * 1.5f);
            }
            if (this.mLookUpFilter != null) {
                this.mLookUpFilter.setIntensity(this.mLightningParam.lightningLevel / 5.0f);
            }
        }
    }

    @Override
    public void onDraw(int inTextureId, GLTexture outTexture, FloatBuffer cubeCoordsBuffer, FloatBuffer textureCoordsBuffer) {
        if (!this.isInitialized()) {
            return;
        }
        this.runPendingOnDrawTasks();
        if (this.mLightningParam == null || this.mLightningParam.lightningLevel <= 0.0f) {
            return;
        }
        int n2 = inTextureId;
        RefCounted refCounted = null;
        if (this.mLookUpInvertFilter != null) {
            refCounted = this.mGLTexturePool.obtain(this.mOutputSize.width, this.mOutputSize.height);
            this.mLookUpInvertFilter.onDraw(inTextureId, (GLTexture)refCounted, cubeCoordsBuffer, textureCoordsBuffer);
            n2 = ((GLTexture)refCounted).getId();
        }
        if (this.mLookUpFilter != null) {
            this.mLookUpFilter.onDraw(n2, outTexture, cubeCoordsBuffer, textureCoordsBuffer);
        }
        if (refCounted != null) {
            refCounted.release();
        }
    }

    public static class LightningParam
    extends TXCGPUEffectFilterBase.VideoEffectParams {
        public float lightningLevel = 0.0f;
    }
}

