/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor;

import android.content.Context;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.h;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.utils.CollectionUtils;
import com.tencent.ugc.videoprocessor.transitions.BounceFilter;
import com.tencent.ugc.videoprocessor.transitions.BurnFilter;
import com.tencent.ugc.videoprocessor.transitions.CircleCropFilter;
import com.tencent.ugc.videoprocessor.transitions.CircleFilter;
import com.tencent.ugc.videoprocessor.transitions.CrossWarpFilter;
import com.tencent.ugc.videoprocessor.transitions.CrossZoomFilter;
import com.tencent.ugc.videoprocessor.transitions.CubeFilter;
import com.tencent.ugc.videoprocessor.transitions.DirectionalFilter;
import com.tencent.ugc.videoprocessor.transitions.DirectionalWarpFilter;
import com.tencent.ugc.videoprocessor.transitions.DoorWayFilter;
import com.tencent.ugc.videoprocessor.transitions.DreamyZoomFilter;
import com.tencent.ugc.videoprocessor.transitions.FadeColorFilter;
import com.tencent.ugc.videoprocessor.transitions.FadeGrayScaleFilter;
import com.tencent.ugc.videoprocessor.transitions.FlyEyeFilter;
import com.tencent.ugc.videoprocessor.transitions.GlitchDisplaceFilter;
import com.tencent.ugc.videoprocessor.transitions.GlitchMemoriesFilter;
import com.tencent.ugc.videoprocessor.transitions.GridFlipFilter;
import com.tencent.ugc.videoprocessor.transitions.HexagonalizeFilter;
import com.tencent.ugc.videoprocessor.transitions.InvertedPageCurlFilter;
import com.tencent.ugc.videoprocessor.transitions.KaleidoScopeFilter;
import com.tencent.ugc.videoprocessor.transitions.LinearBlurFilter;
import com.tencent.ugc.videoprocessor.transitions.MosaicFilter;
import com.tencent.ugc.videoprocessor.transitions.PixelizeFilter;
import com.tencent.ugc.videoprocessor.transitions.SimpleZoomFilter;
import com.tencent.ugc.videoprocessor.transitions.SqueezeFilter;
import com.tencent.ugc.videoprocessor.transitions.StereoViewerFilter;
import com.tencent.ugc.videoprocessor.transitions.SwapFilter;
import com.tencent.ugc.videoprocessor.transitions.SwirlFilter;
import com.tencent.ugc.videoprocessor.transitions.TXCGPUTransitionFilterBase;
import com.tencent.ugc.videoprocessor.transitions.WaterDropFilter;
import com.tencent.ugc.videoprocessor.transitions.data.TransitionConfig;
import java.nio.FloatBuffer;
import java.util.List;

public class VideoTransitionProcessor {
    private static final String TAG = "TransitionProcessor";
    private TXCGPUTransitionFilterBase mTransitionFilter;
    private final Context mContext;
    private long mFirstFrameTime = -1L;
    private final TransitionConfig mTransitionConfig;
    private GLTexturePool mGLTexturePool;
    private boolean mIsReverse = false;
    private long mVideoDuration = -1L;

    public VideoTransitionProcessor(Context context) {
        this.mContext = context;
        this.mTransitionConfig = new TransitionConfig();
    }

    public void initialize(GLTexturePool texturePool) {
        this.mGLTexturePool = texturePool;
    }

    public PixelFrame applyTransitionFilter(PixelFrame inFrame, FloatBuffer cubeCoordsBuffer, FloatBuffer textureCoordsBuffer) {
        float f2;
        TransitionConfig.TransitionBean transitionBean;
        long l2 = inFrame.getTimestamp();
        if (this.mIsReverse) {
            l2 = h.a(this.mVideoDuration - l2, 0L, this.mVideoDuration);
        }
        if ((transitionBean = this.getCurrentTransition(l2)) == null) {
            this.mFirstFrameTime = -1L;
            return null;
        }
        float f3 = this.getTransitionProgress(transitionBean, l2);
        if (f2 < 0.0f) {
            return null;
        }
        if (this.mTransitionFilter != null && this.mTransitionFilter.mType != transitionBean.type) {
            this.mTransitionFilter.uninitialize();
            this.mTransitionFilter = null;
        }
        if (this.mTransitionFilter == null) {
            this.createTransitionFilter(transitionBean.type);
        }
        if (this.mTransitionFilter == null) {
            return null;
        }
        this.mTransitionFilter.onOutputSizeChanged(inFrame.getWidth(), inFrame.getHeight());
        this.mTransitionFilter.setProgressForTransition(f3);
        GLTexture gLTexture = this.mGLTexturePool.obtain(inFrame.getWidth(), inFrame.getHeight());
        gLTexture.setColorFormat(inFrame.getColorRange(), inFrame.getColorSpace());
        this.mTransitionFilter.onDraw(inFrame.getTextureId(), gLTexture, cubeCoordsBuffer, textureCoordsBuffer);
        PixelFrame pixelFrame = gLTexture.wrap(inFrame.getGLContext());
        pixelFrame.setTimestamp(inFrame.getTimestamp());
        gLTexture.release();
        return pixelFrame;
    }

    public void setReverse(boolean isReverse, long videoDuration) {
        this.mIsReverse = isReverse;
        this.mVideoDuration = videoDuration;
    }

    public boolean setTransitionEffect(int type, long totalDuration, long startTimeMs, long transitionDurationMs) {
        if (startTimeMs > totalDuration || startTimeMs + transitionDurationMs > totalDuration) {
            LiteavLog.w(TAG, "setTransitionEffect,not suitable for videoTotalDurationMs");
            return false;
        }
        List<TransitionConfig.TransitionBean> list = this.mTransitionConfig.getTransitionList();
        if (list.size() != 0) {
            boolean bl2 = true;
            for (TransitionConfig.TransitionBean transitionBean : list) {
                if (startTimeMs >= transitionBean.startTimeMs && startTimeMs <= transitionBean.endTimeMs) {
                    bl2 = false;
                    LiteavLog.w(TAG, "setTransitionEffect,start time invalid");
                    break;
                }
                long l2 = startTimeMs + transitionDurationMs;
                if (!this.isInTransitionRange(l2, transitionBean)) continue;
                bl2 = false;
                LiteavLog.w(TAG, "setTransitionEffect,end time invalid");
                break;
            }
            if (!bl2) {
                return false;
            }
        }
        TransitionConfig.TransitionBean transitionBean = new TransitionConfig.TransitionBean(type);
        new TransitionConfig.TransitionBean(type).startTimeMs = startTimeMs;
        transitionBean.endTimeMs = startTimeMs + transitionDurationMs;
        this.mTransitionConfig.addTransition(transitionBean);
        LiteavLog.d(TAG, "setTransitionEffect,success:".concat(String.valueOf(transitionBean)));
        return true;
    }

    public void deleteLastTransitionEffect() {
        this.mTransitionConfig.deleteLastTransitionEffect();
    }

    private float getTransitionProgress(TransitionConfig.TransitionBean transition, long pts) {
        if (this.mFirstFrameTime == -1L) {
            this.mFirstFrameTime = pts;
        }
        long l2 = Math.abs(pts - this.mFirstFrameTime);
        long l3 = Math.abs(transition.endTimeMs - transition.startTimeMs);
        if (l3 <= 0L) {
            return -1.0f;
        }
        return h.a((float)l2 * 1.0f / (float)l3, 0.0f);
    }

    private TransitionConfig.TransitionBean getCurrentTransition(long timestampMs) {
        List<TransitionConfig.TransitionBean> list = this.mTransitionConfig.getTransitionList();
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            TransitionConfig.TransitionBean transitionBean = list.get(i2);
            if (!this.isInTransitionRange(timestampMs, transitionBean)) continue;
            return transitionBean;
        }
        return null;
    }

    private boolean isInTransitionRange(long timestampMs, TransitionConfig.TransitionBean bean) {
        if (timestampMs >= bean.startTimeMs && timestampMs <= bean.endTimeMs) {
            return true;
        }
        return timestampMs >= bean.endTimeMs && timestampMs <= bean.startTimeMs;
    }

    private void createTransitionFilter(int type) {
        TXCGPUTransitionFilterBase tXCGPUTransitionFilterBase;
        switch (type) {
            case 2: {
                tXCGPUTransitionFilterBase = new DirectionalFilter(type, new float[]{-1.0f, 0.0f});
                break;
            }
            case 1: {
                tXCGPUTransitionFilterBase = new DirectionalFilter(type, new float[]{1.0f, 0.0f});
                break;
            }
            case 4: {
                tXCGPUTransitionFilterBase = new DirectionalFilter(type, new float[]{0.0f, 1.0f});
                break;
            }
            case 3: {
                tXCGPUTransitionFilterBase = new DirectionalFilter(type, new float[]{0.0f, -1.0f});
                break;
            }
            case 5: {
                tXCGPUTransitionFilterBase = new FadeColorFilter(type);
                break;
            }
            case 7: {
                tXCGPUTransitionFilterBase = new SimpleZoomFilter(type);
                break;
            }
            case 8: {
                tXCGPUTransitionFilterBase = new LinearBlurFilter(type);
                break;
            }
            case 9: {
                tXCGPUTransitionFilterBase = new WaterDropFilter(type);
                break;
            }
            case 10: {
                tXCGPUTransitionFilterBase = new InvertedPageCurlFilter(type);
                break;
            }
            case 11: {
                tXCGPUTransitionFilterBase = new GlitchMemoriesFilter(type);
                break;
            }
            case 12: {
                tXCGPUTransitionFilterBase = new StereoViewerFilter(type);
                break;
            }
            case 13: {
                tXCGPUTransitionFilterBase = new DirectionalWarpFilter(type);
                break;
            }
            case 14: {
                tXCGPUTransitionFilterBase = new BounceFilter(type);
                break;
            }
            case 15: {
                tXCGPUTransitionFilterBase = new CircleCropFilter(type);
                break;
            }
            case 16: {
                tXCGPUTransitionFilterBase = new SwirlFilter(type);
                break;
            }
            case 17: {
                tXCGPUTransitionFilterBase = new CrossZoomFilter(type);
                break;
            }
            case 18: {
                tXCGPUTransitionFilterBase = new GridFlipFilter(type);
                break;
            }
            case 19: {
                tXCGPUTransitionFilterBase = new MosaicFilter(type);
                break;
            }
            case 22: {
                tXCGPUTransitionFilterBase = new KaleidoScopeFilter(type);
                break;
            }
            case 23: {
                tXCGPUTransitionFilterBase = new HexagonalizeFilter(type);
                break;
            }
            case 24: {
                tXCGPUTransitionFilterBase = new GlitchDisplaceFilter(type);
                break;
            }
            case 25: {
                tXCGPUTransitionFilterBase = new DreamyZoomFilter(type);
                break;
            }
            case 27: {
                tXCGPUTransitionFilterBase = new BurnFilter(type);
                break;
            }
            case 28: {
                tXCGPUTransitionFilterBase = new CircleFilter(type);
                break;
            }
            case 29: {
                tXCGPUTransitionFilterBase = new CrossWarpFilter(type);
                break;
            }
            case 30: {
                tXCGPUTransitionFilterBase = new CubeFilter(type);
                break;
            }
            case 31: {
                tXCGPUTransitionFilterBase = new DoorWayFilter(type);
                break;
            }
            case 32: {
                tXCGPUTransitionFilterBase = new FadeGrayScaleFilter(type);
                break;
            }
            case 33: {
                tXCGPUTransitionFilterBase = new FlyEyeFilter(type);
                break;
            }
            case 34: {
                tXCGPUTransitionFilterBase = new PixelizeFilter(type);
                break;
            }
            case 35: {
                tXCGPUTransitionFilterBase = new SqueezeFilter(type);
                break;
            }
            case 36: {
                tXCGPUTransitionFilterBase = new SwapFilter(type);
                break;
            }
            default: {
                tXCGPUTransitionFilterBase = null;
            }
        }
        if (tXCGPUTransitionFilterBase != null) {
            tXCGPUTransitionFilterBase.initialize(this.mGLTexturePool);
        }
        this.mTransitionFilter = tXCGPUTransitionFilterBase;
    }

    public void destroy() {
        if (this.mTransitionFilter != null) {
            this.mTransitionFilter.uninitialize();
            this.mTransitionFilter = null;
        }
    }
}

