/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor;

import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.videobase.utils.CollectionUtils;
import java.util.Iterator;
import java.util.List;

public class SpeedProcessor {
    private List<TXVideoEditConstants.TXSpeed> mSpeedList;

    public void setSpeedList(List<TXVideoEditConstants.TXSpeed> speedList) {
        this.mSpeedList = speedList;
    }

    public List<TXVideoEditConstants.TXSpeed> getSpeedList() {
        return this.mSpeedList;
    }

    public boolean isSpeedListExist() {
        if (CollectionUtils.isEmpty(this.mSpeedList)) {
            return false;
        }
        Iterator<TXVideoEditConstants.TXSpeed> iterator = this.mSpeedList.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().speedLevel == 2) continue;
            return true;
        }
        return false;
    }

    public float getSpeedLevel(long timestamp) {
        float f2 = 1.0f;
        if (this.mSpeedList == null || this.mSpeedList.size() == 0) {
            return 1.0f;
        }
        for (TXVideoEditConstants.TXSpeed tXSpeed : this.mSpeedList) {
            if (timestamp <= tXSpeed.startTime * 1000L || timestamp >= tXSpeed.endTime * 1000L) continue;
            f2 = this.findSpeedByLevel(tXSpeed.speedLevel);
            break;
        }
        return f2;
    }

    public float findSpeedByLevel(int enumLevel) {
        switch (enumLevel) {
            case 0: {
                return 0.25f;
            }
            case 1: {
                return 0.5f;
            }
            case 2: {
                return 1.0f;
            }
            case 3: {
                return 1.5f;
            }
            case 4: {
                return 2.0f;
            }
        }
        return 1.0f;
    }

    public void clear() {
        if (this.mSpeedList != null) {
            this.mSpeedList.clear();
        }
        this.mSpeedList = null;
    }
}

