/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.yuv;

public class TXCYUVRGBConvertMatrix {
    static final float FULL_RANGE_Y_MULTI = 1.0f;
    static final float FULL_RANGE_Y_OFFSET = 0.0f;
    static final float VIDEO_RANGE_Y_MULTI = 0.85882354f;
    static final float VIDEO_RANGE_Y_OFFSET = 0.0627451f;
    static final float FULL_RANGE_UV_MULTI = 0.5f;
    static final float FULL_RANGE_UV_OFFSET = 0.5019608f;
    static final float VIDEO_RANGE_UV_MULTI = 0.4392157f;
    static final float VIDEO_RANGE_UV_OFFSET = 0.5019608f;
    static final float BT601_KR = 0.299f;
    static final float BT601_KB = 0.114f;
    static final float BT709_KR = 0.2126f;
    static final float BT709_KB = 0.0722f;
    static final float[] TX_YUV_2_RGB_FULL_RANGE_OFFSET = new float[]{0.0f, -0.5019608f, -0.5019608f};
    static final float[] TX_YUV_2_RGB_VIDEO_RANGE_OFFSET = new float[]{-0.0627451f, -0.5019608f, -0.5019608f};
    static final float[] TX_RGB_2_YUV_FULL_RANGE_OFFSET = new float[]{0.0f, 0.5019608f, 0.5019608f};
    static final float[] TX_RGB_2_YUV_VIDEO_RANGE_OFFSET = new float[]{0.0627451f, 0.5019608f, 0.5019608f};
    static final float[] TX_YUV_2_RGB_601_FULL_RANGE_MATRIX = TXCYUVRGBConvertMatrix.makeYUV2RGBMatrix(0.299f, 0.114f, 1.0f, 2.0f);
    static final float[] TX_YUV_2_RGB_601_VIDEO_RANGE_MATRIX = TXCYUVRGBConvertMatrix.makeYUV2RGBMatrix(0.299f, 0.114f, 1.1643835f, 2.2767856f);
    static final float[] TX_YUV_2_RGB_709_FULL_RANGE_MATRIX = TXCYUVRGBConvertMatrix.makeYUV2RGBMatrix(0.2126f, 0.0722f, 1.0f, 2.0f);
    static final float[] TX_YUV_2_RGB_709_VIDEO_RANGE_MATRIX = TXCYUVRGBConvertMatrix.makeYUV2RGBMatrix(0.2126f, 0.0722f, 1.1643835f, 2.2767856f);
    static final float[] TX_RGB_2_YUV_601_FULL_RANGE_MATRIX = TXCYUVRGBConvertMatrix.makeRGB2YUVMatrix(0.299f, 0.114f, 1.0f, 0.5f);
    static final float[] TX_RGB_2_YUV_601_VIDEO_RANGE_MATRIX = TXCYUVRGBConvertMatrix.makeRGB2YUVMatrix(0.299f, 0.114f, 0.85882354f, 0.4392157f);
    static final float[] TX_RGB_2_YUV_709_FULL_RANGE_MATRIX = TXCYUVRGBConvertMatrix.makeRGB2YUVMatrix(0.2126f, 0.0722f, 1.0f, 0.5f);
    static final float[] TX_RGB_2_YUV_709_VIDEO_RANGE_MATRIX = TXCYUVRGBConvertMatrix.makeRGB2YUVMatrix(0.2126f, 0.0722f, 0.85882354f, 0.4392157f);
    static final float[] T_TX_RGB_2_YUV_601_VIDEO_RANGE_MATRIX = TXCYUVRGBConvertMatrix.matrixTranspose(TX_RGB_2_YUV_601_VIDEO_RANGE_MATRIX);
    static final float[] T_TX_RGB_2_YUV_601_FULL_RANGE_MATRIX = TXCYUVRGBConvertMatrix.matrixTranspose(TX_RGB_2_YUV_601_FULL_RANGE_MATRIX);
    static final float[] T_TX_RGB_2_YUV_709_Full_RANGE_MATRIX = TXCYUVRGBConvertMatrix.matrixTranspose(TX_RGB_2_YUV_709_FULL_RANGE_MATRIX);
    static final float[] T_TX_RGB_2_YUV_709_VIDEO_RANGE_MATRIX = TXCYUVRGBConvertMatrix.matrixTranspose(TX_RGB_2_YUV_709_VIDEO_RANGE_MATRIX);

    static float[] makeYUV2RGBMatrixInternal(float Kr, float Kg, float Kb, float yMulti, float uvMulti) {
        return new float[]{yMulti, yMulti, yMulti, 0.0f, -uvMulti * (1.0f - Kb) * Kb / Kg, uvMulti * (1.0f - Kb), uvMulti * (1.0f - Kr), -uvMulti * (1.0f - Kr) * Kr / Kg, 0.0f};
    }

    static float[] makeRGB2YUVMatrixInternal(float Kr, float Kg, float Kb, float yMulti, float uvMulti) {
        return new float[]{yMulti * Kr, -uvMulti * Kr / (1.0f - Kb), uvMulti, yMulti * Kg, -uvMulti * Kg / (1.0f - Kb), -uvMulti * Kg / (1.0f - Kr), yMulti * Kb, uvMulti, -uvMulti * Kb / (1.0f - Kr)};
    }

    static float[] makeYUV2RGBMatrix(float Kr, float Kb, float yMulti, float uvMulti) {
        return TXCYUVRGBConvertMatrix.makeYUV2RGBMatrixInternal(Kr, 1.0f - (Kr + Kb), Kb, yMulti, uvMulti);
    }

    static float[] makeRGB2YUVMatrix(float Kr, float Kb, float yMulti, float uvMulti) {
        return TXCYUVRGBConvertMatrix.makeRGB2YUVMatrixInternal(Kr, 1.0f - (Kr + Kb), Kb, yMulti, uvMulti);
    }

    static float[] matrixTranspose(float[] array) {
        float[] fArray = new float[array.length];
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int i3 = 0; i3 < 3; ++i3) {
                fArray[i2 * 3 + i3] = array[i3 * 3 + i2];
            }
        }
        return fArray;
    }
}

