/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.yuv;

import android.opengl.GLES20;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Arrays;

public abstract class TXCGPUImageYUVInputFilter
extends TXCGPUImageFilter {
    private static final int INDEX_FOR_Y = 0;
    private static final int INDEX_FOR_UV = 1;
    private int mUniformTextureUv;
    private final int[] mTextureIds = new int[2];
    private int mTextureWidth = 0;
    private int mTextureHeight = 0;

    public TXCGPUImageYUVInputFilter(String vertexShader, String fragmentShader) {
        super(vertexShader, fragmentShader);
        Arrays.fill(this.mTextureIds, -1);
    }

    public void loadYuvDataToTexture(ByteBuffer yuvData, int width, int height) {
        if (this.mTextureWidth != width || this.mTextureHeight != height) {
            this.deleteTextures();
            this.mTextureWidth = width;
            this.mTextureHeight = height;
        }
        OpenGlUtils.loadYuv420DataToTextures(yuvData, this.getUvFormat(), width, height, this.mTextureIds);
    }

    @Override
    public void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        this.mUniformTextureUv = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"uvTexture");
    }

    @Override
    public void onDraw(int inTextureId, GLTexture outTexture, FloatBuffer cubeCoordsBuffer, FloatBuffer textureCoordsBuffer) {
        TXCGPUImageYUVInputFilter tXCGPUImageYUVInputFilter = this;
        super.onDraw(tXCGPUImageYUVInputFilter.mTextureIds[0], outTexture, cubeCoordsBuffer, textureCoordsBuffer);
    }

    @Override
    public void onUninit() {
        this.deleteTextures();
        super.onUninit();
    }

    @Override
    public void beforeDrawArrays(int inTextureId) {
        super.beforeDrawArrays(inTextureId);
        GLES20.glActiveTexture((int)33985);
        OpenGlUtils.bindTexture(this.getTarget(), this.mTextureIds[1]);
        GLES20.glUniform1i((int)this.mUniformTextureUv, (int)1);
    }

    protected abstract int getUvFormat();

    private void deleteTextures() {
        for (int i2 = 0; i2 < this.mTextureIds.length; ++i2) {
            OpenGlUtils.deleteTexture(this.mTextureIds[i2]);
            this.mTextureIds[i2] = -1;
        }
    }
}

