/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.yuv;

import android.opengl.GLES20;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.yuv.TXCGPUImageYUVInputFilter;
import com.tencent.ugc.videobase.yuv.TXCYUVRGBConvertMatrix;
import com.tencent.ugc.videobase.yuv.a;
import com.tencent.ugc.videobase.yuv.b;

public class TXCGPUImageI420InputFilter
extends TXCGPUImageYUVInputFilter {
    private static final String I420_RENDER_SHADER = "precision highp float;\nvarying vec2 textureCoordinate;\nuniform sampler2D inputImageTexture;\nuniform sampler2D uvTexture;\nuniform mat3 convertMatrix;\nuniform vec3 offset;\n\nvoid main()\n{\n    highp vec3 yuvColor;\n    highp vec3 rgbColor;\n\n    // Get the YUV values\n    yuvColor.x = texture2D(inputImageTexture, textureCoordinate).r;\n    yuvColor.y = texture2D(uvTexture, vec2(textureCoordinate.x, textureCoordinate.y * 0.5)).r;\n    yuvColor.z = texture2D(uvTexture, vec2(textureCoordinate.x, textureCoordinate.y * 0.5 + 0.5)).r;\n\n    // Do the color transform\n    yuvColor += offset;\n    rgbColor = convertMatrix * yuvColor;\n\n    gl_FragColor = vec4(rgbColor, 1.0);\n}";
    private int mUniformConvertMatrix;
    private int mUniformConvertOffset;

    public TXCGPUImageI420InputFilter() {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nuniform mat4 textureTransform;\nvarying highp vec2 textureCoordinate;\nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (textureTransform * inputTextureCoordinate).xy;\n}", I420_RENDER_SHADER);
    }

    @Override
    public void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        this.mUniformConvertMatrix = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"convertMatrix");
        this.mUniformConvertOffset = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"offset");
        TXCGPUImageI420InputFilter tXCGPUImageI420InputFilter = this;
        tXCGPUImageI420InputFilter.runOnDraw(a.a(tXCGPUImageI420InputFilter));
    }

    @Override
    protected int getUvFormat() {
        return 6409;
    }

    @Override
    public void setColorFormat(GLConstants.ColorRange colorRange, GLConstants.ColorSpace colorSpace) {
        if (colorRange == this.mColorRange && colorSpace == this.mColorSpace) {
            return;
        }
        super.setColorFormat(colorRange, colorSpace);
        TXCGPUImageI420InputFilter tXCGPUImageI420InputFilter = this;
        tXCGPUImageI420InputFilter.runOnDraw(b.a(tXCGPUImageI420InputFilter));
    }

    private float[] getConvertOffset() {
        switch (this.mColorRange) {
            case c: {
                return TXCYUVRGBConvertMatrix.TX_YUV_2_RGB_FULL_RANGE_OFFSET;
            }
        }
        return TXCYUVRGBConvertMatrix.TX_YUV_2_RGB_VIDEO_RANGE_OFFSET;
    }

    private float[] getConvertMatrix() {
        GLConstants.ColorSpace colorSpace = this.mColorSpace;
        if (this.mColorSpace == null || this.mColorSpace == GLConstants.ColorSpace.a) {
            colorSpace = GLConstants.ColorSpace.b;
        }
        GLConstants.ColorRange colorRange = this.mColorRange;
        if (this.mColorRange == null || this.mColorRange == GLConstants.ColorRange.a) {
            colorRange = GLConstants.ColorRange.b;
        }
        if (colorSpace == GLConstants.ColorSpace.b) {
            if (colorRange == GLConstants.ColorRange.b) {
                return TXCYUVRGBConvertMatrix.TX_YUV_2_RGB_601_VIDEO_RANGE_MATRIX;
            }
            if (colorRange == GLConstants.ColorRange.c) {
                return TXCYUVRGBConvertMatrix.TX_YUV_2_RGB_601_FULL_RANGE_MATRIX;
            }
        } else if (colorSpace == GLConstants.ColorSpace.c) {
            if (colorRange == GLConstants.ColorRange.b) {
                return TXCYUVRGBConvertMatrix.TX_YUV_2_RGB_709_VIDEO_RANGE_MATRIX;
            }
            if (colorRange == GLConstants.ColorRange.c) {
                return TXCYUVRGBConvertMatrix.TX_YUV_2_RGB_709_FULL_RANGE_MATRIX;
            }
        }
        return TXCYUVRGBConvertMatrix.TX_YUV_2_RGB_601_VIDEO_RANGE_MATRIX;
    }

    static /* synthetic */ void lambda$setColorFormat$1(TXCGPUImageI420InputFilter this_) {
        GLES20.glUniformMatrix3fv((int)this_.mUniformConvertMatrix, (int)1, (boolean)false, (float[])this_.getConvertMatrix(), (int)0);
        GLES20.glUniform3fv((int)this_.mUniformConvertOffset, (int)1, (float[])this_.getConvertOffset(), (int)0);
    }

    static /* synthetic */ void lambda$onInit$0(TXCGPUImageI420InputFilter this_) {
        GLES20.glUseProgram((int)this_.getProgramId());
        GLES20.glUniform3fv((int)this_.mUniformConvertOffset, (int)1, (float[])this_.getConvertOffset(), (int)0);
        GLES20.glUniformMatrix3fv((int)this_.mUniformConvertMatrix, (int)1, (boolean)false, (float[])this_.getConvertMatrix(), (int)0);
    }
}

