/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import java.nio.Buffer;
import java.nio.ByteBuffer;

@JNINamespace(value="liteav::ugc")
public class BitmapUtils {
    public static Bitmap createBitmap(Bitmap source, Matrix matrix, boolean sizeSameAsOriginBitmap) {
        if (source == null) {
            return null;
        }
        source.getConfig();
        if (sizeSameAsOriginBitmap) {
            Bitmap bitmap = Bitmap.createBitmap((int)source.getWidth(), (int)source.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            new Canvas(bitmap).drawBitmap(source, matrix, paint);
            return bitmap;
        }
        return Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static Bitmap createBitmapFromBuffer(ByteBuffer buffer, int width, int height) {
        try {
            buffer.position(0);
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)buffer);
            return bitmap;
        }
        catch (Throwable throwable) {
            LiteavLog.e("BitmapUtils", "build bitmap failed.", throwable);
            return null;
        }
    }
}

