/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.frame;

import android.os.SystemClock;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.videobase.frame.IRecycler;
import com.tencent.ugc.videobase.frame.RefCounted;
import com.tencent.ugc.videobase.frame.a;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public abstract class FramePool<T extends RefCounted> {
    private static final String TAG = "FramePool";
    private static final long MAX_TIME_OUT = TimeUnit.SECONDS.toMillis(1L);
    private final String mStackTrace;
    private final Map<Key, Deque<T>> mDequeMap = new HashMap<Key, Deque<T>>();
    private volatile boolean mIsDestroyed = false;
    private final com.tencent.liteav.base.b.a mEvictThrottler = new com.tencent.liteav.base.b.a(MAX_TIME_OUT);
    private final IRecycler<T> mRecycler = a.a(this);

    protected FramePool() {
        this.mStackTrace = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T obtain(Key key) {
        RefCounted refCounted = null;
        Map<Key, Deque<T>> map = this.mDequeMap;
        synchronized (map) {
            Deque<T> deque = this.findDequeUnlock(key);
            if (!deque.isEmpty()) {
                refCounted = (RefCounted)deque.removeFirst();
            }
        }
        this.evictOverdueObjectsUnlock();
        if (refCounted == null) {
            FramePool framePool = this;
            refCounted = framePool.createInstance(framePool.mRecycler, key);
        }
        if (refCounted.retain() != 1) {
            LiteavLog.e(TAG, "invalid reference count for %s", refCounted);
        }
        return (T)refCounted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictAll() {
        ArrayList<T> arrayList = new ArrayList<T>();
        Map<Key, Deque<T>> map = this.mDequeMap;
        synchronized (map) {
            for (Deque<T> deque : this.mDequeMap.values()) {
                arrayList.addAll(deque);
            }
            this.mDequeMap.clear();
        }
        for (Object object : arrayList) {
            this.destroyInstance(object);
        }
    }

    public void destroy() {
        this.mIsDestroyed = true;
        this.evictAll();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.mIsDestroyed) {
            LiteavLog.e(TAG, "%s must call destroy() before finalize()!\n%s", this.getClass().getName(), this.mStackTrace);
        }
    }

    protected abstract T createInstance(IRecycler<T> var1, Key var2);

    protected abstract void destroyInstance(T var1);

    protected abstract Key keyForObject(T var1);

    private Deque<T> findDequeUnlock(Key key) {
        Deque<T> deque = this.mDequeMap.get(key);
        if (deque == null) {
            deque = new LinkedList<T>();
            this.mDequeMap.put(key, deque);
        }
        return deque;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictOverdueObjectsUnlock() {
        if (!this.mEvictThrottler.a()) {
            return;
        }
        long l2 = SystemClock.elapsedRealtime();
        ArrayList<RefCounted> arrayList = new ArrayList<RefCounted>();
        Map<Key, Deque<T>> map = this.mDequeMap;
        synchronized (map) {
            for (Deque<T> deque : this.mDequeMap.values()) {
                RefCounted refCounted;
                while (!(deque.isEmpty() || (refCounted = (RefCounted)deque.peekLast()) != null && l2 - refCounted.getLastUsedTimestamp() < MAX_TIME_OUT)) {
                    deque.pollLast();
                    arrayList.add(refCounted);
                }
            }
        }
        for (RefCounted refCounted : arrayList) {
            this.destroyInstance(refCounted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void lambda$new$0(FramePool this_, RefCounted obj) {
        if (obj == null) {
            return;
        }
        Map map = this_.mDequeMap;
        synchronized (map) {
            if (this_.mIsDestroyed) {
                this_.destroyInstance(obj);
                return;
            }
            FramePool framePool = this_;
            Deque deque = framePool.findDequeUnlock(framePool.keyForObject(obj));
            obj.updateLastUsedTimestamp(SystemClock.elapsedRealtime());
            deque.addFirst(obj);
            return;
        }
    }

    public static interface Key {
        public boolean equals(Object var1);

        public int hashCode();
    }
}

