/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.filter;

import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class TXCGPUImageRGBAInputFilter
extends TXCGPUImageFilter {
    private int mTextureWidth = -1;
    private int mTextureHeight = -1;
    private int mTextureId = -1;

    public void loadRgbaData(Buffer data, int width, int height) {
        this.checkTextureSize(width, height);
        this.mTextureId = OpenGlUtils.loadTexture(6408, data, width, height, this.mTextureId);
    }

    private void checkTextureSize(int width, int height) {
        if (this.mTextureWidth != width || this.mTextureHeight != height) {
            this.mTextureWidth = width;
            this.mTextureHeight = height;
            OpenGlUtils.deleteTexture(this.mTextureId);
            this.mTextureId = -1;
        }
    }

    @Override
    public void onDraw(int inTextureId, GLTexture outTexture, FloatBuffer cubeCoordsBuffer, FloatBuffer textureCoordsBuffer) {
        TXCGPUImageRGBAInputFilter tXCGPUImageRGBAInputFilter = this;
        super.onDraw(tXCGPUImageRGBAInputFilter.mTextureId, outTexture, cubeCoordsBuffer, textureCoordsBuffer);
    }

    @Override
    public void onUninit() {
        super.onUninit();
        OpenGlUtils.deleteTexture(this.mTextureId);
        this.mTextureId = -1;
    }
}

