/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.chain;

import android.opengl.GLES20;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class TXCGPUImageMultipleInputFilter
extends TXCGPUImageFilter {
    public static final String SECOND_INPUT_SAMPLE2D_NAME = "inputImageTexture2";
    public static final String THIRD_INPUT_SAMPLE2D_NAME = "inputImageTexture3";
    private final Map<String, Integer> mTexturesOnNextDraw = new HashMap<String, Integer>();
    private final Map<String, Integer> mInputUniforms = new HashMap<String, Integer>();

    public TXCGPUImageMultipleInputFilter(String vertexShader, String fragmentShader) {
        super(vertexShader, fragmentShader);
    }

    public void setInputTexture(String name, int textureId) {
        this.mTexturesOnNextDraw.put(name, textureId);
    }

    @Override
    protected void beforeDrawArrays(int textureId) {
        super.beforeDrawArrays(textureId);
        int n2 = this.getBaseInputTextureUnit();
        for (Map.Entry<String, Integer> entry : this.mTexturesOnNextDraw.entrySet()) {
            Integer n3 = this.mInputUniforms.get(entry.getKey());
            if (n3 == null) {
                n3 = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)entry.getKey());
                this.mInputUniforms.put(entry.getKey(), n3);
            }
            GLES20.glActiveTexture((int)n2);
            OpenGlUtils.bindTexture(this.getTarget(), entry.getValue());
            GLES20.glUniform1i((int)n3, (int)(n2 - 33984));
            ++n2;
        }
    }

    @Override
    protected void afterDrawArrays() {
        super.afterDrawArrays();
        int n2 = this.getBaseInputTextureUnit();
        Iterator<Map.Entry<String, Integer>> iterator = this.mTexturesOnNextDraw.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            GLES20.glActiveTexture((int)n2);
            OpenGlUtils.bindTexture(this.getTarget(), 0);
            ++n2;
        }
        this.mTexturesOnNextDraw.clear();
    }

    protected int getBaseInputTextureUnit() {
        return 33985;
    }
}

