/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.chain;

import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.l;
import com.tencent.ugc.videobase.chain.GPUInterceptor;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.chain.f;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.frame.RefCounted;
import com.tencent.ugc.videobase.utils.CollectionUtils;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TXCGPUImageFilterChain
extends TXCGPUImageFilter {
    private static final String TAG = "TXCGPUImageFilterChain";
    private final FloatBuffer mNormalCubeVerticesBuffer;
    private final FloatBuffer mNormalTextureCoordsBuffer;
    private final List<TXCGPUImageFilter> mFilters = new ArrayList<TXCGPUImageFilter>();
    private final Map<TXCGPUImageFilter, List<GPUInterceptor>> mInterceptorsBeforeFilter = new HashMap<TXCGPUImageFilter, List<GPUInterceptor>>();
    private final List<GPUInterceptor> mLastInterceptors = new ArrayList<GPUInterceptor>();
    private long mTimestamp = 0L;

    public TXCGPUImageFilterChain() {
        this.mNormalCubeVerticesBuffer = OpenGlUtils.createNormalCubeVerticesBuffer();
        this.mNormalTextureCoordsBuffer = OpenGlUtils.createTextureCoordsBuffer(l.a, false, false);
    }

    public synchronized void addFilter(TXCGPUImageFilter filter) {
        if (filter == null) {
            return;
        }
        if (!this.mLastInterceptors.isEmpty()) {
            if (this.mFilters.size() == 0) {
                this.mFilters.add(new TXCGPUImageFilter());
                LiteavLog.w(TAG, "add COPY filter to filter chain.");
            }
            this.mInterceptorsBeforeFilter.put(filter, new ArrayList<GPUInterceptor>(this.mLastInterceptors));
            this.mLastInterceptors.clear();
        }
        this.mFilters.add(filter);
        this.initFiltersAndInterceptorsOnDraw();
    }

    public synchronized void addInterceptor(GPUInterceptor interceptor) {
        if (interceptor != null) {
            this.mLastInterceptors.add(interceptor);
            this.initFiltersAndInterceptorsOnDraw();
        }
    }

    public synchronized void removeAllFilterAndInterceptor() {
        this.mFilters.clear();
        this.mInterceptorsBeforeFilter.clear();
        this.mLastInterceptors.clear();
    }

    @Override
    protected void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        this.initFiltersAndInterceptors();
    }

    private void initFiltersAndInterceptorsOnDraw() {
        TXCGPUImageFilterChain tXCGPUImageFilterChain = this;
        tXCGPUImageFilterChain.runOnDraw(f.a(tXCGPUImageFilterChain));
    }

    private void initFiltersAndInterceptors() {
        for (TXCGPUImageFilter object : this.mFilters) {
            if (object.isInitialized()) continue;
            object.initialize(this.mTexturePool);
        }
        for (List list : this.mInterceptorsBeforeFilter.values()) {
            if (list == null || list.isEmpty()) continue;
            for (GPUInterceptor gPUInterceptor : list) {
                if (gPUInterceptor.isInitialized()) continue;
                gPUInterceptor.initialize(this.mTexturePool);
            }
        }
        for (GPUInterceptor gPUInterceptor : this.mLastInterceptors) {
            if (gPUInterceptor.isInitialized()) continue;
            gPUInterceptor.initialize(this.mTexturePool);
        }
    }

    @Override
    protected void onUninit() {
        super.onUninit();
        Iterator<Object> iterator = this.mFilters.iterator();
        while (iterator.hasNext()) {
            iterator.next().uninitialize();
        }
        for (List list : this.mInterceptorsBeforeFilter.values()) {
            if (list == null || list.isEmpty()) continue;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                ((GPUInterceptor)iterator2.next()).uninitialize();
            }
        }
        iterator = this.mLastInterceptors.iterator();
        while (iterator.hasNext()) {
            ((GPUInterceptor)iterator.next()).uninitialize();
        }
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        Iterator<TXCGPUImageFilter> iterator = this.mFilters.iterator();
        while (iterator.hasNext()) {
            iterator.next().onOutputSizeChanged(width, height);
        }
    }

    public void setTimestamp(long timestamp) {
        this.mTimestamp = timestamp;
    }

    @Override
    public void onDraw(int inTextureId, GLTexture outTexture, FloatBuffer cubeCoordsBuffer, FloatBuffer textureCoordsBuffer) {
        GLTexture gLTexture;
        if (!this.isInitialized()) {
            return;
        }
        this.runPendingOnDrawTasks();
        if (inTextureId == -1) {
            return;
        }
        List<TXCGPUImageFilter> list = this.mFilters;
        int n2 = list.size();
        RefCounted refCounted = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            GLTexture gLTexture2;
            boolean bl2;
            TXCGPUImageFilter tXCGPUImageFilter = list.get(i2);
            Size size = tXCGPUImageFilter.getOutputSize();
            if (refCounted != null) {
                RefCounted refCounted2 = refCounted;
                TXCGPUImageFilterChain tXCGPUImageFilterChain = this;
                refCounted = tXCGPUImageFilterChain.doIntercept(tXCGPUImageFilterChain.mInterceptorsBeforeFilter.get(tXCGPUImageFilter), (GLTexture)refCounted2);
                if (refCounted != null && refCounted != refCounted2) {
                    refCounted2.release();
                }
                if (refCounted != null) {
                    ((GLTexture)refCounted).setMetaData(outTexture.getMetaData());
                }
            }
            boolean bl3 = i2 < n2 - 1;
            boolean bl4 = bl2 = bl3 && !CollectionUtils.isEmpty((Collection)this.mInterceptorsBeforeFilter.get(list.get(i2 + 1)));
            if (bl3 && size.equals(this.mOutputSize) && tXCGPUImageFilter.canBeSkipped() && (refCounted != null || !bl2)) {
                tXCGPUImageFilter.onFilterBeenSkipped();
                continue;
            }
            if (bl3) {
                gLTexture2 = this.mTexturePool.obtain(size.width, size.height);
                gLTexture2.setColorFormat(this.mColorRange, this.mColorSpace);
            } else {
                gLTexture2 = outTexture;
            }
            OpenGlUtils.glViewport(0, 0, size.width, size.height);
            int n4 = n3 = refCounted == null ? inTextureId : ((GLTexture)refCounted).getId();
            if (i2 == 0) {
                tXCGPUImageFilter.onDraw(n3, gLTexture2, cubeCoordsBuffer, textureCoordsBuffer);
            } else {
                tXCGPUImageFilter.onDraw(n3, gLTexture2, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer);
            }
            if (refCounted != null) {
                refCounted.release();
            }
            if ((refCounted = gLTexture2) == null) continue;
            ((GLTexture)refCounted).setMetaData(outTexture.getMetaData());
        }
        if (refCounted != null && refCounted != outTexture) {
            refCounted.release();
        }
        if ((gLTexture = this.doLastIntercept(outTexture)) != null && gLTexture != outTexture) {
            OpenGlUtils.glViewport(0, 0, gLTexture.getWidth(), gLTexture.getHeight());
            super.onDraw(gLTexture.getId(), outTexture, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer);
            gLTexture.release();
        }
    }

    private GLTexture doLastIntercept(GLTexture texture) {
        if (this.mLastInterceptors.isEmpty()) {
            return texture;
        }
        if (texture == null) {
            LiteavLog.e(TAG, "last interceptors intecept on surface.");
            return null;
        }
        TXCGPUImageFilterChain tXCGPUImageFilterChain = this;
        return tXCGPUImageFilterChain.doIntercept(tXCGPUImageFilterChain.mLastInterceptors, texture);
    }

    private GLTexture doIntercept(List<GPUInterceptor> interceptors, GLTexture texture) {
        if (interceptors == null || interceptors.isEmpty()) {
            return texture;
        }
        GLTexture gLTexture = null;
        Iterator<GPUInterceptor> iterator = interceptors.iterator();
        while (iterator.hasNext()) {
            GLTexture gLTexture2 = iterator.next().intercept(this.mTimestamp, gLTexture == null ? texture : gLTexture);
            if (gLTexture2 == null) {
                LiteavLog.e(TAG, "doIntercept return null value");
                break;
            }
            if (gLTexture != null && gLTexture2 != gLTexture) {
                gLTexture.release();
            }
            gLTexture = gLTexture2;
        }
        return gLTexture;
    }

    static /* synthetic */ void access$lambda$0(TXCGPUImageFilterChain tXCGPUImageFilterChain) {
        tXCGPUImageFilterChain.initFiltersAndInterceptors();
    }
}

