/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.chain;

import android.opengl.GLES20;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.videobase.chain.a;
import com.tencent.ugc.videobase.chain.b;
import com.tencent.ugc.videobase.chain.c;
import com.tencent.ugc.videobase.chain.d;
import com.tencent.ugc.videobase.chain.e;
import com.tencent.ugc.videobase.frame.GLFrameBuffer;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.utils.DelayQueue;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import com.tencent.ugc.videobase.utils.Program;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public class TXCGPUImageFilter {
    private static final String TAG = "TXCGPUImageFilter";
    private static final float[] IDENTITY_MATRIX = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    public static final String NO_FILTER_VERTEX_SHADER = "attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nuniform mat4 textureTransform;\nvarying highp vec2 textureCoordinate;\nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (textureTransform * inputTextureCoordinate).xy;\n}";
    public static final String NO_FILTER_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n \nuniform sampler2D inputImageTexture;\n \nvoid main()\n{\n     gl_FragColor = texture2D(inputImageTexture, textureCoordinate);\n}";
    private static final AtomicInteger sFilterCount = new AtomicInteger();
    private final DelayQueue mRunOnDrawQueue;
    private final Program mProgram;
    public final Size mOutputSize = new Size(-1, -1);
    protected GLConstants.ColorRange mColorRange = GLConstants.ColorRange.a;
    protected GLConstants.ColorSpace mColorSpace = GLConstants.ColorSpace.a;
    protected int mGLAttribPosition;
    protected int mGLUniformTexture;
    protected int mGLAttribTextureCoord;
    private int mUniformTextureTransform;
    protected GLTexturePool mTexturePool;
    private int mProgramId = -1;
    private final GLFrameBuffer mGLFrameBuffer = new GLFrameBuffer();
    private boolean mIsInitialized;
    private float[] mTextureMatrix;

    public TXCGPUImageFilter() {
        this(NO_FILTER_VERTEX_SHADER, NO_FILTER_FRAGMENT_SHADER);
    }

    public TXCGPUImageFilter(String vertexShader, String fragmentShader) {
        this.mRunOnDrawQueue = new DelayQueue();
        this.mProgram = new Program(vertexShader, fragmentShader);
    }

    public void setColorFormat(GLConstants.ColorRange colorRange, GLConstants.ColorSpace colorSpace) {
        this.mColorRange = colorRange;
        this.mColorSpace = colorSpace;
    }

    public final void initialize(GLTexturePool texturePool) {
        if (this.mIsInitialized) {
            return;
        }
        this.mGLFrameBuffer.initialize();
        this.mProgramId = this.buildProgram();
        this.mGLAttribPosition = GLES20.glGetAttribLocation((int)this.getProgramId(), (String)"position");
        this.mGLUniformTexture = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"inputImageTexture");
        this.mGLAttribTextureCoord = GLES20.glGetAttribLocation((int)this.getProgramId(), (String)"inputTextureCoordinate");
        this.mUniformTextureTransform = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"textureTransform");
        this.onInit(texturePool);
        this.mIsInitialized = true;
        LiteavLog.d(TAG, "%s initialized, count: %d", this, sFilterCount.incrementAndGet());
    }

    public final void runOnDraw(Runnable runnable) {
        this.mRunOnDrawQueue.add(runnable);
    }

    public void onOutputSizeChanged(int width, int height) {
        this.mOutputSize.width = width;
        this.mOutputSize.height = height;
    }

    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public int getTarget() {
        return 3553;
    }

    public Size getOutputSize() {
        return this.mOutputSize;
    }

    public boolean canBeSkipped() {
        return false;
    }

    public void onFilterBeenSkipped() {
        if (!this.mIsInitialized) {
            return;
        }
        GLES20.glUseProgram((int)this.getProgramId());
        this.runPendingOnDrawTasks();
    }

    public void setTextureTransform(float[] matrix) {
        this.mTextureMatrix = matrix;
    }

    public void onDraw(int inTextureId, GLTexture outTexture, FloatBuffer cubeCoordsBuffer, FloatBuffer textureCoordsBuffer) {
        if (!this.mIsInitialized) {
            return;
        }
        GLES20.glUseProgram((int)this.getProgramId());
        this.runPendingOnDrawTasks();
        cubeCoordsBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.mGLAttribPosition, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)cubeCoordsBuffer);
        GLES20.glEnableVertexAttribArray((int)this.mGLAttribPosition);
        textureCoordsBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.mGLAttribTextureCoord, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)textureCoordsBuffer);
        GLES20.glEnableVertexAttribArray((int)this.mGLAttribTextureCoord);
        if (inTextureId != -1) {
            GLES20.glActiveTexture((int)33984);
            OpenGlUtils.bindTexture(this.getTarget(), inTextureId);
            GLES20.glUniform1i((int)this.mGLUniformTexture, (int)0);
        }
        if (outTexture != null) {
            this.mGLFrameBuffer.attachTexture(outTexture.getId());
            this.mGLFrameBuffer.bindToContext();
        } else {
            OpenGlUtils.bindFramebuffer(36160, 0);
        }
        float[] fArray = this.mTextureMatrix == null ? IDENTITY_MATRIX : this.mTextureMatrix;
        GLES20.glUniformMatrix4fv((int)this.mUniformTextureTransform, (int)1, (boolean)false, (float[])fArray, (int)0);
        this.beforeDrawArrays(inTextureId);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glDisableVertexAttribArray((int)this.mGLAttribPosition);
        GLES20.glDisableVertexAttribArray((int)this.mGLAttribTextureCoord);
        this.afterDrawArrays();
        GLES20.glActiveTexture((int)33984);
        OpenGlUtils.bindTexture(this.getTarget(), 0);
        if (outTexture != null) {
            this.mGLFrameBuffer.unbindFromContext();
            this.mGLFrameBuffer.detachTexture();
        }
    }

    public final void uninitialize() {
        if (!this.mIsInitialized) {
            return;
        }
        this.runPendingOnDrawTasks();
        this.onUninit();
        this.mIsInitialized = false;
        this.mGLFrameBuffer.uninitialize();
        if (this.mProgramId != -1) {
            GLES20.glDeleteProgram((int)this.mProgramId);
            this.mProgramId = -1;
        }
        LiteavLog.d(TAG, "%s uninitialized, count: %d", this, sFilterCount.decrementAndGet());
    }

    protected void onInit(GLTexturePool texturePool) {
        this.mTexturePool = texturePool;
    }

    protected int buildProgram() {
        return this.mProgram.build();
    }

    public final int getProgramId() {
        return this.mProgramId;
    }

    protected void beforeDrawArrays(int textureId) {
    }

    protected void afterDrawArrays() {
    }

    protected void runPendingOnDrawTasks() {
        this.mRunOnDrawQueue.rerun();
    }

    protected void onUninit() {
    }

    protected boolean isLessOrEqualZero(float value) {
        return (double)value < 1.0E-5;
    }

    public void setFloatOnDraw(int location, float floatValue) {
        TXCGPUImageFilter tXCGPUImageFilter = this;
        tXCGPUImageFilter.runOnDraw(a.a(tXCGPUImageFilter, location, floatValue));
    }

    public void setFloatVec3OnDraw(int location, float[] arrayValue) {
        TXCGPUImageFilter tXCGPUImageFilter = this;
        tXCGPUImageFilter.runOnDraw(b.a(tXCGPUImageFilter, location, arrayValue));
    }

    public void setFloatVec2OnDraw(int location, float[] arrayValue) {
        TXCGPUImageFilter tXCGPUImageFilter = this;
        tXCGPUImageFilter.runOnDraw(c.a(tXCGPUImageFilter, location, arrayValue));
    }

    public void setFloatVec4OnDraw(int location, float[] arrayValue) {
        TXCGPUImageFilter tXCGPUImageFilter = this;
        tXCGPUImageFilter.runOnDraw(d.a(tXCGPUImageFilter, location, arrayValue));
    }

    public void runOnDrawAndWaitDone(Runnable runnable) {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.mRunOnDrawQueue.add(e.a(runnable, countDownLatch));
        try {
            countDownLatch.await();
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    static /* synthetic */ void lambda$runOnDrawAndWaitDone$4(Runnable runnable, CountDownLatch countDownLatch) {
        runnable.run();
        countDownLatch.countDown();
    }

    static /* synthetic */ void lambda$setFloatVec4OnDraw$3(TXCGPUImageFilter this_, int location, float[] arrayValue) {
        GLES20.glUseProgram((int)this_.getProgramId());
        GLES20.glUniform4fv((int)location, (int)1, (FloatBuffer)FloatBuffer.wrap(arrayValue));
    }

    static /* synthetic */ void lambda$setFloatVec2OnDraw$2(TXCGPUImageFilter this_, int location, float[] arrayValue) {
        GLES20.glUseProgram((int)this_.getProgramId());
        GLES20.glUniform2fv((int)location, (int)1, (FloatBuffer)FloatBuffer.wrap(arrayValue));
    }

    static /* synthetic */ void lambda$setFloatVec3OnDraw$1(TXCGPUImageFilter this_, int location, float[] arrayValue) {
        GLES20.glUseProgram((int)this_.getProgramId());
        GLES20.glUniform3fv((int)location, (int)1, (FloatBuffer)FloatBuffer.wrap(arrayValue));
    }

    static /* synthetic */ void lambda$setFloatOnDraw$0(TXCGPUImageFilter this_, int location, float floatValue) {
        GLES20.glUseProgram((int)this_.getProgramId());
        GLES20.glUniform1f((int)location, (float)floatValue);
    }
}

