/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.renderer;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.os.Looper;
import android.view.Surface;
import android.view.TextureView;
import com.tencent.liteav.base.b.b;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.ugc.renderer.RenderViewHelperInterface;
import com.tencent.ugc.renderer.h;
import com.tencent.ugc.renderer.i;
import com.tencent.ugc.renderer.j;
import com.tencent.ugc.renderer.k;
import com.tencent.ugc.renderer.l;
import com.tencent.ugc.renderer.m;
import com.tencent.ugc.videobase.videobase.TXCCloudVideoViewMethodInvoker;

public class TextureViewRenderHelper
extends RenderViewHelperInterface {
    private final String mTAG = "TextureViewRenderHelper_" + this.hashCode();
    private final CustomHandler mUIHandler = new CustomHandler(Looper.getMainLooper());
    private final b mThrottlerManager = new b();
    private final RenderViewHelperInterface.RenderViewListener mListener;
    private final TXCloudVideoView mTXCloudVideoView;
    private final Size mFrameSize = new Size();
    private GLConstants.GLScaleType mScaleType = null;
    private TextureView mTextureView;
    private SurfaceTexture mSavedSurfaceTexture = null;
    private boolean mHasFirstFrameRendered = false;
    private Matrix mTransformMatrix = new Matrix();
    private SurfaceTexture mLastSurfaceTexture;
    private final Size mSurfaceTextureSize = new Size();
    private final TextureView.SurfaceTextureListener mTextureViewListener = new TextureView.SurfaceTextureListener(){

        public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
            LiteavLog.i(TextureViewRenderHelper.this.mThrottlerManager.a("surfaceCreate"), TextureViewRenderHelper.this.mTAG, "onSurfaceTextureAvailable, size: %dx%d", width, height);
            surfaceTexture = TextureViewRenderHelper.this.setSavedSurfaceTextureToTextureView(surfaceTexture);
            TextureViewRenderHelper.this.notifySurfaceChanged(surfaceTexture);
            TextureViewRenderHelper.this.updateTextureViewRenderMatrix(TextureViewRenderHelper.this.mTextureView);
            ((TextureViewRenderHelper)TextureViewRenderHelper.this).mSurfaceTextureSize.width = width;
            ((TextureViewRenderHelper)TextureViewRenderHelper.this).mSurfaceTextureSize.height = height;
        }

        public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
            LiteavLog.i(TextureViewRenderHelper.this.mThrottlerManager.a("surfaceSizeChanged"), TextureViewRenderHelper.this.mTAG, "onSurfaceTextureSizeChanged, size: %dx%d", width, height);
            TextureViewRenderHelper.this.notifySurfaceChanged(surfaceTexture);
            TextureViewRenderHelper.this.updateTextureViewRenderMatrix(TextureViewRenderHelper.this.mTextureView);
            if (((TextureViewRenderHelper)TextureViewRenderHelper.this).mSurfaceTextureSize.width > ((TextureViewRenderHelper)TextureViewRenderHelper.this).mSurfaceTextureSize.height != width > height) {
                TextureViewRenderHelper.this.notifyRequestRedraw();
            }
            ((TextureViewRenderHelper)TextureViewRenderHelper.this).mSurfaceTextureSize.width = width;
            ((TextureViewRenderHelper)TextureViewRenderHelper.this).mSurfaceTextureSize.height = height;
        }

        public final boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            LiteavLog.i(TextureViewRenderHelper.this.mTAG, "onSurfaceTextureDestroyed");
            TextureViewRenderHelper.this.notifySurfaceDestroy();
            if (TextureViewRenderHelper.this.mTextureView != null) {
                TextureViewRenderHelper.this.mSavedSurfaceTexture = surface;
                return false;
            }
            return true;
        }

        public final void onSurfaceTextureUpdated(SurfaceTexture surface) {
            if (TextureViewRenderHelper.this.mHasFirstFrameRendered) {
                return;
            }
            TextureViewRenderHelper.this.mHasFirstFrameRendered = true;
            TextureViewRenderHelper.this.mUIHandler.post(m.a(this));
        }

        static /* synthetic */ void a(1 var0) {
            var0.TextureViewRenderHelper.this.notifyFirstFrameRendered();
        }
    };

    public TextureViewRenderHelper(TXCloudVideoView txCloudVideoView, RenderViewHelperInterface.RenderViewListener listener) {
        TextureView textureView;
        this.mListener = listener;
        this.mTXCloudVideoView = txCloudVideoView;
        if (txCloudVideoView == null) {
            LiteavLog.w(this.mTAG, "txCloudVideoView is null.");
            return;
        }
        LiteavLog.i(this.mTAG, "construct,txCloudVideoView=".concat(String.valueOf((Object)txCloudVideoView)));
        this.mTextureView = textureView = new TextureView(txCloudVideoView.getContext());
        this.mUIHandler.post(h.a(this, txCloudVideoView, textureView));
    }

    public TextureViewRenderHelper(TextureView textureView, RenderViewHelperInterface.RenderViewListener listener) {
        this.mListener = listener;
        this.mTXCloudVideoView = null;
        if (textureView == null) {
            LiteavLog.w(this.mTAG, "textureView is null.");
            return;
        }
        LiteavLog.i(this.mTAG, "construct,textureView=".concat(String.valueOf(textureView)));
        this.mTextureView = textureView;
        this.mUIHandler.post(i.a(this, textureView));
    }

    @Override
    public void release(boolean clearLastImage) {
        this.mUIHandler.post(j.a(this, clearLastImage));
    }

    @Override
    public Matrix getTransformMatrix(int width, int height) {
        Matrix matrix = new Matrix(this.mTransformMatrix);
        matrix.postScale(1.0f, -1.0f, (float)width / 2.0f, (float)height / 2.0f);
        return matrix;
    }

    @Override
    public void checkViewAvailability() {
        this.mUIHandler.post(k.a(this));
    }

    @Override
    public synchronized void updateVideoFrameInfo(GLConstants.GLScaleType scaleType, int width, int height, boolean isHDR) {
        if (this.mScaleType == scaleType && width == this.mFrameSize.width && height == this.mFrameSize.height) {
            return;
        }
        this.mScaleType = scaleType;
        this.mFrameSize.set(width, height);
        this.mUIHandler.runOrPost(l.a(this));
    }

    public TextureView getTextureView() {
        return this.mTextureView;
    }

    @Override
    public boolean isUsingTextureView() {
        return true;
    }

    private void setup(TextureView textureView) {
        if (textureView == null) {
            LiteavLog.w(this.mTAG, "setup,textureView is null.");
            return;
        }
        if (textureView.isAvailable()) {
            Size size = new Size(textureView.getWidth(), textureView.getHeight());
            LiteavLog.i(this.mTAG, "setup,textureView=" + textureView + "," + size);
            this.notifySurfaceChanged(textureView.getSurfaceTexture());
        } else {
            LiteavLog.i(this.mTAG, "setup,textureView not available.");
        }
        textureView.setSurfaceTextureListener(this.mTextureViewListener);
        this.updateTextureViewRenderMatrix(textureView);
    }

    private synchronized void updateTextureViewRenderMatrix(TextureView view) {
        double d2;
        if (view == null) {
            return;
        }
        Size size = new Size(view.getWidth(), view.getHeight());
        if (!this.mFrameSize.isValid() || !size.isValid()) {
            return;
        }
        double d3 = 1.0;
        double d4 = 1.0;
        double d5 = size.aspectRatio();
        double d6 = this.mFrameSize.aspectRatio();
        if (d2 < d5) {
            if (this.mScaleType == GLConstants.GLScaleType.b) {
                d3 = d6 / d5;
            } else if (this.mScaleType == GLConstants.GLScaleType.a) {
                d4 = d5 / d6;
            }
        } else if (this.mScaleType == GLConstants.GLScaleType.b) {
            d4 = d5 / d6;
        } else if (this.mScaleType == GLConstants.GLScaleType.a) {
            d3 = d6 / d5;
        }
        Matrix matrix = new Matrix();
        matrix.setScale((float)d3, (float)d4, (float)size.width / 2.0f, (float)size.height / 2.0f);
        if (!matrix.equals((Object)view.getTransform(new Matrix()))) {
            view.setTransform(matrix);
            view.postInvalidate();
            LiteavLog.i(this.mThrottlerManager.a("updateTextureViewMatrix"), this.mTAG, "view: %s, scaleX: %.2f, scaleY: %.2f, frame: %s, view: %s", view, d3, d4, this.mFrameSize, size);
        }
        this.mTransformMatrix = matrix;
    }

    private SurfaceTexture setSavedSurfaceTextureToTextureView(SurfaceTexture surfaceTexture) {
        if (this.mSavedSurfaceTexture == null || this.mTextureView == null) {
            return surfaceTexture;
        }
        if (!com.tencent.liteav.base.util.i.a(surfaceTexture, this.mSavedSurfaceTexture)) {
            this.mTextureView.setSurfaceTexture(this.mSavedSurfaceTexture);
            surfaceTexture = this.mSavedSurfaceTexture;
            this.mSavedSurfaceTexture = null;
        }
        return surfaceTexture;
    }

    private void notifyFirstFrameRendered() {
        if (this.mTXCloudVideoView == null || this.mTextureView == null) {
            return;
        }
        TXCCloudVideoViewMethodInvoker.removeDeprecatedViews(this.mTXCloudVideoView, this.mTextureView);
    }

    private void notifySurfaceChanged(SurfaceTexture surfaceTexture) {
        if (this.mLastSurfaceTexture == surfaceTexture) {
            return;
        }
        this.mLastSurfaceTexture = surfaceTexture;
        if (this.mListener != null) {
            this.mListener.onSurfaceChanged(new Surface(surfaceTexture), true);
        }
    }

    private void notifyRequestRedraw() {
        if (this.mListener == null || this.mTextureView == null) {
            return;
        }
        Bitmap bitmap = this.mTextureView.getBitmap();
        if (bitmap != null) {
            this.mListener.onRequestRedraw(bitmap);
        }
    }

    private void notifySurfaceDestroy() {
        this.mLastSurfaceTexture = null;
        if (this.mListener != null) {
            this.mListener.onSurfaceDestroy();
        }
    }

    static /* synthetic */ void lambda$updateVideoFrameInfo$4(TextureViewRenderHelper this_) {
        TextureViewRenderHelper textureViewRenderHelper = this_;
        textureViewRenderHelper.updateTextureViewRenderMatrix(textureViewRenderHelper.mTextureView);
    }

    static /* synthetic */ void lambda$checkViewAvailability$3(TextureViewRenderHelper this_) {
        if (this_.mTextureView == null) {
            LiteavLog.i(this_.mTAG, "view is not available when textureView is null");
            return;
        }
        if (!(this_.mTextureView.isAvailable() && this_.mTextureView.getWidth() != 0 && this_.mTextureView.getHeight() != 0 && this_.mTextureView.isShown())) {
            LiteavLog.i(this_.mTAG, "%s is not available when surface available:%b, isShown:%b", this_.mTextureView, this_.mTextureView.isAvailable(), this_.mTextureView.isShown());
        }
    }

    static /* synthetic */ void lambda$release$2(TextureViewRenderHelper this_, boolean clearLastImage) {
        LiteavLog.i(this_.mTAG, "release,mTextureView=" + this_.mTextureView);
        if (this_.mTextureView == null) {
            return;
        }
        this_.notifySurfaceDestroy();
        if (this_.mTextureView.getSurfaceTextureListener() == this_.mTextureViewListener) {
            this_.mTextureView.setSurfaceTextureListener(null);
        }
        if (this_.mSavedSurfaceTexture != null) {
            this_.mSavedSurfaceTexture.release();
            this_.mSavedSurfaceTexture = null;
        }
        if (this_.mTXCloudVideoView != null) {
            LiteavLog.i(this_.mTAG, "clearLastImage=" + clearLastImage + ",mHasFirstFrameRendered=" + this_.mHasFirstFrameRendered);
            boolean bl2 = clearLastImage | !this_.mHasFirstFrameRendered;
            TXCCloudVideoViewMethodInvoker.removeView(this_.mTXCloudVideoView, this_.mTextureView, bl2);
        }
        this_.mTextureView = null;
    }

    static /* synthetic */ void lambda$new$1(TextureViewRenderHelper this_, TextureView textureView) {
        this_.setup(textureView);
    }

    static /* synthetic */ void lambda$new$0(TextureViewRenderHelper this_, TXCloudVideoView txCloudVideoView, TextureView textureView) {
        TXCCloudVideoViewMethodInvoker.addView(txCloudVideoView, textureView);
        this_.setup(textureView);
    }
}

