/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.renderer;

import android.graphics.Matrix;
import android.os.Looper;
import android.view.Surface;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.renderer.RenderViewHelperInterface;
import com.tencent.ugc.renderer.a;
import com.tencent.ugc.renderer.b;
import com.tencent.ugc.renderer.c;

public class SurfaceRenderHelper
extends RenderViewHelperInterface {
    private final String mTAG = "SurfaceRenderHelper_" + this.hashCode();
    private final CustomHandler mUIHandler = new CustomHandler(Looper.getMainLooper());
    private final RenderViewHelperInterface.RenderViewListener mListener;
    private Surface mSurface;

    public SurfaceRenderHelper(Surface surface, RenderViewHelperInterface.RenderViewListener listener) {
        this.mListener = listener;
        if (surface == null) {
            LiteavLog.w(this.mTAG, "surface is null.");
            return;
        }
        this.mSurface = surface;
        this.mUIHandler.post(a.a(this, surface));
    }

    @Override
    public void release(boolean clearLastImage) {
        this.mUIHandler.post(b.a(this));
    }

    @Override
    public Matrix getTransformMatrix(int width, int height) {
        Matrix matrix = new Matrix();
        matrix.postScale(1.0f, -1.0f, (float)width / 2.0f, (float)height / 2.0f);
        return matrix;
    }

    @Override
    public void checkViewAvailability() {
        this.mUIHandler.post(c.a(this));
    }

    @Override
    public void updateVideoFrameInfo(GLConstants.GLScaleType scaleType, int width, int height, boolean isHDR) {
    }

    @Override
    public boolean isUsingTextureView() {
        return false;
    }

    static /* synthetic */ void lambda$checkViewAvailability$2(SurfaceRenderHelper this_) {
        if (this_.mSurface == null) {
            LiteavLog.i(this_.mTAG, "view is not available when surface is null");
            return;
        }
        if (!this_.mSurface.isValid()) {
            LiteavLog.i(this_.mTAG, "view is not available when %s is not valid", this_.mSurface);
        }
    }

    static /* synthetic */ void lambda$release$1(SurfaceRenderHelper this_) {
        LiteavLog.i(this_.mTAG, "release,mSurface=" + this_.mSurface);
        if (this_.mSurface == null) {
            return;
        }
        if (this_.mListener != null) {
            this_.mListener.onSurfaceDestroy();
        }
        this_.mSurface = null;
    }

    static /* synthetic */ void lambda$new$0(SurfaceRenderHelper this_, Surface surface) {
        LiteavLog.i(this_.mTAG, "construct,surface=".concat(String.valueOf(surface)));
        if (this_.mListener != null) {
            this_.mListener.onSurfaceChanged(surface, false);
        }
    }
}

