/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.preprocessor;

import android.content.Context;
import android.util.SparseArray;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.h;
import com.tencent.ugc.beauty.gpufilters.BeautyBrightFilter;
import com.tencent.ugc.beauty.gpufilters.BeautyInterFace;
import com.tencent.ugc.beauty.gpufilters.TXCGPUMotionBase;
import com.tencent.ugc.beauty.gpufilters.pitu.BeautyPITUFilter;
import com.tencent.ugc.beauty.gpufilters.smooth.BeautySmoothFilter;
import com.tencent.ugc.beauty.gpufilters.vague.BeautyVagueFilter;
import com.tencent.ugc.common.TXCBuildsUtil;
import com.tencent.ugc.preprocessor.a;
import com.tencent.ugc.preprocessor.b;
import com.tencent.ugc.preprocessor.c;
import com.tencent.ugc.preprocessor.d;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilterChain;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.utils.FloatUtils;
import java.util.HashMap;
import java.util.Map;

@JNINamespace(value="liteav::ugc")
public class BeautyProcessor
extends TXCGPUImageFilterChain {
    private static final String TAG = "TXCBeautyManager";
    private final boolean mIsEnterPriseProEnabled;
    private final TXCGPUMotionBase mMotionFilter;
    private final SparseArray<TXCGPUImageFilter> mBeautyFilters;
    private TXCGPUImageFilter mCurrentBeautyFilter = null;
    private int mBeautyStyle = -1;
    private float mBeautyLevel = 0.0f;
    private float mWhitenessLevel = 0.0f;
    private float mRuddyLevel = 0.0f;
    private float mSharpnessLevel = 0.4f;
    private boolean mIsPerformanceMode = true;
    private float mUserSetSharpnessLevel = 0.0f;
    private final Map<String, String> mBeautyStats = new HashMap<String, String>();
    private BeautyProcessorStatusListener mBeautyManagerStatusListener;

    public BeautyProcessor(Context context, boolean isEnterPriseProEnabled) {
        this.mIsEnterPriseProEnabled = isEnterPriseProEnabled;
        this.mBeautyFilters = new SparseArray();
        this.mMotionFilter = TXCBuildsUtil.createMotionFilter(context);
    }

    @Override
    public void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        this.mMotionFilter.initialize(texturePool);
        BeautyProcessor beautyProcessor = this;
        beautyProcessor.updateBeautyInternal(beautyProcessor.mBeautyStyle == -1 ? 0 : this.mBeautyStyle, this.mBeautyLevel, this.mWhitenessLevel, this.mRuddyLevel, this.mSharpnessLevel);
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        this.mMotionFilter.onOutputSizeChanged(width, height);
        float f2 = this.getSharpnessLevel();
        for (int i2 = 0; i2 < this.mBeautyFilters.size(); ++i2) {
            TXCGPUImageFilter tXCGPUImageFilter = (TXCGPUImageFilter)this.mBeautyFilters.valueAt(i2);
            tXCGPUImageFilter.onOutputSizeChanged(width, height);
            if (!(tXCGPUImageFilter instanceof BeautyInterFace)) continue;
            ((BeautyInterFace)((Object)tXCGPUImageFilter)).setSharpenLevel(f2);
        }
        BeautyProcessor beautyProcessor = this;
        beautyProcessor.updateBeautyInternal(beautyProcessor.mBeautyStyle == -1 ? 0 : this.mBeautyStyle, this.mBeautyLevel, this.mWhitenessLevel, this.mRuddyLevel, f2);
    }

    @Override
    public void onUninit() {
        super.onUninit();
        this.mMotionFilter.uninitialize();
        for (int i2 = 0; i2 < this.mBeautyFilters.size(); ++i2) {
            ((TXCGPUImageFilter)this.mBeautyFilters.valueAt(i2)).uninitialize();
        }
    }

    public void setBeautyManagerStatusListener(BeautyProcessorStatusListener listener) {
        this.mBeautyManagerStatusListener = listener;
    }

    public void setHomeOrientation(int homeOrientation) {
        this.mMotionFilter.setHomeOrientation(homeOrientation);
    }

    public void setBeautyLevel(float beautyLevel) {
        float f2 = h.a(beautyLevel, 0.0f);
        LiteavLog.d(TAG, "setBeautyLevel beautyLevel:".concat(String.valueOf(beautyLevel)));
        BeautyProcessor beautyProcessor = this;
        beautyProcessor.runOnDraw(a.a(beautyProcessor, f2));
    }

    public void setWhitenessLevel(float whitenessLevel) {
        float f2 = h.a(whitenessLevel, 0.0f);
        LiteavLog.d(TAG, "setWhitenessLevel whitenessLevel:".concat(String.valueOf(whitenessLevel)));
        BeautyProcessor beautyProcessor = this;
        beautyProcessor.runOnDraw(b.a(beautyProcessor, f2));
    }

    @Override
    public boolean canBeSkipped() {
        BeautyProcessor beautyProcessor = this;
        return beautyProcessor.canBeSkipped(beautyProcessor.mCurrentBeautyFilter) && this.mMotionFilter.canBeSkipped();
    }

    private boolean canBeSkipped(TXCGPUImageFilter filter) {
        if (filter == null) {
            return true;
        }
        return filter.canBeSkipped();
    }

    public void updateStatsOnDraw(String key, int value) {
        BeautyProcessor beautyProcessor = this;
        beautyProcessor.runOnDraw(c.a(beautyProcessor, key, value));
    }

    /*
     * Unable to fully structure code
     */
    private void updateBeautyInternal(int beautyStyle, float beautyLevel, float whitenessLevel, float ruddyLevel, float sharpnessLevel) {
        block11: {
            if (this.mOutputSize.width == -1 || this.mOutputSize.height == -1) {
                return;
            }
            if (this.mBeautyStyle != beautyStyle) {
                this.updateStatsOnDraw("beautyStyle", beautyStyle);
            }
            if ((var6_6 = (TXCGPUImageFilter)this.mBeautyFilters.get(beautyStyle)) == null) {
                switch (beautyStyle) {
                    case 0: {
                        var6_6 = new BeautySmoothFilter();
                        break;
                    }
                    case 1: {
                        var6_6 = new BeautyVagueFilter();
                        break;
                    }
                    case 2: {
                        var6_6 = new BeautyPITUFilter();
                        break;
                    }
                    default: {
                        var6_6 = new BeautyBrightFilter();
                    }
                }
                var6_6.initialize(this.mTexturePool);
                var6_6.onOutputSizeChanged(this.mOutputSize.width, this.mOutputSize.height);
                this.mBeautyFilters.put(beautyStyle, (Object)var6_6);
            }
            var7_7 = (BeautyInterFace)var6_6;
            var7_7.setBeautyLevel(beautyLevel);
            var7_7.setRuddyLevel(ruddyLevel);
            var7_7.setWhitenessLevel(whitenessLevel);
            var7_7.setSharpenLevel(sharpnessLevel);
            if (this.mBeautyStyle == beautyStyle && FloatUtils.isEqual(this.mBeautyLevel, beautyLevel) != false && FloatUtils.isEqual(this.mWhitenessLevel, whitenessLevel) != false && FloatUtils.isEqual(this.mRuddyLevel, ruddyLevel) != false && FloatUtils.isEqual(this.mSharpnessLevel, sharpnessLevel) != false) break block11;
            this.mBeautyStyle = beautyStyle;
            this.mBeautyLevel = beautyLevel;
            this.mWhitenessLevel = whitenessLevel;
            this.mRuddyLevel = ruddyLevel;
            this.mSharpnessLevel = sharpnessLevel;
            this.removeAllFilterAndInterceptor();
            this.mCurrentBeautyFilter = null;
            v0 = this;
            if (!v0.isLessOrEqualZero(v0.mBeautyLevel)) ** GOTO lbl-1000
            v1 = this;
            if (!v1.isLessOrEqualZero(v1.mRuddyLevel)) ** GOTO lbl-1000
            v2 = this;
            if (v2.isLessOrEqualZero(v2.mWhitenessLevel)) {
                v3 = true;
            } else lbl-1000:
            // 3 sources

            {
                v3 = false;
            }
            if (!v3) {
                this.addFilter(var6_6);
                this.mCurrentBeautyFilter = var6_6;
            }
            v4 = this;
            v4.addFilter(v4.mMotionFilter);
        }
    }

    private void updateStatsInternal(String key, float value) {
        this.mBeautyStats.put(key, String.valueOf(value));
        if (this.mBeautyManagerStatusListener == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.mBeautyStats.entrySet()) {
            stringBuilder.append(entry.getKey()).append(":").append(entry.getValue()).append(" ");
        }
        String string = "{" + stringBuilder + "}";
        this.mBeautyManagerStatusListener.onBeautyStatsChanged(string);
    }

    private float getSharpnessLevel() {
        float f2 = this.mUserSetSharpnessLevel != 0.0f ? this.mUserSetSharpnessLevel : (!this.mIsPerformanceMode && Math.min(this.mOutputSize.width, this.mOutputSize.height) >= 540 ? 0.4f : 0.0f);
        return f2;
    }

    public void setPerformanceMode(boolean isPerformanceMode) {
        LiteavLog.d(TAG, "setPerformanceMode: ".concat(String.valueOf(isPerformanceMode)));
        BeautyProcessor beautyProcessor = this;
        beautyProcessor.runOnDraw(d.a(beautyProcessor, isPerformanceMode));
    }

    private void updateSharpenLevelInternal() {
        float f2 = this.getSharpnessLevel();
        LiteavLog.d(TAG, "sharpnessLevel: ".concat(String.valueOf(f2)));
        BeautyProcessor beautyProcessor = this;
        beautyProcessor.updateBeautyInternal(beautyProcessor.mBeautyStyle, this.mBeautyLevel, this.mWhitenessLevel, this.mRuddyLevel, f2);
    }

    static /* synthetic */ void lambda$setPerformanceMode$3(BeautyProcessor this_, boolean isPerformanceMode) {
        this_.mIsPerformanceMode = isPerformanceMode;
        this_.updateSharpenLevelInternal();
    }

    static /* synthetic */ void lambda$updateStatsOnDraw$2(BeautyProcessor this_, String key, int value) {
        this_.updateStatsInternal(key, value);
    }

    static /* synthetic */ void lambda$setWhitenessLevel$1(BeautyProcessor this_, float clampedLevel) {
        BeautyProcessor beautyProcessor = this_;
        beautyProcessor.updateBeautyInternal(beautyProcessor.mBeautyStyle, this_.mBeautyLevel, clampedLevel, this_.mRuddyLevel, this_.mSharpnessLevel);
        this_.updateStatsInternal("whiteLevel", clampedLevel);
    }

    static /* synthetic */ void lambda$setBeautyLevel$0(BeautyProcessor this_, float clampedLevel) {
        BeautyProcessor beautyProcessor = this_;
        beautyProcessor.updateBeautyInternal(beautyProcessor.mBeautyStyle, clampedLevel, this_.mWhitenessLevel, this_.mRuddyLevel, this_.mSharpnessLevel);
        this_.updateStatsInternal("beautyLevel", clampedLevel);
    }

    public static interface BeautyProcessorStatusListener {
        public void onBeautyStatsChanged(String var1);
    }
}

