/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.encoder;

import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.l;
import com.tencent.ugc.encoder.VideoEncodeParams;
import com.tencent.ugc.videobase.common.EncodedVideoFrame;
import com.tencent.ugc.videobase.frame.PixelFrame;

@JNINamespace(value="liteav::ugc")
public class UGCVideoEncoderJNI {
    private long mNativeHandle = 0L;
    private UGCVideoEncoderListener mListener;

    public void start(EncoderType encoderType, VideoEncodeParams params, UGCVideoEncoderListener listener) {
        this.mListener = listener;
        if (this.mNativeHandle != 0L) {
            return;
        }
        this.mNativeHandle = UGCVideoEncoderJNI.nativeCreate(this);
        UGCVideoEncoderJNI.nativeStart(this.mNativeHandle, encoderType == EncoderType.HARDWARE, params);
    }

    public void encodeFrame(PixelFrame frame) {
        if (this.mNativeHandle == 0L) {
            return;
        }
        l l2 = l.a;
        if (frame.getMetaData() != null) {
            l2 = frame.getMetaData().getEncodeRotation();
        }
        UGCVideoEncoderJNI.nativeEncodeFrame(this.mNativeHandle, frame.getTextureId(), frame.getGLContext(), frame.getWidth(), frame.getHeight(), l2.mValue, frame.getTimestamp());
    }

    public void signalEndOfStream() {
        if (this.mNativeHandle != 0L) {
            UGCVideoEncoderJNI.nativeSignalEndOfStream(this.mNativeHandle);
        }
    }

    public void stopSync(long maxWaitTimeMs) {
        if (this.mNativeHandle != 0L) {
            UGCVideoEncoderJNI.nativeStopSync(this.mNativeHandle, (int)maxWaitTimeMs);
            UGCVideoEncoderJNI.nativeDestroy(this.mNativeHandle);
            this.mNativeHandle = 0L;
        }
    }

    public boolean isInputQueueFull() {
        if (this.mNativeHandle != 0L) {
            return UGCVideoEncoderJNI.nativeIsInputQueueFull(this.mNativeHandle);
        }
        return false;
    }

    private void onEncodedNALFromNative(EncodedVideoFrame nal) {
        UGCVideoEncoderListener uGCVideoEncoderListener = this.mListener;
        if (uGCVideoEncoderListener != null) {
            uGCVideoEncoderListener.onEncodedNAL(nal);
        }
    }

    private void onEncodedFailFromNative() {
        UGCVideoEncoderListener uGCVideoEncoderListener = this.mListener;
        if (uGCVideoEncoderListener != null) {
            uGCVideoEncoderListener.onEncodedFail();
        }
    }

    private static native long nativeCreate(UGCVideoEncoderJNI var0);

    private static native void nativeDestroy(long var0);

    private static native void nativeStart(long var0, boolean var2, VideoEncodeParams var3);

    private static native void nativeEncodeFrame(long var0, int var2, Object var3, int var4, int var5, int var6, long var7);

    private static native boolean nativeIsInputQueueFull(long var0);

    private static native void nativeSignalEndOfStream(long var0);

    private static native void nativeStopSync(long var0, int var2);

    public static interface UGCVideoEncoderListener {
        public void onEncodedNAL(EncodedVideoFrame var1);

        public void onEncodedFail();
    }

    public static enum EncoderType {
        HARDWARE,
        SOFTWARE;

    }
}

