/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.encoder;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Bundle;
import android.view.Surface;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.common.CodecType;
import com.tencent.liteav.videobase.common.c;
import com.tencent.ugc.encoder.MediaFormatBuilder;
import com.tencent.ugc.encoder.VideoEncodeParams;
import com.tencent.ugc.videobase.common.EncodedVideoFrame;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

@JNINamespace(value="liteav::ugc")
public class UGCMediaCodecJni {
    private static final String TAG = "UGCMediaCodecJni";
    public static final int DRAIN_ERROR = -1;
    public static final int DRAIN_SUCCESS = 0;
    public static final int DRAIN_TRY_AGAIN_ONCE = 1;
    public static final int DRAIN_TRY_AGAIN_LATER = 2;
    public static final int FEED_ERROR = -1;
    public static final int FEED_SUCCESS = 0;
    public static final int FEED_TRY_AGAIN_LATER = 1;

    public static int getSupportInputBufferColorFormat(String mimeType) {
        ArrayList<GLConstants.PixelFormatType> arrayList = new ArrayList<GLConstants.PixelFormatType>();
        MediaCodec mediaCodec = null;
        try {
            mediaCodec = MediaCodec.createEncoderByType((String)mimeType);
            int[] nArray = mediaCodec.getCodecInfo().getCapabilitiesForType((String)mimeType).colorFormats;
            int n2 = mediaCodec.getCodecInfo().getCapabilitiesForType((String)mimeType).colorFormats.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = nArray[i2];
                if (n3 == 19) {
                    arrayList.add(GLConstants.PixelFormatType.a);
                    continue;
                }
                if (n3 != 21) continue;
                arrayList.add(GLConstants.PixelFormatType.b);
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "get support color format error ".concat(String.valueOf(throwable)));
        }
        UGCMediaCodecJni.destroyMediaCodec(mediaCodec);
        if (!arrayList.isEmpty()) {
            return ((GLConstants.PixelFormatType)((Object)arrayList.get(0))).getValue();
        }
        return GLConstants.PixelFormatType.p.getValue();
    }

    public static MediaCodec createMediaCodec(String mimeType) {
        MediaCodec mediaCodec = null;
        try {
            mediaCodec = MediaCodec.createEncoderByType((String)mimeType);
            if (!"OMX.google.h264.encoder".equals(mediaCodec.getName())) {
                return mediaCodec;
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "create MediaCodec failed.".concat(String.valueOf(throwable)));
        }
        UGCMediaCodecJni.destroyMediaCodec(mediaCodec);
        return null;
    }

    public static MediaFormat configureMediaCodec(MediaCodec mediaCodec, VideoEncodeParams encodeParams, boolean useProfileAndLevel, int pixelFormat, int maxBFrames) {
        String string = "video/avc";
        if (encodeParams.codecType == CodecType.c) {
            string = "video/hevc";
        }
        MediaFormatBuilder mediaFormatBuilder = new MediaFormatBuilder(mediaCodec, string, encodeParams);
        mediaFormatBuilder.enableSetBitrateModeIfSupport(true);
        mediaFormatBuilder.useProfileAndLevel(useProfileAndLevel);
        MediaFormat mediaFormat = mediaFormatBuilder.build();
        if (mediaFormat == null) {
            return null;
        }
        try {
            LiteavLog.i(TAG, "Configure MediaCodec with MediaFormat: ".concat(String.valueOf(mediaFormat)));
            UGCMediaCodecJni.setPixelFormatToMediaFormat(mediaFormat, GLConstants.PixelFormatType.a(pixelFormat));
            UGCMediaCodecJni.setColorRangeToMediaFormat(mediaFormat, encodeParams.colorRange);
            UGCMediaCodecJni.setColorSpaceToMediaFormat(mediaFormat, encodeParams.colorSpace);
            UGCMediaCodecJni.setMaxBFramesToMediaFormat(mediaFormat, maxBFrames);
            mediaCodec.configure(mediaFormat, null, null, 1);
            return mediaFormat;
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "MediaCodec configure failed.".concat(String.valueOf(throwable)));
            return null;
        }
    }

    private static void setPixelFormatToMediaFormat(MediaFormat mediaFormat, GLConstants.PixelFormatType pixelFormatType) {
        if (pixelFormatType == GLConstants.PixelFormatType.a) {
            mediaFormat.setInteger("color-format", 19);
            return;
        }
        if (pixelFormatType == GLConstants.PixelFormatType.b) {
            mediaFormat.setInteger("color-format", 21);
        }
    }

    private static void setColorRangeToMediaFormat(MediaFormat mediaFormat, GLConstants.ColorRange colorRange) {
        if (LiteavSystemInfo.getSystemOSVersionInt() < 24) {
            return;
        }
        if (colorRange == GLConstants.ColorRange.c) {
            mediaFormat.setInteger("color-range", 1);
            return;
        }
        if (colorRange == GLConstants.ColorRange.b) {
            mediaFormat.setInteger("color-range", 2);
        }
    }

    private static void setColorSpaceToMediaFormat(MediaFormat format, GLConstants.ColorSpace colorSpace) {
        if (LiteavSystemInfo.getSystemOSVersionInt() < 24) {
            return;
        }
        if (colorSpace == GLConstants.ColorSpace.c) {
            format.setInteger("color-standard", 1);
            return;
        }
        if (colorSpace == GLConstants.ColorSpace.b) {
            format.setInteger("color-standard", 4);
        }
    }

    private static void setMaxBFramesToMediaFormat(MediaFormat mediaFormat, int maxBFrames) {
        if (maxBFrames <= 0 || LiteavSystemInfo.getSystemOSVersionInt() < 29) {
            return;
        }
        mediaFormat.setInteger("max-bframes", maxBFrames);
    }

    public static Surface createInputSurface(MediaCodec mediaCodec) {
        try {
            if (mediaCodec != null) {
                return mediaCodec.createInputSurface();
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "MediaCodec create input surface failed.".concat(String.valueOf(throwable)));
        }
        return null;
    }

    public static boolean startMediaCodec(MediaCodec mediaCodec) {
        try {
            if (mediaCodec != null) {
                mediaCodec.start();
                return true;
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "MediaCodec start failed.".concat(String.valueOf(throwable)));
        }
        return false;
    }

    public static int getIntFromMediaFormat(MediaFormat mediaFormat, String key, int defValue) {
        try {
            if (mediaFormat != null) {
                return mediaFormat.getInteger(key);
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "Get %s from MediaFormat failed.".concat(String.valueOf(throwable)));
        }
        return defValue;
    }

    public static boolean updateBitrate(MediaCodec mediaCodec, int bitrate_bps) {
        if (mediaCodec == null || LiteavSystemInfo.getSystemOSVersionInt() < 19) {
            return false;
        }
        try {
            Bundle bundle = new Bundle();
            bundle.putInt("video-bitrate", bitrate_bps);
            mediaCodec.setParameters(bundle);
            return true;
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "update bitrate to MediaCodec failed.".concat(String.valueOf(throwable)));
            return false;
        }
    }

    public static int feedYuvBufferToMediaCodec(MediaCodec mediaCodec, ByteBuffer buffer, long pts, int timeoutMs) {
        try {
            int n2 = mediaCodec.dequeueInputBuffer(TimeUnit.MILLISECONDS.toMicros(timeoutMs));
            if (n2 < 0) {
                return 1;
            }
            ByteBuffer byteBuffer = mediaCodec.getInputBuffers()[n2];
            byteBuffer.clear();
            byteBuffer.put(buffer);
            mediaCodec.queueInputBuffer(n2, 0, buffer.capacity(), TimeUnit.MILLISECONDS.toMicros(pts), 0);
            return 0;
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "Feed yuv buffer to MediaCodec failed.".concat(String.valueOf(throwable)));
            return -1;
        }
    }

    public static int feedEndOfStreamBufferToMediaCodec(MediaCodec mediaCodec, int timeoutMs) {
        try {
            int n2 = mediaCodec.dequeueInputBuffer(TimeUnit.MILLISECONDS.toMicros(timeoutMs));
            if (n2 < 0) {
                return 1;
            }
            mediaCodec.queueInputBuffer(n2, 0, 0, TimeUnit.MILLISECONDS.toMicros(0L), 4);
            return 0;
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "Feed yuv buffer to MediaCodec failed.".concat(String.valueOf(throwable)));
            return -1;
        }
    }

    public static int drainOutputBuffer(MediaCodec mediaCodec, EncodedVideoFrame videoFrame, int timeoutMs) {
        int n2;
        MediaCodec.BufferInfo bufferInfo;
        block9: {
            block8: {
                try {
                    bufferInfo = new MediaCodec.BufferInfo();
                    n2 = mediaCodec.dequeueOutputBuffer(bufferInfo, TimeUnit.MILLISECONDS.toMicros(timeoutMs));
                    if (n2 == -1) {
                        return 2;
                    }
                    if (n2 != -2) break block8;
                    return 1;
                }
                catch (Throwable throwable) {
                    LiteavLog.e(TAG, "Drain output from MediaCodec failed.", throwable);
                    return -1;
                }
            }
            if (n2 == -3) {
                LiteavLog.i(TAG, "encoder output buffers changed");
                return 1;
            }
            if (n2 >= 0) break block9;
            return -1;
        }
        if (bufferInfo.size == 0 && (bufferInfo.flags & 4) == 0) {
            LiteavLog.e(TAG, "size is zero, but it isn't end of stream");
            return -1;
        }
        ByteBuffer byteBuffer = LiteavSystemInfo.getSystemOSVersionInt() >= 21 ? mediaCodec.getOutputBuffer(n2) : mediaCodec.getOutputBuffers()[n2];
        if (byteBuffer == null) {
            return -1;
        }
        byteBuffer.position(bufferInfo.offset);
        byteBuffer.limit(bufferInfo.offset + bufferInfo.size);
        videoFrame.data = ByteBuffer.allocateDirect(bufferInfo.size);
        videoFrame.data.put(byteBuffer);
        boolean bl2 = (bufferInfo.flags & 1) > 0;
        videoFrame.nalType = bl2 ? c.b : c.a;
        videoFrame.pts = TimeUnit.MICROSECONDS.toMillis(bufferInfo.presentationTimeUs);
        videoFrame.isEosFrame = (bufferInfo.flags & 4) > 0;
        mediaCodec.releaseOutputBuffer(n2, false);
        return 0;
    }

    public static void signalEndOfInputStream(MediaCodec mediaCodec) {
        if (mediaCodec != null) {
            try {
                mediaCodec.signalEndOfInputStream();
                return;
            }
            catch (Throwable throwable) {
                LiteavLog.e(TAG, "signalEndOfStream failed. ".concat(String.valueOf(throwable)));
            }
        }
    }

    public static void releaseSurface(Surface surface) {
        try {
            if (surface != null) {
                surface.release();
            }
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "Release surface failed.".concat(String.valueOf(throwable)));
            return;
        }
    }

    public static void destroyMediaCodec(MediaCodec mediaCodec) {
        if (mediaCodec == null) {
            return;
        }
        try {
            mediaCodec.stop();
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "Stop MediaCodec failed.".concat(String.valueOf(throwable)));
        }
        try {
            mediaCodec.release();
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "Destroy MediaCodec failed.".concat(String.valueOf(throwable)));
            return;
        }
    }
}

