/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.decoder;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import com.tencent.liteav.base.b.b;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.videobase.common.CodecType;
import com.tencent.ugc.decoder.H264SPSModifier;
import com.tencent.ugc.decoder.MediaCodecWrapper;
import com.tencent.ugc.videobase.common.EncodedVideoFrame;
import com.tencent.ugc.videobase.common.MediaCodecAbility;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.utils.CollectionUtils;
import com.tencent.ugc.videobase.utils.HardwareDecoderMediaFormatBuilder;
import com.tencent.ugc.videobase.utils.MemoryAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

public abstract class MediaCodecDecoder {
    protected String mTAG = "MediaCodecDecoder";
    private MediaCodec mMediaCodec = null;
    protected MediaCodecDecoderListener mListener;
    protected final Size mResolution;
    protected final MediaCodec.BufferInfo mBufferInfo = new MediaCodec.BufferInfo();
    private final HardwareDecoderMediaFormatBuilder mDecoderMediaFormatBuilder;
    private boolean mEnableLimitMaxDecFrameBufferingInH264Sps = false;
    private final H264SPSModifier mSPSModifier = new H264SPSModifier();
    private volatile CustomHandler mWorkHandler;
    protected final b mThrottlers = new b();
    protected final boolean mForceSoftwareDecoder;

    public MediaCodecDecoder(HardwareDecoderMediaFormatBuilder builder, Size resolution, boolean useSoftwareDecoder, MediaCodecDecoderListener listener, CustomHandler handler) {
        this.mDecoderMediaFormatBuilder = builder;
        this.mResolution = resolution;
        this.mForceSoftwareDecoder = useSoftwareDecoder;
        this.mListener = listener;
        this.mWorkHandler = handler;
    }

    public abstract boolean start(Object var1);

    public boolean feedEncodedFrame(EncodedVideoFrame frame) {
        if (this.mMediaCodec == null) {
            return false;
        }
        if (frame == null || !frame.isEosFrame && (frame.data == null || frame.data.remaining() == 0)) {
            LiteavLog.w(this.mTAG, "receive empty buffer.");
            return true;
        }
        ByteBuffer[] byteBufferArray = this.mMediaCodec.getInputBuffers();
        if (CollectionUtils.isEmpty(byteBufferArray)) {
            LiteavLog.e(this.mTAG, "get invalid input buffers.");
            return false;
        }
        int n2 = MediaCodecWrapper.dequeueInputBuffer(this.mMediaCodec, TimeUnit.MILLISECONDS.toMicros(3L));
        if (n2 < 0) {
            return false;
        }
        if (!frame.isEosFrame) {
            this.limitMaxDecFrameBufferingInH264Sps(frame);
            int n3 = frame.data.remaining();
            byteBufferArray[n2].put(frame.data);
            MediaCodecWrapper.queueInputBuffer(this.mMediaCodec, n2, 0, n3, TimeUnit.MILLISECONDS.toMicros(frame.pts), 0);
        } else {
            LiteavLog.i(this.mTAG, "feedDataToMediaCodec BUFFER_FLAG_END_OF_STREAM");
            MediaCodecWrapper.queueInputBuffer(this.mMediaCodec, n2, 0, 0, 0L, 4);
        }
        return true;
    }

    public boolean drainDecodedFrame() {
        if (this.mMediaCodec == null) {
            return false;
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            int n2 = MediaCodecWrapper.dequeueOutputBuffer(this.mMediaCodec, this.mBufferInfo, TimeUnit.MILLISECONDS.toMicros(1L));
            if (n2 == -1) {
                return false;
            }
            if (n2 == -3) {
                LiteavLog.i(this.mTAG, "on output buffers changed");
                continue;
            }
            if (n2 == -2) {
                MediaCodecDecoder mediaCodecDecoder = this;
                mediaCodecDecoder.outputFormatChange(mediaCodecDecoder.mMediaCodec.getOutputFormat());
                continue;
            }
            if (n2 >= 0) {
                MediaCodecDecoder mediaCodecDecoder = this;
                return mediaCodecDecoder.handleOutputBuffer(mediaCodecDecoder.mMediaCodec, this.mBufferInfo, n2);
            }
            LiteavLog.d(this.mTAG, "dequeueOutputBuffer get invalid index: %d", n2);
            return false;
        }
        return false;
    }

    public void stop() {
        this.destroyMediaCodec();
    }

    public void flush() {
        if (this.mMediaCodec != null) {
            try {
                this.mMediaCodec.flush();
                return;
            }
            catch (Throwable throwable) {
                LiteavLog.e(this.mTAG, "mediacodec flush exception.", throwable);
            }
        }
    }

    public void enableLimitMaxDecFrameBuffer(boolean enable) {
        this.mEnableLimitMaxDecFrameBufferingInH264Sps = enable;
    }

    public BuildResult buildMediaCodec(boolean enableLowLatency, MediaCodec preloadMediaCodec) {
        this.mDecoderMediaFormatBuilder.setIsLowLatencyDecodeEnabled(enableLowLatency);
        MediaFormat mediaFormat = this.mDecoderMediaFormatBuilder.build();
        BuildResult buildResult = new BuildResult();
        boolean bl2 = true;
        String string = "";
        try {
            if (preloadMediaCodec != null) {
                this.mMediaCodec = preloadMediaCodec;
                MediaCodecDecoder mediaCodecDecoder = this;
                mediaCodecDecoder.updateOutputSurface(mediaCodecDecoder.mMediaCodec);
                LiteavLog.i(this.mTAG, "preload MediaCodec update surface success (%s)", this.mMediaCodec.getName());
            } else {
                String string2 = mediaFormat.getString("mime");
                this.mMediaCodec = this.createMediaCodecInternal(this.mForceSoftwareDecoder, string2);
                this.mMediaCodec.setVideoScalingMode(1);
                MediaCodecDecoder mediaCodecDecoder = this;
                bl2 = mediaCodecDecoder.configureMediaCodec(mediaCodecDecoder.mMediaCodec, mediaFormat);
                if (bl2) {
                    LiteavLog.i(this.mTAG, "configure MediaCodec with ".concat(String.valueOf(mediaFormat)));
                    this.mMediaCodec.start();
                    LiteavLog.i(this.mTAG, "start MediaCodec(%s) success.", this.mMediaCodec.getName());
                }
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(this.mTAG, "start MediaCodec failed.", throwable);
            bl2 = false;
            string = "VideoDecode: Start decoder failed";
            if (throwable instanceof IllegalArgumentException) {
                string = "VideoDecode: illegal argument, Start decoder failed";
            } else if (throwable instanceof IllegalStateException) {
                string = "VideoDecode: illegal state, Start decoder failed";
            }
            string = "decoder config fail, message:" + string + " exception:" + throwable.getMessage();
        }
        buildResult.isSuccess = bl2;
        if (!bl2) {
            this.destroyMediaCodec();
            buildResult.warningMessage = string;
        }
        return buildResult;
    }

    public MediaCodec createMediaCodecInternal(boolean forceSoftware, String mimeType) throws IOException {
        if (!forceSoftware) {
            return MediaCodec.createDecoderByType((String)mimeType);
        }
        for (MediaCodecInfo mediaCodecInfo : new MediaCodecList(0).getCodecInfos()) {
            String[] stringArray = mediaCodecInfo.getSupportedTypes();
            if (mediaCodecInfo.isEncoder()) continue;
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!stringArray2[i2].contains(mimeType) || !MediaCodecAbility.isSoftOnlyDecoder(mediaCodecInfo)) continue;
                LiteavLog.i(this.mTAG, "Use soft only decoder:%s", mediaCodecInfo.getName());
                return MediaCodec.createByCodecName((String)mediaCodecInfo.getName());
            }
        }
        return MediaCodec.createDecoderByType((String)mimeType);
    }

    protected abstract boolean configureMediaCodec(MediaCodec var1, MediaFormat var2);

    protected abstract void updateOutputSurface(MediaCodec var1);

    protected abstract boolean handleOutputBuffer(MediaCodec var1, MediaCodec.BufferInfo var2, int var3);

    protected void destroyMediaCodec() {
        if (this.mMediaCodec == null) {
            return;
        }
        try {
            LiteavLog.i(this.mTAG, "mediaCodec stop");
            this.mMediaCodec.stop();
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.e(this.mTAG, "stop MediaCodec failed." + throwable.getMessage());
            return;
        }
        finally {
            try {
                LiteavLog.i(this.mTAG, "mediaCodec release");
                this.mMediaCodec.release();
            }
            catch (Throwable throwable) {
                LiteavLog.e(this.mTAG, "release MediaCodec failed.", throwable);
            }
            this.mMediaCodec = null;
        }
    }

    private void limitMaxDecFrameBufferingInH264Sps(EncodedVideoFrame frame) {
        if (!frame.isIDRFrame() || frame.codecType != CodecType.b || !this.mEnableLimitMaxDecFrameBufferingInH264Sps) {
            return;
        }
        byte[] byArray = MemoryAllocator.allocateByteArray(frame.data.remaining());
        if (byArray == null) {
            return;
        }
        frame.data.get(byArray);
        frame.data.rewind();
        int[] nArray = new int[]{-1};
        byte[] byArray2 = this.getSpsData(byArray, nArray);
        if (byArray2 == null || nArray[0] < 0) {
            return;
        }
        byte[] byArray3 = null;
        try {
            byArray3 = this.mSPSModifier.updateVUIforMaxBuffering(byArray2);
        }
        catch (Throwable throwable) {
            LiteavLog.e(this.mTAG, "modify dec buffer error ", throwable);
        }
        if (byArray3 == null) {
            return;
        }
        ByteBuffer byteBuffer = MemoryAllocator.allocateDirectBuffer(byArray.length - byArray2.length + byArray3.length);
        if (byteBuffer == null) {
            return;
        }
        frame.data = byteBuffer;
        if (nArray[0] > 0) {
            frame.data.put(byArray, 0, nArray[0]);
        }
        frame.data.put(byArray3);
        frame.data.put(byArray, nArray[0] + byArray2.length, byArray.length - nArray[0] - byArray2.length);
        frame.data.rewind();
    }

    private byte[] getSpsData(byte[] data, int[] spsPosition) {
        int n2 = 0;
        while (n2 + 4 < data.length && (n2 = EncodedVideoFrame.getNextNALHeaderPos(n2, ByteBuffer.wrap(data))) >= 0) {
            if ((data[n2] & 0x1F) != 7) continue;
            spsPosition[0] = n2;
            break;
        }
        if (spsPosition[0] < 0) {
            return null;
        }
        n2 = data.length - spsPosition[0];
        int n3 = spsPosition[0];
        while (n3 + 3 < data.length) {
            if (data[n3] == 0 && data[n3 + 1] == 0 && data[n3 + 2] == 1 || data[n3] == 0 && data[n3 + 1] == 0 && data[n3 + 2] == 0 && data[n3 + 3] == 1) {
                n2 = n3 - spsPosition[0];
                break;
            }
            ++n3;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(data, spsPosition[0], byArray, 0, byArray.length);
        return byArray;
    }

    protected void outputFormatChange(MediaFormat newFormat) {
        LiteavLog.i(this.mTAG, "decode output format changed: ".concat(String.valueOf(newFormat)));
        int n2 = Math.abs(newFormat.getInteger("crop-right") - newFormat.getInteger("crop-left")) + 1;
        int n3 = Math.abs(newFormat.getInteger("crop-bottom") - newFormat.getInteger("crop-top")) + 1;
        int n4 = newFormat.getInteger("width");
        int n5 = newFormat.getInteger("height");
        LiteavLog.i(this.mTAG, "cropWidth: %d, cropHeight: %d, frameWidth: %d, frameHeight: %d", n2, n3, n4, n5);
    }

    protected void runOnWorkThread(Runnable runnable) {
        if (this.mWorkHandler != null) {
            this.mWorkHandler.runOrPost(runnable);
        }
    }

    public static class BuildResult {
        public boolean isSuccess = true;
        public String warningMessage = "";
    }

    public static interface MediaCodecDecoderListener {
        public void onDecodeFrame(PixelFrame var1, boolean var2);

        public void onDecoderError();
    }
}

