/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.decoder;

import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.decoder.H264RbspRewriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class H264SPSModifier {
    private static final String TAG = "H264SPSModifier";
    private static final boolean DEBUG = false;
    private boolean mReceiveFirstVUI = false;

    private void printBuffer(String tag, byte[] buffer) {
    }

    private byte[] deEmulationPrevention(byte[] sps) {
        byte[] byArray = new byte[sps.length];
        int n2 = 0;
        int n3 = 0;
        while (n3 < sps.length) {
            if (n3 < sps.length - 3 && sps[n3] == 0 && sps[n3 + 1] == 0 && sps[n3 + 2] == 3 && sps[n3 + 3] <= 3) {
                byArray[n2++] = sps[n3];
                byArray[n2++] = sps[n3 + 1];
                n3 += 3;
                continue;
            }
            byArray[n2++] = sps[n3];
            ++n3;
        }
        if (n2 != sps.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return null;
    }

    private byte[] emulationPrevention(byte[] sps) {
        byte[] byArray = new byte[sps.length * 3 / 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < sps.length) {
            if (n3 < sps.length - 2 && sps[n3] == 0 && sps[n3 + 1] == 0 && sps[n3 + 2] <= 3) {
                byArray[n2++] = sps[n3];
                byArray[n2++] = sps[n3 + 1];
                byArray[n2++] = 3;
                n3 += 2;
                continue;
            }
            byArray[n2++] = sps[n3];
            ++n3;
        }
        if (n2 != sps.length) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            return byArray2;
        }
        return sps;
    }

    public byte[] updateVUIforMaxBuffering(byte[] originSps) throws IOException {
        this.printBuffer("origin sps : ", originSps);
        boolean bl2 = false;
        byte[] byArray = this.deEmulationPrevention(originSps);
        if (byArray != null) {
            this.printBuffer("deEmulationPrevention sps : ", byArray);
            bl2 = true;
        } else {
            byArray = originSps;
        }
        byArray = this.updateVUIforMaxBuffering(new ByteArrayInputStream(byArray));
        this.printBuffer("new sps : ", byArray);
        if (byArray != null && bl2) {
            byArray = this.emulationPrevention(byArray);
            this.printBuffer("emulationPrevention sps : ", byArray);
        }
        return byArray;
    }

    public byte[] updateVUIforMaxBuffering(InputStream is) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        H264RbspRewriter h264RbspRewriter = new H264RbspRewriter(is, byteArrayOutputStream);
        h264RbspRewriter.skipNBit(8, "NALU type");
        int n3 = (int)h264RbspRewriter.readNBit(8, "SPS: profile_idc");
        h264RbspRewriter.skipNBit(8, "SPS: constraint_set_0-3_flag and reserved_zero_4bits");
        h264RbspRewriter.readNBit(8, "SPS: level_idc");
        h264RbspRewriter.skipUE("SPS: seq_parameter_set_id");
        if (n3 == 100 || n3 == 110 || n3 == 122 || n3 == 144) {
            if (h264RbspRewriter.readUE("SPS: chroma_format_idc") == 3) {
                h264RbspRewriter.skipNBit(1, "SPS: residual_color_transform_flag");
            }
            h264RbspRewriter.skipUE("SPS: bit_depth_luma_minus8");
            h264RbspRewriter.skipUE("SPS: bit_depth_chroma_minus8");
            h264RbspRewriter.skipNBit(1, "SPS: qpprime_y_zero_transform_bypass_flag");
            if (h264RbspRewriter.readBool("SPS: seq_scaling_matrix_present_lag")) {
                for (n2 = 0; n2 < 8; ++n2) {
                    if (!h264RbspRewriter.readBool("SPS: seqScalingListPresentFlag")) continue;
                    if (n2 < 6) {
                        h264RbspRewriter.skipScalingList(16);
                        continue;
                    }
                    h264RbspRewriter.skipScalingList(64);
                }
            }
        }
        h264RbspRewriter.skipUE("SPS: log2_max_frame_num_minus4");
        int n4 = h264RbspRewriter.readUE("SPS: pic_order_cnt_type");
        if (n4 == 0) {
            h264RbspRewriter.skipUE("SPS: log2_max_pic_order_cnt_lsb_minus4");
        } else if (n4 == 1) {
            h264RbspRewriter.skipNBit(1, "SPS: delta_pic_order_always_zero_flag");
            h264RbspRewriter.skipUE("SPS: offset_for_non_ref_pic");
            h264RbspRewriter.skipUE("SPS: offset_for_top_to_bottom_field");
            int n5 = h264RbspRewriter.readUE("SPS: num_ref_frames_in_pic_order_cnt_cycle");
            for (n2 = 0; n2 < n5; ++n2) {
                h264RbspRewriter.skipUE("SPS: offsetForRefFrame [" + n2 + "]");
            }
        }
        h264RbspRewriter.readUE("SPS: num_ref_frames");
        h264RbspRewriter.skipNBit(1, "SPS: gaps_in_frame_num_value_allowed_flag");
        h264RbspRewriter.skipUE("SPS: pic_width_in_mbs_minus1");
        h264RbspRewriter.skipUE("SPS: pic_height_in_map_units_minus1");
        if (!h264RbspRewriter.readBool("SPS: frame_mbs_only_flag")) {
            h264RbspRewriter.skipNBit(1, "SPS: mb_adaptive_frame_field_flag");
        }
        h264RbspRewriter.skipNBit(1, "SPS: direct_8x8_inference_flag");
        if (h264RbspRewriter.readBool("SPS: frame_cropping_flag")) {
            h264RbspRewriter.skipUE("SPS: frame_crop_left_offset");
            h264RbspRewriter.skipUE("SPS: frame_crop_right_offset");
            h264RbspRewriter.skipUE("SPS: frame_crop_top_offset");
            h264RbspRewriter.skipUE("SPS: frame_crop_bottom_offset");
        }
        if (h264RbspRewriter.testBool("SPS: vui_parameters_present_flag")) {
            h264RbspRewriter.writeBool(true, "VUI set 1: ");
            if (!this.modifyVUIParameters(h264RbspRewriter)) {
                return null;
            }
        } else {
            h264RbspRewriter.writeBool(true, "VUI set 1: ");
            h264RbspRewriter.writeBool(false, "VUI: aspect_ratio_info_present_flag");
            h264RbspRewriter.writeBool(false, "VUI: overscan_info_present_flag");
            h264RbspRewriter.writeBool(false, "VUI: video_signal_type_present_flag");
            h264RbspRewriter.writeBool(false, "VUI: chroma_loc_info_present_flag");
            h264RbspRewriter.writeBool(false, "VUI: timing_info_present_flag");
            h264RbspRewriter.writeBool(false, "VUI: nal_hrd_parameters_present_flag");
            h264RbspRewriter.writeBool(false, "VUI: vcl_hrd_parameters_present_flag");
            h264RbspRewriter.writeBool(false, "VUI: pic_struct_present_flag");
            h264RbspRewriter.writeBool(true, "VUI: bitstream_restriction_flag");
            h264RbspRewriter.writeBool(true, "VUI: motion_vectors_over_pic_boundaries_flag");
            h264RbspRewriter.writeUE(0, "VUI: max_bytes_per_pic_denom");
            h264RbspRewriter.writeUE(0, "VUI: max_bits_per_mb_denom");
            h264RbspRewriter.writeUE(10, "VUI: log2_max_mv_length_horizontal");
            h264RbspRewriter.writeUE(10, "VUI: log2_max_mv_length_vertical");
            h264RbspRewriter.writeUE(0, "VUI: num_reorder_frames");
            h264RbspRewriter.writeUE(1, "VUI: max_dec_frame_buffering");
            if (!this.mReceiveFirstVUI) {
                LiteavLog.w(TAG, "decode: add max_dec_frame_buffering 1 when vui is no exist");
                this.mReceiveFirstVUI = true;
            }
        }
        h264RbspRewriter.writeTrailingBits();
        return byteArrayOutputStream.toByteArray();
    }

    private void readHRDParameters(H264RbspRewriter reader) throws IOException {
        int n2 = reader.readUE("SPS: cpb_cnt_minus1");
        reader.skipNBit(4, "HRD: bit_rate_scale");
        reader.skipNBit(4, "HRD: cpb_size_scale");
        for (int i2 = 0; i2 <= n2; ++i2) {
            reader.skipUE("HRD: bit_rate_value_minus1");
            reader.skipUE("HRD: cpb_size_value_minus1");
            reader.skipNBit(1, "HRD: cbr_flag");
        }
        reader.skipNBit(5, "HRD: initial_cpb_removal_delay_length_minus1");
        reader.skipNBit(5, "HRD: cpb_removal_delay_length_minus1");
        reader.skipNBit(5, "HRD: dpb_output_delay_length_minus1");
        reader.skipNBit(5, "HRD: time_offset_length");
    }

    private boolean modifyVUIParameters(H264RbspRewriter reader) throws IOException {
        boolean bl2;
        boolean bl3;
        if (reader.readBool("VUI: aspect_ratio_info_present_flag") && (int)reader.readNBit(8, "VUI: aspect_ratio") == 255) {
            reader.skipNBit(16, "VUI: sar_width");
            reader.skipNBit(16, "VUI: sar_height");
        }
        if (reader.readBool("VUI: overscan_info_present_flag")) {
            reader.skipNBit(1, "VUI: overscan_appropriate_flag");
        }
        if (reader.readBool("VUI: video_signal_type_present_flag")) {
            reader.skipNBit(3, "VUI: video_format");
            reader.skipNBit(1, "VUI: video_full_range_flag");
            if (reader.readBool("VUI: colour_description_present_flag")) {
                reader.skipNBit(8, "VUI: colour_primaries");
                reader.skipNBit(8, "VUI: transfer_characteristics");
                reader.skipNBit(8, "VUI: matrix_coefficients");
            }
        }
        if (reader.readBool("VUI: chroma_loc_info_present_flag")) {
            reader.skipUE("VUI chroma_sample_loc_type_top_field");
            reader.skipUE("VUI chroma_sample_loc_type_bottom_field");
        }
        if (reader.readBool("VUI: timing_info_present_flag")) {
            reader.skipNBit(32, "VUI: num_units_in_tick");
            reader.skipNBit(32, "VUI: time_scale");
            reader.skipNBit(1, "VUI: fixed_frame_rate_flag");
        }
        if (bl3 = reader.readBool("VUI: nal_hrd_parameters_present_flag")) {
            this.readHRDParameters(reader);
        }
        if (bl2 = reader.readBool("VUI: vcl_hrd_parameters_present_flag")) {
            this.readHRDParameters(reader);
        }
        if (bl3 || bl2) {
            reader.skipNBit(1, "VUI: low_delay_hrd_flag");
        }
        reader.skipNBit(1, "VUI: pic_struct_present_flag");
        if (reader.testBool("VUI: bitstream_restriction_flag")) {
            reader.writeBool(true, "VUI: set bitstream_restriction_flag");
            reader.readBool("VUI: motion_vectors_over_pic_boundaries_flag");
            reader.skipUE("VUI max_bytes_per_pic_denom");
            reader.skipUE("VUI max_bits_per_mb_denom");
            reader.skipUE("VUI log2_max_mv_length_horizontal");
            reader.skipUE("VUI log2_max_mv_length_vertical");
            reader.skipUE("VUI num_reorder_frames");
            if (!this.mReceiveFirstVUI) {
                int n2 = reader.readUE(false);
                LiteavLog.w(TAG, "decode: do not add max_dec_frame_buffering when it is ".concat(String.valueOf(n2)));
                this.mReceiveFirstVUI = true;
            }
            return false;
        }
        reader.writeBool(true, "VUI: set bitstream_restriction_flag");
        reader.writeBool(true, "VUI: motion_vectors_over_pic_boundaries_flag");
        reader.writeUE(0, "VUI: max_bytes_per_pic_denom");
        reader.writeUE(0, "VUI: max_bits_per_mb_denom");
        reader.writeUE(10, "VUI: log2_max_mv_length_horizontal");
        reader.writeUE(10, "VUI: log2_max_mv_length_vertical");
        reader.writeUE(0, "VUI: num_reorder_frames");
        reader.writeUE(1, "VUI: max_dec_frame_buffering");
        if (!this.mReceiveFirstVUI) {
            LiteavLog.w(TAG, "decode: add max_dec_frame_buffering 1 when it is no exist");
            this.mReceiveFirstVUI = true;
        }
        return true;
    }
}

