/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.decoder;

import com.tencent.ugc.decoder.CharCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class H264RbspRewriter {
    protected static int bitsRead;
    protected CharCache debugBits = new CharCache(50);
    int nBit;
    private InputStream is;
    private int curByte;
    private int nextByte;
    private final OutputStream os;
    private int[] curByteWrite = new int[8];
    private int curBit;
    private static final String TAG = "H264RbspRewriter";
    public static final boolean DEBUG = false;

    public H264RbspRewriter(InputStream is) throws IOException {
        this.is = is;
        this.os = null;
        this.curByte = is.read();
        this.nextByte = is.read();
    }

    public H264RbspRewriter(InputStream is, OutputStream out) throws IOException {
        this.is = is;
        this.os = out;
        this.curByte = is.read();
        this.nextByte = is.read();
    }

    public boolean readBool(boolean copy) throws IOException {
        return this.read1Bit(copy) == 1;
    }

    public boolean readBool(String message) throws IOException {
        boolean bl2 = this.readBool(true);
        this.trace(message, bl2 ? "1" : "0");
        return bl2;
    }

    public int read1Bit(boolean copy) throws IOException {
        if (this.nBit == 8) {
            this.advance();
            if (this.curByte == -1) {
                return -1;
            }
        }
        int n2 = this.curByte >> 7 - this.nBit & 1;
        ++this.nBit;
        if (copy && this.os != null) {
            this.write1Bit(n2);
        }
        return n2;
    }

    public long readNBit(int n2, boolean copy) throws IOException {
        if (n2 > 64) {
            throw new IllegalArgumentException("Can not readByte more then 64 bit");
        }
        long l2 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 = l2 << 1 | (long)this.read1Bit(copy);
        }
        return l2;
    }

    public long readNBit(int n2) throws IOException {
        if (n2 > 64) {
            throw new IllegalArgumentException("Can not readByte more then 64 bit");
        }
        long l2 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 = l2 << 1 | (long)this.read1Bit(true);
        }
        return l2;
    }

    public long readNBit(int n2, String message) throws IOException {
        long l2 = this.readNBit(n2);
        this.trace(message, String.valueOf(l2));
        return l2;
    }

    public void skipNBit(int n2) throws IOException {
        if (n2 > 64) {
            throw new IllegalArgumentException("Can not skip more then 64 bit");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.read1Bit(true);
        }
    }

    public void skipNBit(int n2, String message) throws IOException {
        this.skipNBit(n2);
        this.trace(message, "skip NBits");
    }

    private void advance() throws IOException {
        this.curByte = this.nextByte;
        this.nextByte = this.is.read();
        this.nBit = 0;
    }

    public int readByte() throws IOException {
        if (this.nBit > 0) {
            this.advance();
        }
        int n2 = this.curByte;
        this.advance();
        return n2;
    }

    public long readRemainingByte() throws IOException {
        return this.readNBit(8 - this.nBit);
    }

    public int readUE(boolean copy) throws IOException {
        int n2 = 0;
        while (this.read1Bit(copy) == 0) {
            ++n2;
        }
        int n3 = 0;
        if (n2 > 0) {
            long l2 = this.readNBit(n2, copy);
            n3 = (int)((long)((1 << n2) - 1) + l2);
        }
        return n3;
    }

    private int readUE() throws IOException {
        int n2 = 0;
        while (this.read1Bit(true) == 0) {
            ++n2;
        }
        int n3 = 0;
        if (n2 > 0) {
            long l2 = this.readNBit(n2);
            n3 = (int)((long)((1 << n2) - 1) + l2);
        }
        return n3;
    }

    public int readUE(String message) throws IOException {
        int n2 = this.readUE();
        this.trace(message, String.valueOf(n2));
        return n2;
    }

    private void skipUE() throws IOException {
        int n2 = 0;
        while (this.read1Bit(true) == 0) {
            ++n2;
        }
        if (n2 > 0) {
            this.skipNBit(n2);
        }
    }

    public void skipUE(String message) throws IOException {
        this.skipUE();
        this.trace(message, "skip UE");
    }

    public int readSE(String message) throws IOException {
        int n2 = this.readUE();
        int n3 = ((n2 & 1) << 1) - 1;
        n2 = ((n2 >> 1) + (n2 & 1)) * n3;
        this.trace(message, String.valueOf(n2));
        return n2;
    }

    public boolean testBool(String message) throws IOException {
        boolean bl2 = this.readBool(false);
        this.trace(message, bl2 ? "1" : "0");
        return bl2;
    }

    public int readU(int i2, String string) throws IOException {
        return (int)this.readNBit(i2, string);
    }

    public byte[] read(int payloadSize) throws IOException {
        byte[] byArray = new byte[payloadSize];
        for (int i2 = 0; i2 < payloadSize; ++i2) {
            byArray[i2] = (byte)this.readByte();
        }
        return byArray;
    }

    public int readZeroBitCount(String message) throws IOException {
        int n2 = 0;
        while (this.read1Bit(true) == 0) {
            ++n2;
        }
        this.trace(message, String.valueOf(n2));
        return n2;
    }

    public void readTrailingBits() throws IOException {
        this.read1Bit(true);
        this.readRemainingByte();
    }

    public void skipScalingList(int sizeOfScalingList) throws IOException {
        int[] nArray = new int[sizeOfScalingList];
        int n2 = 8;
        int n3 = 8;
        for (int i2 = 0; i2 < sizeOfScalingList; ++i2) {
            if (n3 != 0) {
                int n4 = this.readSE("deltaScale");
                n3 = (n2 + n4 + 256) % 256;
            }
            nArray[i2] = n3 == 0 ? n2 : n3;
            n2 = nArray[i2];
        }
    }

    public void flush() throws IOException {
        for (int i2 = this.curBit; i2 < 8; ++i2) {
            this.curByteWrite[i2] = 0;
        }
        this.curBit = 0;
        this.writeCurByte();
    }

    private void writeCurByte() throws IOException {
        int n2 = this.curByteWrite[0] << 7 | this.curByteWrite[1] << 6 | this.curByteWrite[2] << 5 | this.curByteWrite[3] << 4 | this.curByteWrite[4] << 3 | this.curByteWrite[5] << 2 | this.curByteWrite[6] << 1 | this.curByteWrite[7];
        this.os.write(n2);
    }

    public void write1Bit(int value) throws IOException {
        if (this.curBit == 8) {
            this.curBit = 0;
            this.writeCurByte();
        }
        this.curByteWrite[this.curBit++] = value;
    }

    public void writeNBit(long value, int n2) throws IOException {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.write1Bit((int)(value >> n2 - i2 - 1) & 1);
        }
    }

    public void writeNBit(long value, int n2, String string) throws IOException {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.write1Bit((int)(value >> n2 - i2 - 1) & 1);
        }
    }

    public void writeRemainingZero() throws IOException {
        this.writeNBit(0L, 8 - this.curBit);
    }

    public void writeU(int value, int n2, String string) throws IOException {
        this.writeNBit(value, n2);
    }

    public void writeU(int i2, int n2) throws IOException {
        this.writeNBit(i2, n2);
    }

    public void writeUE(int value) throws IOException {
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < 15; ++i2) {
            if (value < n3 + (1 << i2)) {
                n2 = i2;
                break;
            }
            n3 += 1 << i2;
        }
        this.writeNBit(0L, n2);
        this.write1Bit(1);
        this.writeNBit(value - n3, n2);
    }

    public void writeUE(int value, String string) throws IOException {
        this.writeUE(value);
    }

    public void writeSE(int value, String string) throws IOException {
        this.writeUE((value << 1) * (value < 0 ? -1 : 1) + (value > 0 ? 1 : 0));
    }

    public void writeBool(boolean value, String string) throws IOException {
        this.write1Bit(value ? 1 : 0);
    }

    public void writeTrailingBits() throws IOException {
        this.write1Bit(1);
        this.writeRemainingZero();
        this.flush();
    }

    public void writeSliceTrailingBits() {
        throw new IllegalStateException("todo");
    }

    private void trace(String message, String val) {
    }
}

