/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.common;

import android.media.MediaFormat;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.l;
import com.tencent.liteav.videobase.common.d;
import com.tencent.liteav.videoproducer.encoder.VideoEncoderDef;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.encoder.VideoEncodeParams;
import java.util.List;

@JNINamespace(value="liteav::ugc")
public class UGCTranscodeVideoEncodeParamsDecider {
    private static final String TAG = "UGCTranscodeVideoEncodeParamsDecider";
    private final long mNativeHandler;
    private List<MediaFormat> mVideoMediaFormatList;
    private boolean mFullIFrame = false;
    private d mEncodeProfile = d.d;
    private int[] mSourceFpsArray;

    public UGCTranscodeVideoEncodeParamsDecider() {
        this.mNativeHandler = UGCTranscodeVideoEncodeParamsDecider.nativeCreate();
    }

    public void finalize() throws Throwable {
        UGCTranscodeVideoEncodeParamsDecider.nativeDestroy(this.mNativeHandler);
    }

    public void setInputVideoMediaFormat(List<MediaFormat> videoMediaFormat) {
        this.mVideoMediaFormatList = videoMediaFormat;
        if (this.mVideoMediaFormatList == null) {
            return;
        }
        int[] nArray = new int[videoMediaFormat.size()];
        int[] nArray2 = new int[videoMediaFormat.size()];
        this.mSourceFpsArray = new int[videoMediaFormat.size()];
        for (int i2 = 0; i2 < videoMediaFormat.size(); ++i2) {
            MediaFormat mediaFormat = this.mVideoMediaFormatList.get(i2);
            Size size = this.getSizeFromMediaFormat(mediaFormat);
            nArray[i2] = size.width;
            nArray2[i2] = size.height;
            this.mSourceFpsArray[i2] = this.getNumberFromMediaFormat(mediaFormat, "frame-rate", 30);
            LiteavLog.i(TAG, "source video fps = " + this.mSourceFpsArray[i2] + " resolution = " + size);
        }
        UGCTranscodeVideoEncodeParamsDecider.nativeSetSourceVideoInfo(this.mNativeHandler, nArray, nArray2, this.mSourceFpsArray);
    }

    public void setInputCanvasSize(Size size) {
        if (size == null) {
            return;
        }
        LiteavLog.i(TAG, "set input canvas size :".concat(String.valueOf(size)));
        UGCTranscodeVideoEncodeParamsDecider.nativeSetCanvasSize(this.mNativeHandler, size.width, size.height);
    }

    public void setOutputResolution(int videoCompress) {
        UGCTranscodeVideoEncodeParamsDecider.nativeSetEncodeResolution(this.mNativeHandler, videoCompress);
    }

    public void setEncodeBitrate(int bitrate) {
        UGCTranscodeVideoEncodeParamsDecider.nativeSetEncodeBitrate(this.mNativeHandler, bitrate);
    }

    public void setEncodeFramerate(TXVideoEditConstants.VideoFrameRateLevel framerate) {
        UGCTranscodeVideoEncodeParamsDecider.nativeSetEncodeFramerate(this.mNativeHandler, framerate.asInt());
    }

    public void setEncodeProfile(int profile) {
        LiteavLog.i(TAG, "setEncodeProfile ".concat(String.valueOf(profile)));
        if (profile == 2) {
            this.mEncodeProfile = d.c;
            return;
        }
        if (profile == 1) {
            this.mEncodeProfile = d.b;
            return;
        }
        this.mEncodeProfile = d.d;
    }

    public void setFullIFrame(boolean isFullIFrame) {
        if (isFullIFrame == this.mFullIFrame) {
            return;
        }
        LiteavLog.i(TAG, "setFullIFrame ".concat(String.valueOf(isFullIFrame)));
        this.mFullIFrame = isFullIFrame;
    }

    public void setEncodeRotation(l rotation) {
        UGCTranscodeVideoEncodeParamsDecider.nativeSetEncodeRotation(this.mNativeHandler, rotation.mValue);
    }

    public VideoEncodeParams getDecidedEncodeParams() {
        VideoEncodeParams videoEncodeParams = new VideoEncodeParams();
        new VideoEncodeParams().annexb = true;
        videoEncodeParams.bitrateMode = VideoEncoderDef.BitrateMode.c;
        videoEncodeParams.fullIFrame = false;
        videoEncodeParams.encoderProfile = this.mEncodeProfile;
        videoEncodeParams.setFullIFrame(this.mFullIFrame);
        videoEncodeParams.gop = this.getDecidedGOP();
        Size size = UGCTranscodeVideoEncodeParamsDecider.nativeGetSelectedResolution(this.mNativeHandler);
        videoEncodeParams.width = size.width;
        videoEncodeParams.height = size.height;
        videoEncodeParams.fps = UGCTranscodeVideoEncodeParamsDecider.nativeGetSelectedFramerate(this.mNativeHandler);
        videoEncodeParams.bitrate = this.getDecidedVideoBitrate(size);
        LiteavLog.i(TAG, "getVideoEncodeParams: ".concat(String.valueOf(videoEncodeParams)));
        return videoEncodeParams;
    }

    public boolean isNeedFilterFrame() {
        if (this.mSourceFpsArray == null || this.mSourceFpsArray.length == 0) {
            return false;
        }
        int n2 = UGCTranscodeVideoEncodeParamsDecider.nativeGetSelectedFramerate(this.mNativeHandler);
        int[] nArray = this.mSourceFpsArray;
        int n3 = this.mSourceFpsArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (nArray[i2] <= n2 + 1) continue;
            return true;
        }
        return false;
    }

    private int getDecidedVideoBitrate(Size outSize) {
        if (this.mFullIFrame) {
            if (outSize.width < 1280 && outSize.height < 1280) {
                return 15000;
            }
            return 24000;
        }
        return UGCTranscodeVideoEncodeParamsDecider.nativeGetSelectedBitrate(this.mNativeHandler);
    }

    private int getDecidedGOP() {
        if (this.mVideoMediaFormatList == null || this.mVideoMediaFormatList.size() == 0) {
            return 3;
        }
        MediaFormat mediaFormat = this.mVideoMediaFormatList.get(0);
        return this.getNumberFromMediaFormat(mediaFormat, "i-frame-interval", 3);
    }

    private Size getSizeFromMediaFormat(MediaFormat mediaFormat) {
        int n2;
        Size size = new Size();
        new Size().width = this.getNumberFromMediaFormat(mediaFormat, "width", 720);
        size.height = this.getNumberFromMediaFormat(mediaFormat, "height", 1280);
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 23 && ((n2 = this.getNumberFromMediaFormat(mediaFormat, "rotation-degrees", 0)) == 90 || n2 == 270)) {
            size.swap();
        }
        return size;
    }

    private int getNumberFromMediaFormat(MediaFormat mediaFormat, String key, int defaultValue) {
        int n2 = defaultValue;
        if (mediaFormat == null || !mediaFormat.containsKey(key)) {
            return defaultValue;
        }
        try {
            n2 = mediaFormat.getInteger(key);
        }
        catch (ClassCastException classCastException) {
            LiteavLog.w(TAG, "getNumberFromMediaFormat integer ClassCastException: ".concat(String.valueOf(classCastException)));
            try {
                n2 = (int)mediaFormat.getFloat(key);
            }
            catch (ClassCastException classCastException2) {
                LiteavLog.w(TAG, "getNumberFromMediaFormat float ClassCastException: ".concat(String.valueOf(classCastException2)));
            }
        }
        return n2;
    }

    private static Size createVideoSize(int width, int height) {
        return new Size(width, height);
    }

    private static native long nativeCreate();

    private static native void nativeDestroy(long var0);

    private static native void nativeSetEncodeResolution(long var0, int var2);

    private static native void nativeSetEncodeFramerate(long var0, int var2);

    private static native void nativeSetEncodeBitrate(long var0, int var2);

    private static native void nativeSetEncodeRotation(long var0, int var2);

    private static native void nativeSetSourceVideoInfo(long var0, int[] var2, int[] var3, int[] var4);

    private static native void nativeSetCanvasSize(long var0, int var2, int var3);

    private static native int nativeGetSelectedFramerate(long var0);

    private static native int nativeGetSelectedBitrate(long var0);

    private static native Size nativeGetSelectedResolution(long var0);
}

