/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.beauty.gpufilters.vague;

import android.opengl.GLES20;
import com.tencent.ugc.beauty.NativeLoad;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.frame.GLTexturePool;

public class TXCGChannelBeautyFilter
extends TXCGPUImageFilter {
    private int mSingleStepOffsetLoc = -1;
    private int mBeautyParamsHandle = -1;
    private final float[] mBeautyParam = new float[]{0.5f, 0.0f, 0.0f, 0.0f};

    public TXCGChannelBeautyFilter() {
        super(null, null);
    }

    @Override
    public int buildProgram() {
        return NativeLoad.nativeLoadGLProgram(14);
    }

    @Override
    public void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        this.mSingleStepOffsetLoc = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"singleStepOffset");
        this.mBeautyParamsHandle = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"beautyParams");
    }

    public void setTexSize(int width, int height) {
        TXCGChannelBeautyFilter tXCGChannelBeautyFilter = this;
        tXCGChannelBeautyFilter.setFloatVec2OnDraw(tXCGChannelBeautyFilter.mSingleStepOffsetLoc, new float[]{2.0f / (float)width, 2.0f / (float)height});
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        this.setTexSize(width, height);
    }

    public void setBeautyLevel(float level) {
        this.mBeautyParam[0] = level;
        TXCGChannelBeautyFilter tXCGChannelBeautyFilter = this;
        tXCGChannelBeautyFilter.setBeautyParam(tXCGChannelBeautyFilter.mBeautyParam);
    }

    public void setWhitenessLevel(float level) {
        this.mBeautyParam[1] = level;
        TXCGChannelBeautyFilter tXCGChannelBeautyFilter = this;
        tXCGChannelBeautyFilter.setBeautyParam(tXCGChannelBeautyFilter.mBeautyParam);
    }

    public void setRuddyLevel(float level) {
        this.mBeautyParam[2] = level;
        TXCGChannelBeautyFilter tXCGChannelBeautyFilter = this;
        tXCGChannelBeautyFilter.setBeautyParam(tXCGChannelBeautyFilter.mBeautyParam);
    }

    private void setBeautyParam(float[] param) {
        TXCGChannelBeautyFilter tXCGChannelBeautyFilter = this;
        tXCGChannelBeautyFilter.setFloatVec4OnDraw(tXCGChannelBeautyFilter.mBeautyParamsHandle, param);
    }

    @Override
    public boolean canBeSkipped() {
        TXCGChannelBeautyFilter tXCGChannelBeautyFilter = this;
        if (tXCGChannelBeautyFilter.isLessOrEqualZero(tXCGChannelBeautyFilter.mBeautyParam[0])) {
            TXCGChannelBeautyFilter tXCGChannelBeautyFilter2 = this;
            if (tXCGChannelBeautyFilter2.isLessOrEqualZero(tXCGChannelBeautyFilter2.mBeautyParam[1])) {
                TXCGChannelBeautyFilter tXCGChannelBeautyFilter3 = this;
                if (tXCGChannelBeautyFilter3.isLessOrEqualZero(tXCGChannelBeautyFilter3.mBeautyParam[2])) {
                    return true;
                }
            }
        }
        return false;
    }
}

