/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.beauty.gpufilters.smooth;

import android.opengl.GLES20;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.beauty.NativeLoad;
import com.tencent.ugc.videobase.filter.TXCGPUTwoInputFilter;
import com.tencent.ugc.videobase.frame.GLTexturePool;

public class TXCBeautyBlend
extends TXCGPUTwoInputFilter {
    private static final String TAG = "BeautyBlend";
    private int mContrastUniform = -1;
    private int mWhiteDegreeUniform = -1;
    private int mRuddyDegreeUniform = -1;
    private float mWhiteLevel = 0.0f;
    private float mRuddyLevel = 0.0f;
    private float mContract = 0.0f;

    public TXCBeautyBlend() {
        super(null);
    }

    @Override
    public int buildProgram() {
        return NativeLoad.nativeLoadGLProgram(12);
    }

    @Override
    public void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        this.mWhiteDegreeUniform = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"whiteDegree");
        this.mContrastUniform = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"contrast");
        this.mRuddyDegreeUniform = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"ruddyDegree");
    }

    public void setWhitenessLevel(float level) {
        LiteavLog.i(TAG, "setWhitenessLevel ".concat(String.valueOf(level)));
        this.mWhiteLevel = level;
        TXCBeautyBlend tXCBeautyBlend = this;
        tXCBeautyBlend.setFloatOnDraw(tXCBeautyBlend.mWhiteDegreeUniform, level);
    }

    public void setContract(float level) {
        LiteavLog.i(TAG, "setContract ".concat(String.valueOf(level)));
        this.mContract = level;
        TXCBeautyBlend tXCBeautyBlend = this;
        tXCBeautyBlend.setFloatOnDraw(tXCBeautyBlend.mContrastUniform, level / 10.0f + 1.0f);
    }

    public void setRuddyLevel(float level) {
        LiteavLog.i(TAG, "setRuddyLevel ".concat(String.valueOf(level)));
        this.mRuddyLevel = level;
        TXCBeautyBlend tXCBeautyBlend = this;
        tXCBeautyBlend.setFloatOnDraw(tXCBeautyBlend.mRuddyDegreeUniform, level / 2.0f);
    }

    @Override
    public boolean canBeSkipped() {
        TXCBeautyBlend tXCBeautyBlend = this;
        if (tXCBeautyBlend.isLessOrEqualZero(tXCBeautyBlend.mWhiteLevel)) {
            TXCBeautyBlend tXCBeautyBlend2 = this;
            if (tXCBeautyBlend2.isLessOrEqualZero(tXCBeautyBlend2.mRuddyLevel)) {
                TXCBeautyBlend tXCBeautyBlend3 = this;
                if (tXCBeautyBlend3.isLessOrEqualZero(tXCBeautyBlend3.mContract)) {
                    return true;
                }
            }
        }
        return false;
    }
}

