/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.beauty.gpufilters.smooth;

import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.beauty.gpufilters.BeautyInterFace;
import com.tencent.ugc.beauty.gpufilters.smooth.TXCBeautyBlend;
import com.tencent.ugc.beauty.gpufilters.smooth.TXCGPUSharpenAlphaFilter;
import com.tencent.ugc.beauty.gpufilters.smooth.TXCTILSmoothHorizontalFilter;
import com.tencent.ugc.beauty.gpufilters.smooth.TXCTILSmoothVerticalFilter;
import com.tencent.ugc.videobase.chain.TXCGPUImageTopoSortFilter;

public class BeautySmoothFilter
extends TXCGPUImageTopoSortFilter
implements BeautyInterFace {
    private static final String TAG = "BeautySmoothFilter";
    private final TXCTILSmoothHorizontalFilter mHorizontalFilter;
    private final TXCTILSmoothVerticalFilter mVerticalFilter;
    private final TXCGPUSharpenAlphaFilter mSharpenFilter;
    private final TXCBeautyBlend mBeautyBlendFilter = new TXCBeautyBlend();
    private float mSharpenLevel = 0.1f;
    private float mResampleRatio = 2.0f;
    private int mResampleWidth = 0;
    private int mResampleHeight = 0;

    public BeautySmoothFilter() {
        this.mHorizontalFilter = new TXCTILSmoothHorizontalFilter();
        this.mVerticalFilter = new TXCTILSmoothVerticalFilter();
        this.mSharpenFilter = new TXCGPUSharpenAlphaFilter();
        TXCGPUImageTopoSortFilter.Node node = this.getInitNode();
        BeautySmoothFilter beautySmoothFilter = this;
        TXCGPUImageTopoSortFilter.Node node2 = beautySmoothFilter.createNodeFromFilter(beautySmoothFilter.mHorizontalFilter);
        node2.setInputForOnDraw(node);
        BeautySmoothFilter beautySmoothFilter2 = this;
        TXCGPUImageTopoSortFilter.Node node3 = beautySmoothFilter2.createNodeFromFilter(beautySmoothFilter2.mVerticalFilter);
        node3.setInputForOnDraw(node2);
        node3.addExtraInput("inputImageTexture2", node);
        BeautySmoothFilter beautySmoothFilter3 = this;
        TXCGPUImageTopoSortFilter.Node node4 = beautySmoothFilter3.createNodeFromFilter(beautySmoothFilter3.mSharpenFilter);
        node4.setInputForOnDraw(node3);
        BeautySmoothFilter beautySmoothFilter4 = this;
        TXCGPUImageTopoSortFilter.Node node5 = beautySmoothFilter4.createNodeFromFilter(beautySmoothFilter4.mBeautyBlendFilter);
        node5.setInputForOnDraw(node4);
        node5.addExtraInput("inputImageTexture2", node);
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        this.mResampleWidth = width;
        this.mResampleHeight = height;
        if ((double)Math.abs(this.mResampleRatio - 1.0f) > 1.0E-5) {
            this.mResampleWidth = (int)((float)this.mResampleWidth / this.mResampleRatio);
            this.mResampleHeight = (int)((float)this.mResampleHeight / this.mResampleRatio);
        }
        LiteavLog.i(TAG, "mResampleRatio: %f, mResampleWidth: %d, mResampleHeight: %d", Float.valueOf(this.mResampleRatio), this.mResampleWidth, this.mResampleHeight);
        this.mHorizontalFilter.onOutputSizeChanged(this.mResampleWidth, this.mResampleHeight);
        this.mVerticalFilter.onOutputSizeChanged(this.mResampleWidth, this.mResampleHeight);
    }

    @Override
    public void setBeautyLevel(float level) {
        this.mVerticalFilter.setBeautyLevel(level);
    }

    @Override
    public void setWhitenessLevel(float level) {
        this.mBeautyBlendFilter.setWhitenessLevel(level);
    }

    @Override
    public void setRuddyLevel(float level) {
        this.mBeautyBlendFilter.setRuddyLevel(level);
    }

    @Override
    public void setSharpenLevel(float level) {
        LiteavLog.i(TAG, "setSharpenLevel ".concat(String.valueOf(level)));
        this.mSharpenLevel = level;
        this.mSharpenFilter.setSharpness(level / 1.2f);
    }

    @Override
    public boolean canBeSkipped() {
        return this.mVerticalFilter.canBeSkipped() && this.mBeautyBlendFilter.canBeSkipped() && this.mSharpenFilter.canBeSkipped();
    }
}

