/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.beauty.gpufilters;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import com.tencent.ugc.beauty.gpufilters.d;
import com.tencent.ugc.beauty.gpufilters.e;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import java.nio.FloatBuffer;

public class TXCGPULookupFilterGroup
extends TXCGPUImageFilter {
    private static final String LOOKUP_FILTER_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n\nuniform sampler2D inputImageTexture;\nuniform sampler2D inputImageTexture2; // lookup texture 1\nuniform sampler2D inputImageTexture3; // lookup texture 2\n\n\nuniform lowp vec3 v3_params;\nuniform lowp vec2 v2_texs;\n\n\nvoid main()\n{\n    lowp vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n\n    mediump float blueColor = textureColor.b * 63.0;\n\n    mediump vec2 quad1;\n    quad1.y = floor(floor(blueColor) / 8.0);\n    quad1.x = floor(blueColor) - (quad1.y * 8.0);\n\n    mediump vec2 quad2;\n    quad2.y = floor(ceil(blueColor) / 8.0);\n    quad2.x = ceil(blueColor) - (quad2.y * 8.0);\n\n    highp vec2 texPos1;\n    texPos1.x = (quad1.x * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.r);\n    texPos1.y = (quad1.y * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.g);\n\n    highp vec2 texPos2;\n    texPos2.x = (quad2.x * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.r);\n    texPos2.y = (quad2.y * 0.125) + 0.5/512.0 + ((0.125 - 1.0/512.0) * textureColor.g);\n\n    lowp vec4 newColor1;\n    lowp vec4 newColor2;\n    if(textureCoordinate.x <= v3_params.x) { \n      if(v2_texs.x == 1.0) { \n        newColor1 = texture2D(inputImageTexture2, texPos1);\n        newColor2 = texture2D(inputImageTexture2, texPos2);\n        lowp vec4 newColor = mix(newColor1, newColor2, fract(blueColor));\n        gl_FragColor = mix(textureColor, vec4(newColor.rgb, textureColor.w), v3_params.y);\n      } else { \n        gl_FragColor = textureColor;\n      } \n    } else {\n      if(v2_texs.y == 1.0) { \n        newColor1 = texture2D(inputImageTexture3, texPos1);\n        newColor2 = texture2D(inputImageTexture3, texPos2);\n        lowp vec4 newColor = mix(newColor1, newColor2, fract(blueColor));\n        gl_FragColor = mix(textureColor, vec4(newColor.rgb, textureColor.w), v3_params.z);\n      } else { \n        gl_FragColor = textureColor;\n      } \n    }\n }";
    private Bitmap mLeftBitmap = null;
    private int mLeftTextureUniform;
    private int mLeftTextureId = -1;
    private Bitmap mRightBitmap = null;
    private int mRightTextureUniform;
    private int mRightTextureId = -1;
    private int mParams3Location;
    private int mTexs2Location;
    private final FloatBuffer mParamsFloatBuffer = FloatBuffer.allocate(3);
    private final FloatBuffer mTexsFloatBuffer = FloatBuffer.allocate(2);

    public TXCGPULookupFilterGroup() {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nuniform mat4 textureTransform;\nvarying highp vec2 textureCoordinate;\nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (textureTransform * inputTextureCoordinate).xy;\n}", LOOKUP_FILTER_FRAGMENT_SHADER);
    }

    @Override
    public void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        this.mLeftTextureUniform = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"inputImageTexture2");
        this.mRightTextureUniform = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"inputImageTexture3");
        this.mParams3Location = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"v3_params");
        this.mTexs2Location = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"v2_texs");
        if (this.mLeftBitmap != null || this.mRightBitmap != null) {
            TXCGPULookupFilterGroup tXCGPULookupFilterGroup = this;
            tXCGPULookupFilterGroup.setBitmap(tXCGPULookupFilterGroup.mParamsFloatBuffer.get(0), this.mLeftBitmap, this.mParamsFloatBuffer.get(1), this.mRightBitmap, this.mParamsFloatBuffer.get(2));
            this.mLeftBitmap = null;
            this.mRightBitmap = null;
        }
    }

    public void setBitmap(float leftRatio, Bitmap leftBitmap, float leftIntensity, Bitmap rightBitmap, float rightIntensity) {
        TXCGPULookupFilterGroup tXCGPULookupFilterGroup = this;
        tXCGPULookupFilterGroup.runOnDraw(d.a(tXCGPULookupFilterGroup, leftRatio, leftIntensity, rightIntensity, leftBitmap, rightBitmap));
    }

    public void setIntensity(float intensity) {
        TXCGPULookupFilterGroup tXCGPULookupFilterGroup = this;
        tXCGPULookupFilterGroup.runOnDraw(e.a(tXCGPULookupFilterGroup, intensity));
    }

    @Override
    public void onUninit() {
        super.onUninit();
        OpenGlUtils.deleteTexture(this.mLeftTextureId);
        OpenGlUtils.deleteTexture(this.mRightTextureId);
        this.mLeftTextureId = -1;
        this.mRightTextureId = -1;
    }

    @Override
    public void beforeDrawArrays(int textureId) {
        super.beforeDrawArrays(textureId);
        if (this.mLeftTextureId != -1) {
            GLES20.glActiveTexture((int)33987);
            GLES20.glBindTexture((int)3553, (int)this.mLeftTextureId);
            GLES20.glUniform1i((int)this.mLeftTextureUniform, (int)3);
        }
        if (this.mRightTextureId != -1) {
            GLES20.glActiveTexture((int)33988);
            GLES20.glBindTexture((int)3553, (int)this.mRightTextureId);
            GLES20.glUniform1i((int)this.mRightTextureUniform, (int)4);
        }
        GLES20.glUniform2fv((int)this.mTexs2Location, (int)1, (FloatBuffer)this.mTexsFloatBuffer);
        GLES20.glUniform3fv((int)this.mParams3Location, (int)1, (FloatBuffer)this.mParamsFloatBuffer);
    }

    @Override
    public void afterDrawArrays() {
        super.afterDrawArrays();
        if (this.mLeftTextureId != -1) {
            GLES20.glActiveTexture((int)33987);
            GLES20.glBindTexture((int)3553, (int)0);
        }
        if (this.mRightTextureId != -1) {
            GLES20.glActiveTexture((int)33988);
            GLES20.glBindTexture((int)3553, (int)0);
        }
    }

    static /* synthetic */ void lambda$setIntensity$1(TXCGPULookupFilterGroup this_, float intensity) {
        this_.mParamsFloatBuffer.put(1, intensity);
        this_.mParamsFloatBuffer.put(2, 0.0f);
    }

    static /* synthetic */ void lambda$setBitmap$0(TXCGPULookupFilterGroup this_, float leftRatio, float leftIntensity, float rightIntensity, Bitmap leftBitmap, Bitmap rightBitmap) {
        this_.mParamsFloatBuffer.put(0, leftRatio);
        this_.mParamsFloatBuffer.put(1, leftIntensity);
        this_.mParamsFloatBuffer.put(2, rightIntensity);
        if (leftBitmap == null) {
            OpenGlUtils.deleteTexture(this_.mLeftTextureId);
            this_.mLeftTextureId = -1;
            this_.mTexsFloatBuffer.put(0, 0.0f);
        } else if (leftBitmap != this_.mLeftBitmap) {
            this_.mLeftTextureId = OpenGlUtils.loadTexture(leftBitmap, this_.mLeftTextureId, false);
            this_.mTexsFloatBuffer.put(0, 1.0f);
        }
        if (rightBitmap == null) {
            OpenGlUtils.deleteTexture(this_.mRightTextureId);
            this_.mRightTextureId = -1;
            this_.mTexsFloatBuffer.put(1, 0.0f);
        } else if (rightBitmap != this_.mRightBitmap) {
            this_.mRightTextureId = OpenGlUtils.loadTexture(rightBitmap, this_.mRightTextureId, false);
            this_.mTexsFloatBuffer.put(1, 1.0f);
        }
        this_.mLeftBitmap = leftBitmap;
        this_.mRightBitmap = rightBitmap;
    }
}

