/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.beauty.gpufilters;

import android.opengl.GLES20;
import com.tencent.liteav.base.util.l;
import com.tencent.ugc.beauty.NativeLoad;
import com.tencent.ugc.beauty.gpufilters.TXCGPUBoxBlurFilter;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.filter.TXCGPUThreeInputFilter;
import com.tencent.ugc.videobase.filter.TXCGPUTwoInputFilter;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import java.nio.FloatBuffer;

public class TXCGPUFaceFilter
extends TXCGPUImageFilter {
    private static final String bShaderFragmentShader = "precision highp float;\nuniform sampler2D inputImageTexture;\nuniform sampler2D inputImageTexture2;\nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate2;\nvoid main()\n{\n    gl_FragColor = texture2D(inputImageTexture2, textureCoordinate2) - texture2D(inputImageTexture, textureCoordinate) * texture2D(inputImageTexture2, textureCoordinate2);\n}\n";
    private static final String retShaderFragmentShader = "precision highp float;\nuniform sampler2D inputImageTexture;\nuniform sampler2D inputImageTexture2;\nuniform sampler2D inputImageTexture3;\nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate2;\nvarying vec2 textureCoordinate3;\nvoid main()\n{\n    gl_FragColor = texture2D(inputImageTexture, textureCoordinate) * texture2D(inputImageTexture3, textureCoordinate3) + texture2D(inputImageTexture2, textureCoordinate2);\n}\n";
    private final FloatBuffer mNormalCubeVerticesBuffer = OpenGlUtils.createNormalCubeVerticesBuffer();
    private final FloatBuffer mNormalTextureCoordsBuffer = OpenGlUtils.createTextureCoordsBuffer(l.a, false, false);
    private final TXCGPUBoxBlurFilter mBoxFilter = new TXCGPUBoxBlurFilter();
    private final TXCGPUImageFilter mNormalFilter;
    private final c mVarShader = new c();
    private final a mBShader = new a("precision highp float;\nuniform sampler2D inputImageTexture;\nuniform sampler2D inputImageTexture2;\nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate2;\nvoid main()\n{\n    gl_FragColor = texture2D(inputImageTexture2, textureCoordinate2) - texture2D(inputImageTexture, textureCoordinate) * texture2D(inputImageTexture2, textureCoordinate2);\n}\n");
    private final b mRetShader = new b("precision highp float;\nuniform sampler2D inputImageTexture;\nuniform sampler2D inputImageTexture2;\nuniform sampler2D inputImageTexture3;\nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate2;\nvarying vec2 textureCoordinate3;\nvoid main()\n{\n    gl_FragColor = texture2D(inputImageTexture, textureCoordinate) * texture2D(inputImageTexture3, textureCoordinate3) + texture2D(inputImageTexture2, textureCoordinate2);\n}\n");
    private float mSamplingRatio = 4.0f;
    private int mSamplingWidth;
    private int mSamplingHeight;
    private boolean mCustomizeSamplingRatio;

    public TXCGPUFaceFilter() {
        this.mNormalFilter = new TXCGPUImageFilter();
    }

    @Override
    public void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        this.mBoxFilter.initialize(texturePool);
        this.mVarShader.initialize(texturePool);
        this.mBShader.initialize(texturePool);
        this.mRetShader.initialize(texturePool);
        this.mNormalFilter.initialize(texturePool);
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        if (!this.mCustomizeSamplingRatio) {
            this.mSamplingRatio = width < height ? (width < 540 ? 1.0f : 4.0f) : (height < 540 ? 1.0f : 4.0f);
        }
        if (Float.compare(this.mSamplingRatio, 1.0f) == 0) {
            this.mSamplingWidth = width;
            this.mSamplingHeight = height;
        } else {
            this.mSamplingWidth = (int)((float)width / this.mSamplingRatio);
            this.mSamplingHeight = (int)((float)height / this.mSamplingRatio);
        }
        this.mNormalFilter.onOutputSizeChanged(this.mSamplingWidth, this.mSamplingHeight);
        this.mVarShader.onOutputSizeChanged(this.mSamplingWidth, this.mSamplingHeight);
        this.mBShader.onOutputSizeChanged(this.mSamplingWidth, this.mSamplingHeight);
        this.mRetShader.onOutputSizeChanged(width, height);
        this.mBoxFilter.onOutputSizeChanged(this.mSamplingWidth, this.mSamplingHeight);
    }

    @Override
    public void onDraw(int inTextureId, GLTexture outTexture, FloatBuffer cubeCoordsBuffer, FloatBuffer textureCoordsBuffer) {
        if (!this.isInitialized()) {
            return;
        }
        this.runPendingOnDrawTasks();
        int n2 = inTextureId;
        GLTexture gLTexture = null;
        if (this.mSamplingWidth != this.mOutputSize.width || this.mSamplingHeight != this.mOutputSize.height) {
            gLTexture = this.mTexturePool.obtain(this.mSamplingWidth, this.mSamplingHeight);
            GLES20.glViewport((int)0, (int)0, (int)this.mSamplingWidth, (int)this.mSamplingHeight);
            this.mNormalFilter.onDraw(inTextureId, gLTexture, cubeCoordsBuffer, textureCoordsBuffer);
            n2 = gLTexture.getId();
        }
        GLTexture gLTexture2 = this.mTexturePool.obtain(this.mSamplingWidth, this.mSamplingHeight);
        GLTexture gLTexture3 = this.mTexturePool.obtain(this.mSamplingWidth, this.mSamplingHeight);
        this.mBoxFilter.onDraw(n2, gLTexture2, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer);
        this.mVarShader.setSecondInputTexture(gLTexture2.getId());
        this.mVarShader.onDraw(n2, gLTexture3, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer);
        if (gLTexture != null) {
            gLTexture.release();
        }
        GLTexture gLTexture4 = this.mTexturePool.obtain(this.mSamplingWidth, this.mSamplingHeight);
        this.mBShader.setSecondInputTexture(gLTexture2.getId());
        this.mBShader.onDraw(gLTexture3.getId(), gLTexture4, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer);
        gLTexture2.release();
        GLTexture gLTexture5 = this.mTexturePool.obtain(this.mSamplingWidth, this.mSamplingHeight);
        this.mBoxFilter.onDraw(gLTexture3.getId(), gLTexture5, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer);
        gLTexture3.release();
        GLTexture gLTexture6 = this.mTexturePool.obtain(this.mSamplingWidth, this.mSamplingHeight);
        this.mBoxFilter.onDraw(gLTexture4.getId(), gLTexture6, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer);
        gLTexture4.release();
        if (this.mSamplingRatio != 1.0f) {
            GLTexture gLTexture7 = this.mTexturePool.obtain(this.mOutputSize.width, this.mOutputSize.height);
            GLTexture gLTexture8 = this.mTexturePool.obtain(this.mOutputSize.width, this.mOutputSize.height);
            GLES20.glViewport((int)0, (int)0, (int)this.mOutputSize.width, (int)this.mOutputSize.height);
            this.mNormalFilter.onDraw(gLTexture5.getId(), gLTexture7, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer);
            this.mNormalFilter.onDraw(gLTexture6.getId(), gLTexture8, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer);
            this.mRetShader.setSecondInputTexture(gLTexture8.getId());
            this.mRetShader.setThirdInputTexture(inTextureId);
            this.mRetShader.onDraw(gLTexture7.getId(), outTexture, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer);
            gLTexture7.release();
            gLTexture8.release();
        } else {
            this.mRetShader.setSecondInputTexture(gLTexture6.getId());
            this.mRetShader.setThirdInputTexture(inTextureId);
            this.mRetShader.onDraw(gLTexture5.getId(), outTexture, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer);
        }
        gLTexture6.release();
        gLTexture5.release();
    }

    @Override
    public void onUninit() {
        super.onUninit();
        this.mBoxFilter.uninitialize();
        this.mVarShader.uninitialize();
        this.mBShader.uninitialize();
        this.mRetShader.uninitialize();
        this.mNormalFilter.uninitialize();
    }

    public void setSamplingRatio(float ratio) {
        this.mSamplingRatio = ratio;
        this.mCustomizeSamplingRatio = true;
    }

    static final class b
    extends TXCGPUThreeInputFilter {
        public b(String string) {
            super(string);
        }
    }

    static final class a
    extends TXCGPUTwoInputFilter {
        public a(String string) {
            super(string);
        }
    }

    static final class c
    extends TXCGPUTwoInputFilter {
        private int a;
        private int b;

        public c() {
            super(null, null);
        }

        @Override
        public final int buildProgram() {
            return NativeLoad.nativeLoadGLProgram(2);
        }

        @Override
        public final void onInit(GLTexturePool texturePool) {
            super.onInit(texturePool);
            this.a = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"texelWidthOffset");
            this.b = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"texelHeightOffset");
        }

        @Override
        public final void onOutputSizeChanged(int width, int height) {
            super.onOutputSizeChanged(width, height);
            c c2 = this;
            c2.setFloatOnDraw(c2.a, 1.5f / (float)this.mOutputSize.width);
            c c3 = this;
            c3.setFloatOnDraw(c3.b, 1.5f / (float)this.mOutputSize.height);
        }
    }
}

